package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.StoreBalanceEntity;
import com.ejianc.business.material.mapper.StoreBalanceMapper;
import com.ejianc.business.material.service.IStoreBalanceService;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.StoreBalanceDetailVO;
import com.ejianc.business.material.vo.StoreBalanceVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物资结存
 *
 * @author generator
 */
@Service("storeBalanceService")
public class StoreBalanceServiceImpl extends BaseServiceImpl<StoreBalanceMapper, StoreBalanceEntity> implements IStoreBalanceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private StoreBalanceMapper storeBalanceMapper;

    @Autowired
    private IStoreBalanceService storeBalanceService;

    @Override
    public StoreBalanceVO queryStoreBalanceByProjectId(Long projectId, String month,String storeId) {

        StoreBalanceVO storeBalanceVO = new StoreBalanceVO();
        String resMonth = DateUtils.dateSimple4(month);
        List<FlowmeterEntity> flowmeterEntityList = storeBalanceMapper.queryFlowmeetrAll(projectId, resMonth,Long.parseLong(storeId));
        List<FlowmeterEntity> flowmeterEntities = this.packageFlowmeter(flowmeterEntityList);
        //本月有出入库流水数据
        List<StoreBalanceDetailVO> storeBalanceDetailVOS = new ArrayList<>();
        for(FlowmeterEntity flowmeterEntity : flowmeterEntities){
            StoreBalanceDetailVO storeBalanceDetailVO = new StoreBalanceDetailVO();
            storeBalanceDetailVO.setId(IdWorker.getId());
            storeBalanceDetailVO.setMaterialCategoryId(flowmeterEntity.getMaterialCategoryId());
            storeBalanceDetailVO.setMaterialCategoryCode(flowmeterEntity.getMaterialCategoryCode());
            storeBalanceDetailVO.setMaterialCategoryName(flowmeterEntity.getMaterialCategoryName());
            storeBalanceDetailVO.setMaterialId(flowmeterEntity.getMaterialId());
            storeBalanceDetailVO.setMaterialCode(flowmeterEntity.getMaterialCode());
            storeBalanceDetailVO.setMaterialName(flowmeterEntity.getMaterialName());
            storeBalanceDetailVO.setMaterialSpec(flowmeterEntity.getSpecialModel());
            storeBalanceDetailVO.setMaterialUnit(flowmeterEntity.getMeasurementUnit());
            storeBalanceDetailVO.setStoreId(flowmeterEntity.getStoreId());
            storeBalanceDetailVO.setProjectId(flowmeterEntity.getProjectId());

            //入库
            storeBalanceDetailVO.setInstoreQuantity(flowmeterEntity.getEnterQuantity());//入库数量
            storeBalanceDetailVO.setInstoreUnitPriceTax(flowmeterEntity.getEnterUnitPriceIncluetax());//本月入库单价（含税）（元）
            storeBalanceDetailVO.setInstoreUnitPriceUntax(flowmeterEntity.getEnterUnitPriceExcluetax());//本月入库单价（无税）
            storeBalanceDetailVO.setInstoreAmountTax(flowmeterEntity.getEnterAmountIncluetax());//本月入库金额（含税）
            storeBalanceDetailVO.setInstoreAmountUntax(flowmeterEntity.getEnterAmountExcluetax());//本月入库金额（无税）

            //出库
            storeBalanceDetailVO.setDeliveryQuantity(flowmeterEntity.getDeliveryQuantity());//出库数量
            storeBalanceDetailVO.setDeliveryAmountIncluetax(flowmeterEntity.getDeliveryAmountIncluetax());//出库含税金额
            storeBalanceDetailVO.setDeliveryAmountExcluetax(flowmeterEntity.getDeliveryAmountExcluetax());//出库无税金额
            storeBalanceDetailVO.setDeliveryUnitPriceIncluetax(flowmeterEntity.getDeliveryUnitPriceIncluetax());//出库含税单价
            storeBalanceDetailVO.setDeliveryUnitPriceExcluetax(flowmeterEntity.getDeliveryUnitPriceExcluetax());//出库不含税单价

            storeBalanceDetailVOS.add(storeBalanceDetailVO);
        }

        StoreBalanceDetailVO storeBalanceDetailVO2 = storeBalanceMapper.queryId(projectId,Long.parseLong(storeId));
        Long id = null;
        if(storeBalanceDetailVO2 != null){
            id = storeBalanceDetailVO2.getId();
        }
        //查询上个单据中本月实盘数量大于0的数据
        List<StoreBalanceDetailVO> storeBalanceDetailVOList = new ArrayList<>();
        if(id != null){
            storeBalanceDetailVOList = queryLastMonthList(id);
        }

        //本月上月合集
        List<StoreBalanceDetailVO> voList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(storeBalanceDetailVOS)){
            voList.addAll(storeBalanceDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(storeBalanceDetailVOList)){
            for(StoreBalanceDetailVO  storeBalanceDetailVO :storeBalanceDetailVOList){
                storeBalanceDetailVO.setStoreId(Long.parseLong(storeId));
                storeBalanceDetailVO.setProjectId(projectId);
            }
            voList.addAll(storeBalanceDetailVOList);
        }
        //返回数据集
        List<StoreBalanceDetailVO> detailVOS = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(voList)){
            List<StoreBalanceDetailVO> detailVOList = voList.stream()
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getMaterialId()+"_"+f.getProjectId()+"_"+f.getStoreId()))), ArrayList::new));

            for(StoreBalanceDetailVO storeBalanceDetailVO : detailVOList){
                StoreBalanceDetailVO storeBalanceDetailVO1 = new StoreBalanceDetailVO();
                storeBalanceDetailVO1.setId(IdWorker.getId());
                storeBalanceDetailVO1.setProjectId(storeBalanceDetailVO.getProjectId());
                storeBalanceDetailVO1.setProjectName(storeBalanceDetailVO.getProjectName());
                storeBalanceDetailVO1.setStoreId(storeBalanceDetailVO.getStoreId());
                storeBalanceDetailVO1.setStoreName(storeBalanceDetailVO.getStoreName());
                storeBalanceDetailVO1.setMaterialCategoryCode(storeBalanceDetailVO.getMaterialCategoryCode());
                storeBalanceDetailVO1.setMaterialCategoryName(storeBalanceDetailVO.getMaterialCategoryName());
                storeBalanceDetailVO1.setMaterialId(storeBalanceDetailVO.getMaterialId());
                storeBalanceDetailVO1.setMaterialCode(storeBalanceDetailVO.getMaterialCode());
                storeBalanceDetailVO1.setMaterialName(storeBalanceDetailVO.getMaterialName());
                storeBalanceDetailVO1.setMaterialSpec(storeBalanceDetailVO.getMaterialSpec());
                storeBalanceDetailVO1.setMaterialUnit(storeBalanceDetailVO.getMaterialUnit());
                detailVOS.add(storeBalanceDetailVO1);
            }
        }

        //塞入上期数据
        if(CollectionUtils.isNotEmpty(storeBalanceDetailVOList)){
            Map<Long,StoreBalanceDetailVO> maps = storeBalanceDetailVOList.stream().collect(Collectors.toMap(x->x.getProjectId()+x.getMaterialId()+x.getStoreId(), Function.identity(),(k1, k2) ->k2));
            StoreBalanceDetailVO cvo;
            Long k;
            for (StoreBalanceDetailVO vo : detailVOS) {
                k=vo.getProjectId()+vo.getMaterialId()+vo.getStoreId();
                if (maps.containsKey(k)){
                    cvo = maps.get(k);
                    vo.setLastQuantity(cvo.getActualCheckQuantity());//本月实盘数量
                    vo.setLastUnitPriceTax(cvo.getActualUnitPriceTax());//本月实盘单价（含税）（元）
                    vo.setLastUnitPriceUntax(cvo.getActualUnitPriceUntax());// 本月实盘单价（无税）
                    vo.setLastAmountTax(cvo.getActualAmountTax()); // 本月实盘金额（含税）
                    vo.setLastAmountUntax(cvo.getActualAmountUntax()); // 本月实盘金额（无税）
                }
            }
        }

        //塞入本期数据 入库 出库
        if(CollectionUtils.isNotEmpty(storeBalanceDetailVOS)){
            Map<Long,StoreBalanceDetailVO> maps = storeBalanceDetailVOS.stream().collect(Collectors.toMap(x->x.getProjectId()+x.getMaterialId()+x.getStoreId(), Function.identity(),(k1, k2) ->k2));
            StoreBalanceDetailVO cvo;
            Long k;
            for (StoreBalanceDetailVO vo : detailVOS) {
                k=vo.getProjectId()+vo.getMaterialId()+vo.getStoreId();
                if (maps.containsKey(k)){
                    cvo = maps.get(k);
                    //入库
                    vo.setInstoreQuantity(cvo.getInstoreQuantity());//入库数量
                    vo.setInstoreUnitPriceTax(cvo.getInstoreUnitPriceTax());//本月入库单价（含税）（元）
                    vo.setInstoreUnitPriceUntax(cvo.getInstoreUnitPriceUntax());//本月入库单价（无税）
                    vo.setInstoreAmountTax(cvo.getInstoreAmountTax());//本月入库金额（含税）
                    vo.setInstoreAmountUntax(cvo.getInstoreAmountUntax());//本月入库金额（无税）

                    //出库
                    //  本期出库单价改为   (上期结存金额+本期入金额) /(上期结存数量+本期入数量)金额=量*单价 含税
                    vo.setDeliveryUnitPriceIncluetax(ComputeUtil.safeDiv(ComputeUtil.safeAdd(vo.getLastAmountTax(),vo.getInstoreAmountTax()), ComputeUtil.safeAdd(vo.getLastQuantity(),vo.getInstoreQuantity())));//出库含税单价
                    vo.setDeliveryUnitPriceExcluetax(ComputeUtil.safeDiv(ComputeUtil.safeAdd(vo.getLastAmountUntax(),vo.getInstoreAmountUntax()),ComputeUtil.safeAdd(vo.getLastQuantity(),vo.getInstoreQuantity())));//出库不含税单价
                    vo.setDeliveryQuantity(cvo.getDeliveryQuantity());//出库数量
                    vo.setDeliveryAmountIncluetax(ComputeUtil.safeMultiply(cvo.getDeliveryQuantity(),vo.getDeliveryUnitPriceIncluetax()));//出库含税金额
                    vo.setDeliveryAmountExcluetax(ComputeUtil.safeMultiply(cvo.getDeliveryQuantity(),vo.getDeliveryUnitPriceExcluetax()));//出库无税金额

                }
            }
        }

        //计算本月结存数量
        if(CollectionUtils.isNotEmpty(detailVOS)){
            for (StoreBalanceDetailVO vo : detailVOS) {
                // 本月结存单价（含税）（元）
                vo.setCurrentUnitPriceTax(ComputeUtil.safeDiv(ComputeUtil.safeAdd(vo.getLastAmountTax(),vo.getInstoreAmountTax()), ComputeUtil.safeAdd(vo.getLastQuantity(),vo.getInstoreQuantity())));//本期结存含税单价
                // 本月结存单价（无税）
                vo.setCurrentUnitPriceUntax(ComputeUtil.safeDiv(ComputeUtil.safeAdd(vo.getLastAmountUntax(),vo.getInstoreAmountUntax()),ComputeUtil.safeAdd(vo.getLastQuantity(),vo.getInstoreQuantity())));//本期结存无税单价
                // 本月结存数量
                vo.setCurrentQuantity(ComputeUtil.safeSub(ComputeUtil.safeAdd(vo.getLastQuantity(),vo.getInstoreQuantity()),vo.getDeliveryQuantity()));
                // 本月结存金额（含税）
                vo.setCurrentAmountTax(ComputeUtil.safeMultiply(vo.getCurrentUnitPriceTax(), vo.getCurrentQuantity()));//本期结存含税金额
                // 本月结存金额（无税）
                vo.setCurrentAmountUntax(ComputeUtil.safeMultiply(vo.getCurrentUnitPriceUntax(), vo.getCurrentQuantity()));//本期结存不含税金额
            }
        }

        //计算本月消耗  直接最后计算本月消耗
        for(StoreBalanceDetailVO storeBalanceDetailVO : detailVOS){
            // 本月实盘单价（含税）（元）
            storeBalanceDetailVO.setActualUnitPriceTax(storeBalanceDetailVO.getCurrentUnitPriceTax());
            // 本月实盘单价（无税）
            storeBalanceDetailVO.setActualUnitPriceUntax(storeBalanceDetailVO.getCurrentUnitPriceUntax());
            //本月实盘数量
            storeBalanceDetailVO.setActualCheckQuantity(storeBalanceDetailVO.getCurrentQuantity());
            // 本月实盘金额（含税）
            storeBalanceDetailVO.setActualAmountTax(ComputeUtil.safeMultiply(storeBalanceDetailVO.getCurrentQuantity(),storeBalanceDetailVO.getCurrentUnitPriceTax()));
            // 本月实盘金额（无税）
            storeBalanceDetailVO.setActualAmountUntax(ComputeUtil.safeMultiply(storeBalanceDetailVO.getCurrentQuantity(),storeBalanceDetailVO.getCurrentUnitPriceUntax()));

            //本月消耗数量 = 上月结存 + 本月入库 - 本月实盘数量
            storeBalanceDetailVO.setOutstoreQuantity(ComputeUtil.safeSub(ComputeUtil.safeAdd(storeBalanceDetailVO.getLastQuantity(),storeBalanceDetailVO.getInstoreQuantity()),storeBalanceDetailVO.getActualCheckQuantity()));
            // 本月消耗      上期结存+本月入-本月实盘计算数量，金额，反算单价
            storeBalanceDetailVO.setOutstoreAmountTax(ComputeUtil.safeSub( ComputeUtil.safeAdd(storeBalanceDetailVO.getLastAmountTax(),storeBalanceDetailVO.getInstoreAmountTax()),storeBalanceDetailVO.getActualAmountTax()));
            // 本月消耗金额（无税）上期结存+本月入-本月实盘计算数量，金额，反算单价
            storeBalanceDetailVO.setOutstoreAmountUntax(ComputeUtil.safeSub(ComputeUtil.safeAdd(storeBalanceDetailVO.getLastAmountUntax(),storeBalanceDetailVO.getInstoreAmountUntax()),storeBalanceDetailVO.getActualAmountUntax()));
            //本月消耗单价（含税） = 金额/数量
            storeBalanceDetailVO.setOutstoreUnitPriceTax(ComputeUtil.safeDiv(storeBalanceDetailVO.getOutstoreAmountTax(), storeBalanceDetailVO.getOutstoreQuantity()));
            //本月消耗单价（无税） = 金额/数量
            storeBalanceDetailVO.setOutstoreUnitPriceUntax(ComputeUtil.safeDiv(storeBalanceDetailVO.getOutstoreAmountUntax(), storeBalanceDetailVO.getOutstoreQuantity()));
        }
        //汇总
        BigDecimal lastQuantityTotal = new BigDecimal(0);//上月结存数量
        BigDecimal lastAmountUntaxTotal = new BigDecimal(0);//上月结存金额（无税）
        BigDecimal lastAmountTaxTotal = new BigDecimal(0);//上月结存金额（含税）

        BigDecimal instoreQuantityTotal = new BigDecimal(0);//本月入库数量
        BigDecimal instoreAmountUntaxTotal = new BigDecimal(0);//本月入库金额（无税）
        BigDecimal instoreAmountTaxTotal = new BigDecimal(0);//本月入库金额（含税）

        BigDecimal currentQuantityTotal = new BigDecimal(0);//本月结存数量
        BigDecimal currentAmountTaxTotal = new BigDecimal(0);//本月结存金额（含税）
        BigDecimal currentAmountUntaxTotal = new BigDecimal(0);//本月结存金额（无税）

        BigDecimal outstoreQuantityTotal = new BigDecimal(0);//本月消耗数量
        BigDecimal outstoreAmountUntaxTotal = new BigDecimal(0);//本月消耗金额（无税）
        BigDecimal outstoreAmountTaxTotal = new BigDecimal(0);//本月消耗金额（含税）

        for(StoreBalanceDetailVO storeBalanceDetailVO : detailVOS){
            lastQuantityTotal = ComputeUtil.safeAdd(lastQuantityTotal,storeBalanceDetailVO.getLastQuantity());
            lastAmountUntaxTotal = ComputeUtil.safeAdd(lastAmountUntaxTotal,storeBalanceDetailVO.getLastAmountUntax());
            lastAmountTaxTotal = ComputeUtil.safeAdd(lastAmountTaxTotal,storeBalanceDetailVO.getLastAmountTax());

            instoreQuantityTotal = ComputeUtil.safeAdd(instoreQuantityTotal,storeBalanceDetailVO.getInstoreQuantity());
            instoreAmountUntaxTotal = ComputeUtil.safeAdd(instoreAmountUntaxTotal,storeBalanceDetailVO.getInstoreAmountUntax());
            instoreAmountTaxTotal = ComputeUtil.safeAdd(instoreAmountTaxTotal,storeBalanceDetailVO.getInstoreAmountTax());

            currentQuantityTotal = ComputeUtil.safeAdd(currentQuantityTotal,storeBalanceDetailVO.getCurrentQuantity());
            currentAmountTaxTotal = ComputeUtil.safeAdd(currentAmountTaxTotal,storeBalanceDetailVO.getCurrentAmountTax());
            currentAmountUntaxTotal = ComputeUtil.safeAdd(currentAmountUntaxTotal,storeBalanceDetailVO.getCurrentAmountUntax());

            outstoreQuantityTotal = ComputeUtil.safeAdd(outstoreQuantityTotal,storeBalanceDetailVO.getOutstoreQuantity());
            outstoreAmountUntaxTotal = ComputeUtil.safeAdd(outstoreAmountUntaxTotal,storeBalanceDetailVO.getOutstoreAmountUntax());
            outstoreAmountTaxTotal = ComputeUtil.safeAdd(outstoreAmountTaxTotal,storeBalanceDetailVO.getOutstoreAmountTax());
        }
        storeBalanceVO.setLastQuantityTotal(lastQuantityTotal);
        storeBalanceVO.setLastAmountUntaxTotal(lastAmountUntaxTotal);
        storeBalanceVO.setLastAmountTaxTotal(lastAmountTaxTotal);

        storeBalanceVO.setInstoreQuantityTotal(instoreQuantityTotal);
        storeBalanceVO.setInstoreAmountUntaxTotal(instoreAmountUntaxTotal);
        storeBalanceVO.setInstoreAmountTaxTotal(instoreAmountTaxTotal);

        storeBalanceVO.setCurrentQuantityTotal(currentQuantityTotal);
        storeBalanceVO.setCurrentAmountTaxTotal(currentAmountTaxTotal);
        storeBalanceVO.setCurrentAmountUntaxTotal(currentAmountUntaxTotal);

        storeBalanceVO.setOutstoreQuantityTotal(outstoreQuantityTotal);
        storeBalanceVO.setOutstoreAmountUntaxTotal(outstoreAmountUntaxTotal);
        storeBalanceVO.setOutstoreAmountTaxTotal(outstoreAmountTaxTotal);

        storeBalanceVO.setStoreBalanceDetailEntities(detailVOS);
        return storeBalanceVO;
    }

    @Override
    public com.ejianc.foundation.material.vo.StoreBalanceDetailVO queryStoreBalanceMonth(Long projectId, String month, String materialCategoryCode) {
        List<com.ejianc.foundation.material.vo.StoreBalanceDetailVO> storeBalanceDetailList = storeBalanceMapper.queryStoreBalanceDetailMonth(projectId, month, materialCategoryCode);
        logger.info("---------根据项目、月份、物资分类查询物资结存表入参--------");
        logger.info("projectId：" + projectId);
        logger.info("month：" + month);
        logger.info("materialCategoryCode：" + materialCategoryCode);
        logger.info("---------storeBalanceDetailList--------" + JSON.toJSONString(storeBalanceDetailList));

        if(storeBalanceDetailList != null && storeBalanceDetailList.size() > 0){
            return storeBalanceDetailList.get(0);
        }
        return null;
    }

    @Override
    public List<com.ejianc.foundation.material.vo.StoreBalanceDetailVO> queryMaterialConsumeMonth(Long projectId, String month) {
        return storeBalanceMapper.queryMaterialConsumeMonth(projectId,month);
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<StoreBalanceEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( month, '%Y-%m' )",monthStr);
        List<StoreBalanceEntity> list = storeBalanceService.list(query);
        if (!list.isEmpty()){
            for (StoreBalanceEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = storeBalanceService.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<StoreBalanceEntity> query = new LambdaQueryWrapper<StoreBalanceEntity>()
                .eq(StoreBalanceEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(month, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(StoreBalanceEntity::getIsSettlement)
                        .or().eq(StoreBalanceEntity::getIsSettlement, 0));
        int count = storeBalanceService.count(query);
        if (count > 0) throw new BusinessException("物资结存有往期未归集的数据,无法归集本月成本！");
        LambdaQueryWrapper<StoreBalanceEntity> query1 = new LambdaQueryWrapper<StoreBalanceEntity>()
                .eq(StoreBalanceEntity::getProjectId, projectId)
                .ne(StoreBalanceEntity::getBillState, 1)
                .ne(StoreBalanceEntity::getBillState, 3)
                .apply("DATE_FORMAT(month, '%Y-%m') = '" + monthStr + "'");
        int count1 = storeBalanceService.count(query1);
        if (count1 > 0) throw new BusinessException("物资结存有本期审批未通过的数据,无法归集本月成本！");

        LambdaQueryWrapper<StoreBalanceEntity> query2 = new LambdaQueryWrapper<StoreBalanceEntity>()
                .eq(StoreBalanceEntity::getProjectId, projectId)
                .in(StoreBalanceEntity::getBillState, 1,3)
                .apply("DATE_FORMAT(month, '%Y-%m') = '" + monthStr + "'");
        int count2 = storeBalanceService.count(query2);
        if (count2 > 0){
            throw new BusinessException("物资结存没有本期已生效的数据,无法归集本月成本！");
        }
        return true;
    }

    @Override
    public List<com.ejianc.business.material.vo.StoreBalanceDetailVO> queryLastMonthList(Long id) {
        return storeBalanceMapper.queryLastMonthList(id);
    }

    private List<FlowmeterEntity>  packageFlowmeter(List<FlowmeterEntity> flowmeterEntityList){

        List<FlowmeterEntity> flowmeterEntityArrayList = new ArrayList<>();

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(flowmeterEntityList)) {
            List<FlowmeterEntity> flowmeterEntityListNew = flowmeterEntityList.stream()
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getMaterialId()+"_"+f.getProjectId()))), ArrayList::new));


            //入库数量
            Map<String, BigDecimal> enterQuantityMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //入库含税金额
            Map<String, BigDecimal> enterAmountIncluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //入库无税金额
            Map<String, BigDecimal> enterAmountExcluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));


            //出库数量
            Map<String, BigDecimal> deliveryQuantityMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //出库含税金额
            Map<String, BigDecimal> deliveryAmountIncluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //出库无税金额
            Map<String, BigDecimal> deliveryAmountExcluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));

            BigDecimal enterQuantity = BigDecimal.ZERO;//本期入库数量
            BigDecimal enterAmountIncluetax = BigDecimal.ZERO;//本期入库含税金额
            BigDecimal enterAmountExcluetax = BigDecimal.ZERO;//本期入库不含税金额
            BigDecimal enterUnitPriceIncluetax = BigDecimal.ZERO;//本期入库含税单价
            BigDecimal enterUnitPriceExcluetax = BigDecimal.ZERO;//本期入库不含税单价

            BigDecimal deliveryQuantity = BigDecimal.ZERO;//本期出库数量
            BigDecimal deliveryAmountIncluetax = BigDecimal.ZERO;//本期出库含税金额
            BigDecimal deliveryAmountExcluetax = BigDecimal.ZERO;//本期出库不含税金额
            BigDecimal deliveryUnitPriceIncluetax = BigDecimal.ZERO;//本期出库含税单价
            BigDecimal deliveryUnitPriceExcluetax = BigDecimal.ZERO;//本期出库不含税单价

            for (FlowmeterEntity flowmeterEntity : flowmeterEntityListNew) {
                enterQuantity = BigDecimal.ZERO;
                enterAmountIncluetax = BigDecimal.ZERO;
                enterAmountExcluetax = BigDecimal.ZERO;
                enterUnitPriceIncluetax = BigDecimal.ZERO;//本期入库含税单价
                enterUnitPriceExcluetax = BigDecimal.ZERO;//本期入库不含税单价

                deliveryQuantity = BigDecimal.ZERO;
                deliveryAmountIncluetax = BigDecimal.ZERO;
                deliveryAmountExcluetax = BigDecimal.ZERO;
                deliveryUnitPriceIncluetax = BigDecimal.ZERO;//本期出库含税单价
                deliveryUnitPriceExcluetax = BigDecimal.ZERO;//本期出库不含税单价
                FlowmeterEntity flowmeterEntity1 = new FlowmeterEntity();
                flowmeterEntity1.setProjectId(flowmeterEntity.getProjectId());
                flowmeterEntity1.setProjectName(flowmeterEntity.getProjectName());
                flowmeterEntity1.setStoreId(flowmeterEntity.getStoreId());
                flowmeterEntity1.setStoreName(flowmeterEntity.getStoreName());
                flowmeterEntity1.setMaterialCategoryId(flowmeterEntity.getMaterialCategoryId());
                flowmeterEntity1.setMaterialCategoryCode(flowmeterEntity.getMaterialCategoryCode());
                flowmeterEntity1.setMaterialCategoryName(flowmeterEntity.getMaterialCategoryName());
                flowmeterEntity1.setMaterialId(flowmeterEntity.getMaterialId());
                flowmeterEntity1.setMaterialCode(flowmeterEntity.getMaterialCode());
                flowmeterEntity1.setMaterialName(flowmeterEntity.getMaterialName());
                flowmeterEntity1.setSpecialModel(flowmeterEntity.getSpecialModel());
                flowmeterEntity1.setMeasurementUnit(flowmeterEntity.getMeasurementUnit());

                if (enterQuantityMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId())) {
                    enterQuantity = enterQuantityMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId());//入库数量
                    flowmeterEntity1.setEnterQuantity(enterQuantity);
                }
                if (enterAmountIncluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId())) {
                    enterAmountIncluetax = enterAmountIncluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId());//入库含税金额
                    flowmeterEntity1.setEnterAmountIncluetax(enterAmountIncluetax);
                }
                if (enterAmountExcluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId())) {
                    enterAmountExcluetax = enterAmountExcluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId());//入库无税金额
                    flowmeterEntity1.setEnterAmountExcluetax(enterAmountExcluetax);
                }

                flowmeterEntity1.setEnterUnitPriceIncluetax(ComputeUtil.safeDiv(enterAmountIncluetax,enterQuantity));//本期入库含税单价
                flowmeterEntity1.setEnterUnitPriceExcluetax(ComputeUtil.safeDiv(enterAmountExcluetax,enterQuantity));//本期入库不含税单价

                if (deliveryQuantityMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId())) {
                    deliveryQuantity = deliveryQuantityMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId());//出库数量
                    flowmeterEntity1.setDeliveryQuantity(deliveryQuantity);
                }
                if (deliveryAmountIncluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId())) {
                    deliveryAmountIncluetax = deliveryAmountIncluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId());//出库含税金额
                    flowmeterEntity1.setDeliveryAmountIncluetax(deliveryAmountIncluetax);
                }
                if (deliveryAmountExcluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId())) {
                    deliveryAmountExcluetax = deliveryAmountExcluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId());//出库无税金额
                    flowmeterEntity1.setDeliveryAmountExcluetax(deliveryAmountExcluetax);
                }
                flowmeterEntity1.setDeliveryUnitPriceIncluetax(ComputeUtil.safeDiv(deliveryAmountIncluetax,deliveryQuantity));//本期出库含税单价
                flowmeterEntity1.setDeliveryUnitPriceExcluetax(ComputeUtil.safeDiv(deliveryAmountExcluetax,deliveryQuantity));//本期出库不含税单价



                flowmeterEntity1.setQuantity(ComputeUtil.safeSub(enterQuantity,deliveryQuantity)); //本期结存数量 不含上期
                flowmeterEntity1.setAmountIncluetax(ComputeUtil.safeSub(enterAmountIncluetax,deliveryAmountIncluetax)); //本期结存含税金额 不含上期
                flowmeterEntity1.setAmountExcluetax(ComputeUtil.safeSub(enterAmountExcluetax,deliveryAmountExcluetax)); //本期结存无税金额 不含上期
                flowmeterEntity1.setUnitPriceIncluetax(ComputeUtil.safeDiv( flowmeterEntity1.getAmountIncluetax(),flowmeterEntity1.getQuantity())); //本期结存含税单价 不含上期
                flowmeterEntity1.setUnitPriceExcluetax(ComputeUtil.safeDiv( flowmeterEntity1.getAmountExcluetax(),flowmeterEntity1.getQuantity())); //本期结存无税单价 不含上期

                flowmeterEntityArrayList.add(flowmeterEntity1);
            }

        }

        return flowmeterEntityArrayList;
    }
}
