package com.ejianc.business.material.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 物资验收入库单子表
 *
 * @author generator
 *
 */
public class MaterialWarehousingdetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long agentdeptId; // 经办人部门id
    private java.lang.String agentdeptName; // 经办人部门
    private java.util.Date approveTime; // 审批通过日期
    private String totalAmount; // 合计采购金额(大写)
    private java.lang.String handoverInstructe; // 交验说明
    private java.lang.String otherRemarks; // 其他备注事项
    private java.lang.String sorts; // 序号

    private java.lang.String storeName;//仓库名称
    private java.lang.String materialCode; // 材料编码
    private java.lang.Long materialId; // 材料id
    private java.lang.String materialName; // 物资名称
    private java.lang.String specialModel; // 规格型号
    private java.lang.String unit; // 单位
    private java.math.BigDecimal quantity; // 数量
    private java.math.BigDecimal unitPriceIncluetax; // 单价（含税）（元）
    private java.math.BigDecimal taxRate; // 税率
    private java.math.BigDecimal unitPriceExcluetax; // 单价（无税）
    private java.math.BigDecimal amountIncluetax; // 金额（含税）
    private java.math.BigDecimal amountExcluetax; // 金额（无税）
    private java.lang.String quantityNum; // 质量证明号
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.Long changeId; // 变更单据id
    private java.lang.String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private java.lang.String remarks; // 备注
    private java.lang.Long agentId; // 经办人
    private java.lang.String agentName; // 经办人姓名
    private java.lang.String materialPrincle; // 物资管理人
    private java.lang.String keeper; // 保管人
    private java.lang.String businessManager; // 商务经理
    private java.lang.String projectManager; // 项目经理
    private String sumPrice; // 合计采购金额（大写）
    private java.lang.String instructions; // 交验说明
    private java.lang.String otherNotice; // 其他备注事项
    private java.lang.Long mid; // 主表id
    private java.lang.Long approachDetailId; // 周转材进场验证子表id
    private java.math.BigDecimal notReturnedQuantity; //未退库数量
    private java.lang.Long warehouseingDetailId; // 入库单子表id
    private String errorMsg; // 导入错误信息


    private java.lang.Long materialCategoryId; // 物资分类id
    private String materialCategoryCode; // 物资分类编码
    private String materialCategoryName; // 物资分类名称

    private java.math.BigDecimal deliveryQuantity; // 出库数量

    private java.math.BigDecimal storeNum; // 仓库管理子表中的数量

    private java.math.BigDecimal enterCount; // 进场数量
    private java.math.BigDecimal planNum; // 计划数量
    private java.math.BigDecimal planSurplusNum; // 计划剩余数量

    public BigDecimal getPlanSurplusNum() {
        return planSurplusNum;
    }

    public void setPlanSurplusNum(BigDecimal planSurplusNum) {
        this.planSurplusNum = planSurplusNum;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getEnterCount() {
        return enterCount;
    }

    public void setEnterCount(BigDecimal enterCount) {
        this.enterCount = enterCount;
    }

    /**
     * 库存可用数量(用于实时计算，不存数据库)
     */
    private BigDecimal canUseNumber;

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 经办人部门id
     */
    public java.lang.Long getAgentdeptId() {
        return agentdeptId;
    }

    /**
     * 经办人部门id
     */
    public void setAgentdeptId(java.lang.Long agentdeptId) {
        this.agentdeptId = agentdeptId;
    }
    /**
     * 经办人部门
     */
    public java.lang.String getAgentdeptName() {
        return agentdeptName;
    }

    /**
     * 经办人部门
     */
    public void setAgentdeptName(java.lang.String agentdeptName) {
        this.agentdeptName = agentdeptName;
    }
    /**
     * 审批通过日期
     */
    public java.util.Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批通过日期
     */
    public void setApproveTime(java.util.Date approveTime) {
        this.approveTime = approveTime;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    /**
     * 交验说明
     */
    public java.lang.String getHandoverInstructe() {
        return handoverInstructe;
    }

    /**
     * 交验说明
     */
    public void setHandoverInstructe(java.lang.String handoverInstructe) {
        this.handoverInstructe = handoverInstructe;
    }
    /**
     * 其他备注事项
     */
    public java.lang.String getOtherRemarks() {
        return otherRemarks;
    }

    /**
     * 其他备注事项
     */
    public void setOtherRemarks(java.lang.String otherRemarks) {
        this.otherRemarks = otherRemarks;
    }
    /**
     * 序号
     */
    public java.lang.String getSorts() {
        return sorts;
    }

    /**
     * 序号
     */
    public void setSorts(java.lang.String sorts) {
        this.sorts = sorts;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * 材料编码
     */
    public java.lang.String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(java.lang.String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }
    /**
     * 规格型号
     */
    public java.lang.String getSpecialModel() {
        return specialModel;
    }

    /**
     * 规格型号
     */
    public void setSpecialModel(java.lang.String specialModel) {
        this.specialModel = specialModel;
    }
    /**
     * 单位
     */
    public java.lang.String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(java.lang.String unit) {
        this.unit = unit;
    }
    /**
     * 数量
     */
    public java.math.BigDecimal getQuantity() {
        return quantity;
    }

    /**
     * 数量
     */
    public void setQuantity(java.math.BigDecimal quantity) {
        this.quantity = quantity;
    }
    /**
     * 单价（含税）（元）
     */
    public java.math.BigDecimal getUnitPriceIncluetax() {
        return unitPriceIncluetax;
    }

    /**
     * 单价（含税）（元）
     */
    public void setUnitPriceIncluetax(java.math.BigDecimal unitPriceIncluetax) {
        this.unitPriceIncluetax = unitPriceIncluetax;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 单价（无税）
     */
    public java.math.BigDecimal getUnitPriceExcluetax() {
        return unitPriceExcluetax;
    }

    /**
     * 单价（无税）
     */
    public void setUnitPriceExcluetax(java.math.BigDecimal unitPriceExcluetax) {
        this.unitPriceExcluetax = unitPriceExcluetax;
    }
    /**
     * 金额（含税）
     */
    public java.math.BigDecimal getAmountIncluetax() {
        return amountIncluetax;
    }

    /**
     * 金额（含税）
     */
    public void setAmountIncluetax(java.math.BigDecimal amountIncluetax) {
        this.amountIncluetax = amountIncluetax;
    }
    /**
     * 金额（无税）
     */
    public java.math.BigDecimal getAmountExcluetax() {
        return amountExcluetax;
    }

    /**
     * 金额（无税）
     */
    public void setAmountExcluetax(java.math.BigDecimal amountExcluetax) {
        this.amountExcluetax = amountExcluetax;
    }
    /**
     * 质量证明号
     */
    public java.lang.String getQuantityNum() {
        return quantityNum;
    }

    /**
     * 质量证明号
     */
    public void setQuantityNum(java.lang.String quantityNum) {
        this.quantityNum = quantityNum;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 变更单据id
     */
    public java.lang.Long getChangeId() {
        return changeId;
    }

    /**
     * 变更单据id
     */
    public void setChangeId(java.lang.Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public java.lang.String getChangeState() {
        return changeState;
    }

    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public void setChangeState(java.lang.String changeState) {
        this.changeState = changeState;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }
    /**
     * 物资管理人
     */
    public java.lang.String getMaterialPrincle() {
        return materialPrincle;
    }

    /**
     * 物资管理人
     */
    public void setMaterialPrincle(java.lang.String materialPrincle) {
        this.materialPrincle = materialPrincle;
    }
    /**
     * 保管人
     */
    public java.lang.String getKeeper() {
        return keeper;
    }

    /**
     * 保管人
     */
    public void setKeeper(java.lang.String keeper) {
        this.keeper = keeper;
    }
    /**
     * 商务经理
     */
    public java.lang.String getBusinessManager() {
        return businessManager;
    }

    /**
     * 商务经理
     */
    public void setBusinessManager(java.lang.String businessManager) {
        this.businessManager = businessManager;
    }
    /**
     * 项目经理
     */
    public java.lang.String getProjectManager() {
        return projectManager;
    }

    /**
     * 项目经理
     */
    public void setProjectManager(java.lang.String projectManager) {
        this.projectManager = projectManager;
    }

    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getSumPrice() {
        return sumPrice;
    }

    public void setSumPrice(String sumPrice) {
        this.sumPrice = sumPrice;
    }

    public BigDecimal getCanUseNumber() {
        return canUseNumber;
    }

    public void setCanUseNumber(BigDecimal canUseNumber) {
        this.canUseNumber = canUseNumber;
    }

    public String getInstructions() {
        return instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getOtherNotice() {
        return otherNotice;
    }

    public void setOtherNotice(String otherNotice) {
        this.otherNotice = otherNotice;
    }


    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public BigDecimal getDeliveryQuantity() {
        return deliveryQuantity;
    }

    public void setDeliveryQuantity(BigDecimal deliveryQuantity) {
        this.deliveryQuantity = deliveryQuantity;
    }

    public BigDecimal getStoreNum() {
        return storeNum;
    }

    public void setStoreNum(BigDecimal storeNum) {
        this.storeNum = storeNum;
    }

    public Long getApproachDetailId() {
        return approachDetailId;
    }

    public void setApproachDetailId(Long approachDetailId) {
        this.approachDetailId = approachDetailId;
    }

    public BigDecimal getNotReturnedQuantity() {
        return notReturnedQuantity;
    }

    public void setNotReturnedQuantity(BigDecimal notReturnedQuantity) {
        this.notReturnedQuantity = notReturnedQuantity;
    }

    public Long getWarehouseingDetailId() {
        return warehouseingDetailId;
    }

    public void setWarehouseingDetailId(Long warehouseingDetailId) {
        this.warehouseingDetailId = warehouseingDetailId;
    }
}
