/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.MaterialapproachdetailEntity;
import com.ejianc.business.material.bean.MaterialsreturnEntity;
import com.ejianc.business.material.bean.MaterialsreturndetailEntity;
import com.ejianc.business.material.service.IMaterialapproachdetailService;
import com.ejianc.business.material.service.IMaterialsreturnService;
import com.ejianc.business.material.service.IMaterialsreturndetailService;
import com.ejianc.business.material.utils.BigDecimalUtils;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.MaterialreturnReportVO;
import com.ejianc.business.material.vo.MaterialsreturnVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialsreturn"})
public class MaterialsreturnController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "WZ_SRETURN";
    @Autowired
    private IMaterialsreturnService service;
    @Autowired
    private IMaterialsreturndetailService detailService;
    @Autowired
    private IMaterialapproachdetailService materialapproachdetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional
    public CommonResponse<MaterialsreturnVO> saveOrUpdate(@RequestBody MaterialsreturnVO saveorUpdateVO) {
        MaterialsreturnEntity entity = (MaterialsreturnEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), MaterialsreturnEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<MaterialsreturndetailEntity> materialsreturndetailEntities = entity.getMaterialsreturndetailEntities();
        for (MaterialsreturndetailEntity item : materialsreturndetailEntities) {
            item.setProjectId(entity.getProjectId());
            item.setProjectName(entity.getProjectName());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"material_code", (Object)item.getMaterialCode());
            queryWrapper.eq((Object)"mid", (Object)entity.getEnterId().toString());
            MaterialapproachdetailEntity one = (MaterialapproachdetailEntity)((Object)this.materialapproachdetailService.getOne((Wrapper)queryWrapper));
            one.setExitAccount(BigDecimalUtils.ofNullable(one.getExitAccount()).add(BigDecimalUtils.ofNullable(item.getReturnCount())));
            one.setLoseAccount(BigDecimalUtils.ofNullable(one.getLoseAccount()).add(BigDecimalUtils.ofNullable(item.getLostCount())));
            one.setRepairAccount(BigDecimalUtils.ofNullable(one.getRepairAccount()).add(BigDecimalUtils.ofNullable(item.getMaintainCount())));
            this.materialapproachdetailService.updateById((Object)one);
        }
        List approachDetailIds = materialsreturndetailEntities.stream().map(MaterialsreturndetailEntity::getApproachDetailId).collect(Collectors.toList());
        List approachDetailEntities = this.materialapproachdetailService.list((Wrapper)new QueryWrapper().in((Object)"id", approachDetailIds));
        HashMap<Long, BigDecimal> approachDetailMap = new HashMap<Long, BigDecimal>();
        for (MaterialapproachdetailEntity detailEntity : approachDetailEntities) {
            approachDetailMap.put(detailEntity.getId(), detailEntity.getVerificationCount());
        }
        List materialsreturndetailEntityList = this.detailService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"approach_detail_id", approachDetailIds)).ne(entity.getId() != null, (Object)"mid", (Object)entity.getId()));
        Map<Object, Object> numMap = new HashMap();
        Map<Object, Object> lostMap = new HashMap();
        Map<Object, Object> maintainMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)materialsreturndetailEntityList)) {
            numMap = materialsreturndetailEntityList.stream().collect(Collectors.groupingBy(MaterialsreturndetailEntity::getApproachDetailId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getReturnCount()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            lostMap = materialsreturndetailEntityList.stream().collect(Collectors.groupingBy(MaterialsreturndetailEntity::getApproachDetailId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getLostCount()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            maintainMap = materialsreturndetailEntityList.stream().collect(Collectors.groupingBy(MaterialsreturndetailEntity::getApproachDetailId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getMaintainCount()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        for (MaterialsreturndetailEntity materialsreturndetailEntity : materialsreturndetailEntities) {
            BigDecimal num = BigDecimal.ZERO;
            if (numMap.containsKey(materialsreturndetailEntity.getApproachDetailId())) {
                num = (BigDecimal)numMap.get(materialsreturndetailEntity.getApproachDetailId());
            }
            BigDecimal lostNum = BigDecimal.ZERO;
            if (lostMap.containsKey(materialsreturndetailEntity.getApproachDetailId())) {
                lostNum = (BigDecimal)lostMap.get(materialsreturndetailEntity.getApproachDetailId());
            }
            BigDecimal maintainNum = BigDecimal.ZERO;
            if (maintainMap.containsKey(materialsreturndetailEntity.getApproachDetailId())) {
                maintainNum = (BigDecimal)maintainMap.get(materialsreturndetailEntity.getApproachDetailId());
            }
            if ((num = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)materialsreturndetailEntity.getReturnCount(), (BigDecimal)num), (BigDecimal)lostNum), (BigDecimal)maintainNum), (BigDecimal)materialsreturndetailEntity.getLostCount()), (BigDecimal)materialsreturndetailEntity.getMaintainCount())).compareTo((BigDecimal)approachDetailMap.get(materialsreturndetailEntity.getApproachDetailId())) != 1) continue;
            throw new BusinessException("\u7269\u8d44\u7f16\u53f7:" + materialsreturndetailEntity.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + materialsreturndetailEntity.getName() + "\u8d85\u8fc7\u5269\u4f59\u53ef\u8fdb\u573a\u6570\u91cf,\u4e0d\u80fd\u4fdd\u5b58!");
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialsreturnVO vo = (MaterialsreturnVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialsreturnVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialsreturnVO> queryDetail(Long id) {
        MaterialsreturnEntity entity = (MaterialsreturnEntity)((Object)this.service.selectById(id));
        MaterialsreturnVO vo = (MaterialsreturnVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialsreturnVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialsreturnVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialsreturnVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialsreturnVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        fuzzyFields.add("agentdep_name");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("enter_code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List materialsreturnVOList = BeanMapper.mapList((Iterable)list, MaterialsreturnVO.class);
        for (int i = 0; i < materialsreturnVOList.size(); ++i) {
            String billStateStr;
            MaterialsreturnVO materialsreturnVO = (MaterialsreturnVO)((Object)materialsreturnVOList.get(i));
            materialsreturnVO.setNum(String.valueOf(i + 1));
            if (materialsreturnVO.getCreateTime() != null) {
                materialsreturnVO.setCreateTimeShow(DateUtils.dateSimple2(materialsreturnVO.getCreateTime()));
            }
            if (materialsreturnVO.getBillTime() != null) {
                materialsreturnVO.setBillTimeShow(DateUtils.dateSimple2(materialsreturnVO.getBillTime()));
            }
            if (materialsreturnVO.getReturnTime() != null) {
                materialsreturnVO.setReturnTimeShow(DateUtils.dateSimple2(materialsreturnVO.getReturnTime()));
            }
            if ((billStateStr = materialsreturnVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            materialsreturnVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", materialsreturnVOList);
        ExcelExport.getInstance().export("Materialsreturn-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialsreturnData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialsreturnVO>> refMaterialsreturnData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        fuzzyFields.add("agentdep_name");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("enter_code");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialsreturnVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialreturnReportVO>> queryReport(Long projectId, String materialCode) {
        ArrayList<MaterialreturnReportVO> resList = new ArrayList<MaterialreturnReportVO>();
        QueryWrapper detailQueryWrapper = new QueryWrapper();
        detailQueryWrapper.eq((Object)"dr", (Object)0);
        detailQueryWrapper.eq((Object)"project_id", (Object)projectId);
        detailQueryWrapper.eq((Object)"material_code", (Object)materialCode);
        List detailEntityList = this.detailService.list((Wrapper)detailQueryWrapper);
        for (MaterialsreturndetailEntity item : detailEntityList) {
            String projectName = item.getProjectName();
            String name = item.getName();
            BigDecimal returnCount = item.getReturnCount();
            MaterialreturnReportVO reportVO = new MaterialreturnReportVO();
            reportVO.setId(IdWorker.getId());
            reportVO.setProjectId(projectId);
            reportVO.setProjectName(projectName);
            reportVO.setMaterialName(name);
            reportVO.setMaterialCode(materialCode);
            reportVO.setReturnCount(returnCount);
            reportVO.setSpec(item.getSpec());
            Long mid = item.getMid();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"id", (Object)mid);
            List mList = this.service.list((Wrapper)queryWrapper);
            if (mList != null && mList.size() > 0) {
                MaterialsreturnEntity entity = (MaterialsreturnEntity)((Object)mList.get(0));
                String billCode = entity.getBillCode();
                reportVO.setBillCode(billCode);
                reportVO.setMaterialsreturnId(mid);
            }
            resList.add(reportVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", resList);
    }
}

