/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.DeliveryrecordEntity;
import com.ejianc.business.material.bean.DeliveryrecorddetailEntity;
import com.ejianc.business.material.bean.RealtimebalanceEntity;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.service.IDeliveryrecordService;
import com.ejianc.business.material.service.IDeliveryrecorddetailService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.RealtimebalanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.wzxt.plan.api.IPlanApi;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"realtimebalance"})
public class RealtimebalanceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IStoreService storeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IRealtimebalanceService service;
    @Autowired
    private IPlanApi planApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDeliveryrecordService deliveryrecordService;
    @Autowired
    private IDeliveryrecorddetailService deliveryrecorddetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RealtimebalanceVO> saveOrUpdate(@RequestBody RealtimebalanceVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        RealtimebalanceEntity entity = (RealtimebalanceEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), RealtimebalanceEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        RealtimebalanceVO vo = (RealtimebalanceVO)((Object)BeanMapper.map((Object)((Object)entity), RealtimebalanceVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RealtimebalanceVO> queryDetail(Long id) {
        RealtimebalanceEntity entity = (RealtimebalanceEntity)((Object)this.service.selectById(id));
        RealtimebalanceVO vo = (RealtimebalanceVO)((Object)BeanMapper.map((Object)((Object)entity), RealtimebalanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RealtimebalanceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RealtimebalanceVO realtimebalanceVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RealtimebalanceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RealtimebalanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Realtimebalance-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRealtimebalanceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RealtimebalanceVO>> refRealtimebalanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String relyCondition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String selfStateValue = "";
        Long subContractIdValue = null;
        Long projectIdValue = null;
        Long storeIdValue = null;
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            storeIdValue = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("storeId", new Parameter("eq", (Object)storeIdValue));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            String projectId = _con.getString("projectId");
            String storeId = _con.getString("storeId");
            String selfState = _con.getString("selfState");
            String subContractId = _con.getString("subContractId");
            if (projectId != null && !projectId.isEmpty()) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
                param.getParams().put("quantity", new Parameter("gt", (Object)new BigDecimal(0.0)));
                projectIdValue = Long.parseLong(_con.get((Object)"projectId").toString());
            }
            if (storeId != null && !storeId.isEmpty()) {
                param.getParams().put("storeId", new Parameter("eq", _con.get((Object)"storeId")));
            }
            if (selfState != null && !selfState.isEmpty()) {
                selfStateValue = _con.get((Object)"selfState").toString();
            }
            if (subContractId != null && !subContractId.isEmpty()) {
                subContractIdValue = Long.parseLong(_con.get((Object)"subContractId").toString());
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List realtimebalanceVOS = BeanMapper.mapList((Iterable)page.getRecords(), RealtimebalanceVO.class);
        if (selfStateValue.equals("\u5426")) {
            CommonResponse materialPLanByProjectId = this.planApi.getMaterialPLanByProjectId(projectIdValue, subContractIdValue);
            if (!materialPLanByProjectId.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u8ba1\u5212\u4fe1\u606f\u5931\u8d25");
            }
            Map pLanByProjectIdMap = (Map)materialPLanByProjectId.getData();
            LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getProjectId, projectIdValue);
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getPickingunitId, (Object)subContractIdValue);
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getSelfState, (Object)"\u5426");
            lambdaQueryWrapper.in(DeliveryrecordEntity::getBillState, new Object[]{1, 3});
            List deliveryrecordEntities = this.deliveryrecordService.list((Wrapper)lambdaQueryWrapper);
            Map<Object, Object> numMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)deliveryrecordEntities)) {
                List ids = deliveryrecordEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
                lambdaQuery.in(DeliveryrecorddetailEntity::getMid, ids);
                List deliveryrecorddetailEntities = this.deliveryrecorddetailService.list((Wrapper)lambdaQuery);
                if (CollectionUtils.isNotEmpty((Collection)deliveryrecorddetailEntities)) {
                    numMap = deliveryrecorddetailEntities.stream().collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)realtimebalanceVOS)) {
                for (RealtimebalanceVO realtimebalanceVO : realtimebalanceVOS) {
                    if (!pLanByProjectIdMap.containsKey(realtimebalanceVO.getMaterialId())) continue;
                    BigDecimal planNum = (BigDecimal)pLanByProjectIdMap.get(realtimebalanceVO.getMaterialId());
                    realtimebalanceVO.setPlanNum(planNum);
                    if (numMap.containsKey(realtimebalanceVO.getMaterialId())) {
                        BigDecimal outNum = (BigDecimal)numMap.get(realtimebalanceVO.getMaterialId());
                        realtimebalanceVO.setPlanSurplusNum(ComputeUtil.safeSub((BigDecimal)realtimebalanceVO.getPlanNum(), (BigDecimal)outNum));
                        continue;
                    }
                    realtimebalanceVO.setPlanSurplusNum(realtimebalanceVO.getPlanNum());
                }
            }
        }
        StoreEntity storeEntity = (StoreEntity)((Object)this.storeService.getById(storeIdValue));
        for (RealtimebalanceVO balanceVO : realtimebalanceVOS) {
            balanceVO.setStoreType(storeEntity.getStoreType());
            if (storeEntity.getStoreType() == 0) {
                balanceVO.setStoreTypeName("\u6210\u54c1\u5e93");
            }
            if (storeEntity.getStoreType() == 1) {
                balanceVO.setStoreTypeName("\u5e9f\u65e7\u7269\u8d44\u5e93");
            }
            if (storeEntity.getStoreType() != 2) continue;
            balanceVO.setStoreTypeName("\u8d44\u4ea7\u5e93");
        }
        pageData.setRecords(realtimebalanceVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refUnitPrice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> refUnitPrice(Long projectId, String storeId, String materialCategoryCode, String materialCode) {
        JSONObject jsonObject = new JSONObject();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"material_code", (Object)materialCode);
        queryWrapper.eq((Object)"material_category_code", (Object)materialCategoryCode);
        queryWrapper.eq((Object)"store_id", (Object)storeId);
        RealtimebalanceEntity one = (RealtimebalanceEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        if (one != null) {
            jsonObject.put("unitPriceIncluetax", (Object)one.getUnitPriceIncluetax());
            jsonObject.put("unitPriceExcluetax", (Object)one.getUnitPriceExcluetax());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", (Object)jsonObject);
    }
}

