/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.RealtimebalanceEntity;
import com.ejianc.business.material.bean.TransferorderEntity;
import com.ejianc.business.material.bean.TransferorderdetailEntity;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.service.ITransferorderService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="transferorder")
public class TransferorderBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITransferorderService transferorderService;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private IStoreService storeService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8c03\u62e8\u63d0\u4ea4--------------");
        TransferorderEntity transferorderEntity = (TransferorderEntity)((Object)this.transferorderService.selectById(billId));
        ArrayList<FlowmeterEntity> list = new ArrayList<FlowmeterEntity>();
        ArrayList<RealtimebalanceEntity> realList = new ArrayList<RealtimebalanceEntity>();
        ArrayList<RealtimebalanceEntity> realList1 = new ArrayList<RealtimebalanceEntity>();
        List<TransferorderdetailEntity> transferorderdetailEntities = transferorderEntity.getTransferorderdetailEntities();
        if (transferorderdetailEntities.size() > 0 && transferorderdetailEntities != null) {
            for (TransferorderdetailEntity entity : transferorderdetailEntities) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_id", (Object)transferorderEntity.getDialinitemsId());
                queryWrapper.eq((Object)"material_code", (Object)entity.getMaterialCode());
                queryWrapper.eq((Object)"material_category_code", (Object)entity.getMaterialCategoryCode());
                queryWrapper.eq((Object)"store_id", (Object)transferorderEntity.getIncomingWarehouse());
                RealtimebalanceEntity realtimebalanceEntity = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper));
                if (realtimebalanceEntity == null) continue;
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"project_id", (Object)transferorderEntity.getDialinitemsId());
                queryWrapper1.eq((Object)"detail_id", (Object)entity.getId());
                FlowmeterEntity flowmeterEntity = (FlowmeterEntity)((Object)this.flowmeterService.getOne((Wrapper)queryWrapper1));
                if (flowmeterEntity != null) {
                    list.add(flowmeterEntity);
                }
                realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getQuantity()));
                realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getTransferAmount()));
                realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
                if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                    realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                } else {
                    realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.0));
                    realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.0));
                }
                realList.add(realtimebalanceEntity);
                QueryWrapper queryWrapper2 = new QueryWrapper();
                queryWrapper2.eq((Object)"project_id", (Object)transferorderEntity.getDialitemsId());
                queryWrapper2.eq((Object)"detail_id", (Object)entity.getId());
                FlowmeterEntity flowmeterEntity1 = (FlowmeterEntity)((Object)this.flowmeterService.getOne((Wrapper)queryWrapper2));
                if (flowmeterEntity1 != null) {
                    list.add(flowmeterEntity1);
                }
                QueryWrapper queryWrapper3 = new QueryWrapper();
                queryWrapper3.eq((Object)"project_id", (Object)transferorderEntity.getDialitemsId());
                queryWrapper3.eq((Object)"material_code", (Object)entity.getMaterialCode());
                queryWrapper3.eq((Object)"material_category_code", (Object)entity.getMaterialCategoryCode());
                queryWrapper3.eq((Object)"store_id", (Object)transferorderEntity.getIssuingWarehouse());
                RealtimebalanceEntity realtimebalanceEntity1 = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper3));
                if (realtimebalanceEntity1 == null) continue;
                realtimebalanceEntity1.setQuantity(realtimebalanceEntity1.getQuantity().add(entity.getQuantity()));
                realtimebalanceEntity1.setAmountIncluetax(realtimebalanceEntity1.getAmountIncluetax().add(entity.getTransferAmount()));
                realtimebalanceEntity1.setAmountExcluetax(realtimebalanceEntity1.getAmountExcluetax().add(entity.getAmountExcluetax()));
                if (realtimebalanceEntity1.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    realtimebalanceEntity1.setUnitPriceIncluetax(realtimebalanceEntity1.getAmountIncluetax().divide(realtimebalanceEntity1.getQuantity(), 8, 4));
                    realtimebalanceEntity1.setUnitPriceExcluetax(realtimebalanceEntity1.getAmountExcluetax().divide(realtimebalanceEntity1.getQuantity(), 8, 4));
                } else {
                    realtimebalanceEntity1.setUnitPriceIncluetax(new BigDecimal(0.0));
                    realtimebalanceEntity1.setUnitPriceExcluetax(new BigDecimal(0.0));
                }
                realList1.add(realtimebalanceEntity1);
            }
            this.logger.info("list3----" + JSONObject.toJSONString(list));
            if (CollectionUtils.isNotEmpty(list) && list.size() > 0) {
                List collect = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
                this.logger.info("list1----" + JSONObject.toJSONString(collect));
                this.logger.info("list2---" + JSONObject.toJSONString(list));
                if (CollectionUtils.isNotEmpty(collect)) {
                    this.flowmeterService.removeByIds(collect, true);
                }
            }
            if (realList.size() > 0) {
                this.realtimebalanceService.updateBatchById(realList, realList.size());
            }
            if (realList1.size() > 0) {
                this.realtimebalanceService.updateBatchById(realList1, realList1.size());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8c03\u62e8\u63d0\u4ea4--------------");
        TransferorderEntity transferorderEntity = (TransferorderEntity)((Object)this.transferorderService.selectById(billId));
        ArrayList<FlowmeterEntity> list1 = new ArrayList<FlowmeterEntity>();
        ArrayList<FlowmeterEntity> list = new ArrayList<FlowmeterEntity>();
        ArrayList<RealtimebalanceEntity> realList = new ArrayList<RealtimebalanceEntity>();
        ArrayList<RealtimebalanceEntity> realList1 = new ArrayList<RealtimebalanceEntity>();
        ArrayList<RealtimebalanceEntity> realList2 = new ArrayList<RealtimebalanceEntity>();
        List<TransferorderdetailEntity> transferorderdetailEntities = transferorderEntity.getTransferorderdetailEntities();
        if (transferorderdetailEntities.size() > 0 && transferorderdetailEntities != null) {
            for (TransferorderdetailEntity entity : transferorderdetailEntities) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_id", (Object)transferorderEntity.getDialitemsId());
                queryWrapper.eq((Object)"material_code", (Object)entity.getMaterialCode());
                queryWrapper.eq((Object)"material_category_code", (Object)entity.getMaterialCategoryCode());
                queryWrapper.eq((Object)"store_id", (Object)transferorderEntity.getIssuingWarehouse());
                RealtimebalanceEntity realtimebalanceEntity = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper));
                if (realtimebalanceEntity == null) continue;
                FlowmeterEntity flowmeterEntity = this.createrFlowmeter(transferorderEntity, entity, 0);
                list.add(flowmeterEntity);
                realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getQuantity()));
                if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getTransferAmount()));
                    realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
                    realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                    realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                } else {
                    realtimebalanceEntity.setAmountIncluetax(new BigDecimal(0.0));
                    realtimebalanceEntity.setAmountExcluetax(new BigDecimal(0.0));
                    realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.0));
                    realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.0));
                }
                realList.add(realtimebalanceEntity);
                FlowmeterEntity flowmeterEntity1 = this.createrFlowmeter(transferorderEntity, entity, 1);
                list1.add(flowmeterEntity1);
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"project_id", (Object)transferorderEntity.getDialinitemsId());
                queryWrapper1.eq((Object)"material_code", (Object)entity.getMaterialCode());
                queryWrapper1.eq((Object)"material_category_code", (Object)entity.getMaterialCategoryCode());
                queryWrapper1.eq((Object)"store_id", (Object)transferorderEntity.getIncomingWarehouse());
                RealtimebalanceEntity realtimebalanceEntity1 = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper1));
                if (realtimebalanceEntity1 != null) {
                    realtimebalanceEntity1.setQuantity(realtimebalanceEntity1.getQuantity().add(entity.getQuantity()));
                    realtimebalanceEntity1.setAmountIncluetax(realtimebalanceEntity1.getAmountIncluetax().add(entity.getEnterAmount()));
                    realtimebalanceEntity1.setAmountExcluetax(realtimebalanceEntity1.getAmountExcluetax().add(entity.getEnterAmountExcluetax()));
                    if (realtimebalanceEntity1.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                        realtimebalanceEntity1.setUnitPriceIncluetax(realtimebalanceEntity1.getAmountIncluetax().divide(realtimebalanceEntity1.getQuantity(), 8, 4));
                        realtimebalanceEntity1.setUnitPriceExcluetax(realtimebalanceEntity1.getAmountExcluetax().divide(realtimebalanceEntity1.getQuantity(), 8, 4));
                    } else {
                        realtimebalanceEntity1.setUnitPriceIncluetax(new BigDecimal(0.0));
                        realtimebalanceEntity1.setUnitPriceExcluetax(new BigDecimal(0.0));
                    }
                    realList2.add(realtimebalanceEntity1);
                    continue;
                }
                RealtimebalanceEntity realtimebalanceEntity2 = new RealtimebalanceEntity();
                realtimebalanceEntity2.setProjectId(transferorderEntity.getDialinitemsId());
                realtimebalanceEntity2.setProjectName(transferorderEntity.getDialInitems());
                realtimebalanceEntity2.setMaterialCode(entity.getMaterialCode());
                realtimebalanceEntity2.setMaterialName(entity.getMaterialName());
                realtimebalanceEntity2.setMaterialCategoryId(entity.getMaterialCategoryId());
                realtimebalanceEntity2.setMaterialCategoryCode(entity.getMaterialCategoryCode());
                realtimebalanceEntity2.setMaterialCategoryName(entity.getMaterialCategoryName());
                realtimebalanceEntity2.setStoreId(transferorderEntity.getIncomingWarehouse());
                realtimebalanceEntity2.setStoreName(transferorderEntity.getIncomingWarehouseName());
                realtimebalanceEntity2.setQuantity(entity.getQuantity());
                realtimebalanceEntity2.setUnitPriceIncluetax(entity.getEnterPrice());
                realtimebalanceEntity2.setUnitPriceExcluetax(entity.getEnterUnitPrice());
                realtimebalanceEntity2.setAmountIncluetax(entity.getEnterAmount());
                realtimebalanceEntity2.setAmountExcluetax(entity.getEnterAmountExcluetax());
                realtimebalanceEntity2.setOrgId(transferorderEntity.getOrgId());
                realtimebalanceEntity2.setOrgName(transferorderEntity.getOrgName());
                realtimebalanceEntity2.setMeasurementUnit(entity.getMeasurementUnit());
                realtimebalanceEntity2.setSpecialModel(entity.getSpecialModel());
                realtimebalanceEntity2.setProjectDepartmentId(transferorderEntity.getProjectDepartmentId());
                realList1.add(realtimebalanceEntity2);
            }
            if (list1.size() > 0) {
                this.flowmeterService.saveBatch(list1, list1.size());
                for (FlowmeterEntity flowmeterEntity : list1) {
                    this.flowmeterService.updateFlow(flowmeterEntity.getMid(), new Date(), 1);
                }
                this.realtimebalanceService.updateRealtimeBalance(transferorderEntity.getIncomingWarehouse());
            }
            if (list.size() > 0) {
                for (FlowmeterEntity flowmeterEntity : list) {
                    this.flowmeterService.updateFlow(flowmeterEntity.getMid(), new Date(), 1);
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        TransferorderEntity transferorderEntity = (TransferorderEntity)((Object)this.transferorderService.selectById(billId));
        if (transferorderEntity.getSourceType() != null && transferorderEntity.getSourceType() == 1) {
            CommonResponse.error((String)"\u8d44\u4ea7\u76d8\u6d3b\u751f\u6210\u7684\u8c03\u62e8\u5355\u4e0d\u5141\u8bb8\u64a4\u56de!");
        }
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8c03\u62e8\u63d0\u4ea4--------------");
        TransferorderEntity transferorderEntity = (TransferorderEntity)((Object)this.transferorderService.selectById(billId));
        ArrayList<FlowmeterEntity> list1 = new ArrayList<FlowmeterEntity>();
        ArrayList<FlowmeterEntity> list = new ArrayList<FlowmeterEntity>();
        ArrayList<RealtimebalanceEntity> realList = new ArrayList<RealtimebalanceEntity>();
        ArrayList<RealtimebalanceEntity> realList1 = new ArrayList<RealtimebalanceEntity>();
        List<TransferorderdetailEntity> transferorderdetailEntities = transferorderEntity.getTransferorderdetailEntities();
        if (transferorderdetailEntities.size() > 0 && transferorderdetailEntities != null) {
            for (TransferorderdetailEntity entity : transferorderdetailEntities) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_id", (Object)transferorderEntity.getDialinitemsId());
                queryWrapper.eq((Object)"material_code", (Object)entity.getMaterialCode());
                queryWrapper.eq((Object)"material_category_code", (Object)entity.getMaterialCategoryCode());
                queryWrapper.eq((Object)"store_id", (Object)transferorderEntity.getIncomingWarehouse());
                RealtimebalanceEntity realtimebalanceEntity = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper));
                if (realtimebalanceEntity == null) continue;
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"project_id", (Object)transferorderEntity.getDialinitemsId());
                queryWrapper1.eq((Object)"detail_id", (Object)entity.getId());
                FlowmeterEntity flowmeterEntity = (FlowmeterEntity)((Object)this.flowmeterService.getOne((Wrapper)queryWrapper1));
                list1.add(flowmeterEntity);
                realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getQuantity()));
                realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getTransferAmount()));
                realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
                if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                    realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                } else {
                    realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.0));
                    realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.0));
                }
                realList.add(realtimebalanceEntity);
                QueryWrapper queryWrapper2 = new QueryWrapper();
                queryWrapper2.eq((Object)"project_id", (Object)transferorderEntity.getDialitemsId());
                queryWrapper2.eq((Object)"detail_id", (Object)entity.getId());
                FlowmeterEntity flowmeterEntity1 = (FlowmeterEntity)((Object)this.flowmeterService.getOne((Wrapper)queryWrapper2));
                list.add(flowmeterEntity1);
                QueryWrapper queryWrapper3 = new QueryWrapper();
                queryWrapper3.eq((Object)"project_id", (Object)transferorderEntity.getDialitemsId());
                queryWrapper3.eq((Object)"material_code", (Object)entity.getMaterialCode());
                queryWrapper3.eq((Object)"material_category_code", (Object)entity.getMaterialCategoryCode());
                queryWrapper3.eq((Object)"store_id", (Object)transferorderEntity.getIssuingWarehouse());
                RealtimebalanceEntity realtimebalanceEntity1 = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper3));
                if (realtimebalanceEntity1 == null) continue;
                realtimebalanceEntity1.setQuantity(realtimebalanceEntity1.getQuantity().add(entity.getQuantity()));
                realtimebalanceEntity1.setAmountIncluetax(realtimebalanceEntity1.getAmountIncluetax().add(entity.getTransferAmount()));
                realtimebalanceEntity1.setAmountExcluetax(realtimebalanceEntity1.getAmountExcluetax().add(entity.getAmountExcluetax()));
                if (realtimebalanceEntity1.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    realtimebalanceEntity1.setUnitPriceIncluetax(realtimebalanceEntity1.getAmountIncluetax().divide(realtimebalanceEntity1.getQuantity(), 8, 4));
                    realtimebalanceEntity1.setUnitPriceExcluetax(realtimebalanceEntity1.getAmountExcluetax().divide(realtimebalanceEntity1.getQuantity(), 8, 4));
                } else {
                    realtimebalanceEntity1.setUnitPriceIncluetax(new BigDecimal(0.0));
                    realtimebalanceEntity1.setUnitPriceExcluetax(new BigDecimal(0.0));
                }
                realList1.add(realtimebalanceEntity1);
            }
            if (list1.size() > 0) {
                this.flowmeterService.removeByIds(list1.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
                this.realtimebalanceService.updateRealtimeBalance(transferorderEntity.getIncomingWarehouse());
            }
            if (list.size() > 0) {
                for (FlowmeterEntity flowmeterEntity : list) {
                    this.flowmeterService.updateFlow(flowmeterEntity.getMid(), new Date(), 0);
                }
            }
        }
        return CommonResponse.success();
    }

    public FlowmeterEntity createrFlowmeter(TransferorderEntity transferorderEntity, TransferorderdetailEntity entity, Integer status) {
        FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
        flowmeterEntity.setMid(transferorderEntity.getId());
        flowmeterEntity.setDetailId(entity.getId());
        flowmeterEntity.setBillCode(transferorderEntity.getBillCode());
        flowmeterEntity.setBillTime(transferorderEntity.getCreateTime());
        flowmeterEntity.setMaterialId(entity.getMaterialId());
        if (status == 0) {
            flowmeterEntity.setProjectId(transferorderEntity.getDialitemsId());
            flowmeterEntity.setProjectName(transferorderEntity.getDialItems());
            flowmeterEntity.setStoreId(transferorderEntity.getIssuingWarehouse());
            flowmeterEntity.setStoreName(transferorderEntity.getIssuingWarehouseName());
            flowmeterEntity.setOperationType("\u51fa\u5e93");
            flowmeterEntity.setAccessType("\u8c03\u51fa");
            flowmeterEntity.setTransferorderType("\u8c03\u62e8\u51fa\u5e93");
            flowmeterEntity.setQuantity(entity.getQuantity());
            flowmeterEntity.setUnitPriceIncluetax(entity.getTransferPrice());
            flowmeterEntity.setUnitPriceExcluetax(entity.getUnitPriceExcluetax());
            flowmeterEntity.setAmountIncluetax(entity.getTransferAmount());
            flowmeterEntity.setAmountExcluetax(entity.getAmountExcluetax());
            flowmeterEntity.setProjectDepartmentId(transferorderEntity.getProjectDepartmentId());
            flowmeterEntity.setBillStatus(0);
            flowmeterEntity.setStoreType(this.storeService.queryStoreType(transferorderEntity.getIssuingWarehouse()));
        } else if (status == 1) {
            flowmeterEntity.setProjectId(transferorderEntity.getDialinitemsId());
            flowmeterEntity.setProjectName(transferorderEntity.getDialInitems());
            flowmeterEntity.setStoreId(transferorderEntity.getIncomingWarehouse());
            flowmeterEntity.setStoreName(transferorderEntity.getIncomingWarehouseName());
            flowmeterEntity.setOperationType("\u5165\u5e93");
            flowmeterEntity.setAccessType("\u8c03\u5165");
            flowmeterEntity.setTransferorderType("\u8c03\u62e8\u5165\u5e93");
            flowmeterEntity.setQuantity(entity.getQuantity());
            flowmeterEntity.setUnitPriceIncluetax(entity.getEnterPrice());
            flowmeterEntity.setUnitPriceExcluetax(entity.getEnterUnitPrice());
            flowmeterEntity.setAmountIncluetax(entity.getEnterAmount());
            flowmeterEntity.setAmountExcluetax(entity.getEnterAmountExcluetax());
            flowmeterEntity.setProjectDepartmentId(transferorderEntity.getProjectDepartmentIdEnter());
            flowmeterEntity.setBillStatus(1);
            flowmeterEntity.setStoreType(this.storeService.queryStoreType(transferorderEntity.getIncomingWarehouse()));
        }
        flowmeterEntity.setMaterialCode(entity.getMaterialCode());
        flowmeterEntity.setMaterialName(entity.getMaterialName());
        flowmeterEntity.setMaterialCategoryId(entity.getMaterialCategoryId());
        flowmeterEntity.setMaterialCategoryCode(entity.getMaterialCategoryCode());
        flowmeterEntity.setMaterialCategoryName(entity.getMaterialCategoryName());
        flowmeterEntity.setTime(transferorderEntity.getDates());
        flowmeterEntity.setMeasurementUnit(entity.getMeasurementUnit());
        flowmeterEntity.setSpecialModel(entity.getSpecialModel());
        flowmeterEntity.setOrgId(transferorderEntity.getOrgId());
        flowmeterEntity.setOrgName(transferorderEntity.getOrgName());
        flowmeterEntity.setBillType(2);
        return flowmeterEntity;
    }
}

