/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.order.service.impl;

import com.ejianc.business.material.service.ITransferorderService;
import com.ejianc.business.panhuo.order.bean.AllotOrderEntity;
import com.ejianc.business.panhuo.order.service.IAllotOrderService;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.panhuo.constants.AllotOrderBusinessStatusEnums;
import com.ejianc.foundation.panhuo.constants.CommonConstants;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="allotOrder")
public class AllotOrderBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAllotOrderService service;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private ITransferorderService transferorderService;

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        AllotOrderEntity orderEntity = (AllotOrderEntity)((Object)this.service.selectById(billId));
        UserContext user = this.sessionManager.getUserContext();
        orderEntity.setCommitDate(new Date());
        orderEntity.setCommitUserCode(user.getUserCode());
        orderEntity.setCommitUserId(user.getUserId());
        orderEntity.setCommitUserName(user.getUserName());
        orderEntity.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u51fa\u65b9\u5ba1\u6279\u4e2d.getCode());
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AllotOrderEntity orderEntity = (AllotOrderEntity)((Object)this.service.selectById(billId));
        orderEntity.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u5f85\u6536\u8d27.getCode());
        this.service.checkAllotableNum(orderEntity.getAllotOrderDetailList());
        this.service.saveOrderOutStore(orderEntity);
        this.service.saveTransfor(orderEntity);
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext user = this.sessionManager.getUserContext();
            orderEntity.setCommitDate(new Date());
            orderEntity.setCommitUserCode(user.getUserCode());
            orderEntity.setCommitUserId(user.getUserId());
            orderEntity.setCommitUserName(user.getUserName());
        } else {
            this.service.saveOrUpdate((Object)orderEntity, false);
        }
        StringBuilder subject = new StringBuilder();
        StringBuilder content = new StringBuilder();
        subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011,\u3010").append(orderEntity.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8ba2\u5355\u88ab\u8c03\u51fa\u65b9\u53d6\u6d88\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
        content.append("\u3010").append(orderEntity.getBillCode()).append("\u3011\uff0c\u3010").append(orderEntity.getInProjectName()).append("\u3011\u7533\u8bf7\u8c03\u62e8\u7684\u7269\u8d44\u5df2\u88ab\u8c03\u51fa\u65b9\u786e\u8ba4\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(new String[]{orderEntity.getPurUserId().toString()});
        parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u8c03\u5165\u8ba2\u5355PC\u8be6\u60c5 + orderEntity.getId().toString());
        parameter.setContent(content.toString());
        parameter.setSubject(subject.toString());
        this.service.sendMsg(parameter, billId, "\u8c03\u51fa\u65b9\u8ba2\u5355\u786e\u8ba4\uff0c\u5411\u8c03\u5165\u65b9\u8054\u7cfb\u4eba\u53d1\u9001\u6d88\u606f");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8c03\u62e8\u8ba2\u5355\u4e0d\u5141\u8bb8\u5f03\u5ba1\u64cd\u4f5c\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.saveDoBpmBack(billId);
    }

    private CommonResponse<String> saveDoBpmBack(Long billId) {
        AllotOrderEntity orderEntity = (AllotOrderEntity)((Object)this.service.selectById(billId));
        orderEntity.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u51fa\u65b9\u53d6\u6d88.getCode());
        StringBuilder subject = new StringBuilder();
        StringBuilder content = new StringBuilder();
        subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011,\u3010").append(orderEntity.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8ba2\u5355\u88ab\u8c03\u51fa\u65b9\u53d6\u6d88\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
        content.append("\u3010").append(orderEntity.getBillCode()).append("\u3011\uff0c\u3010").append(orderEntity.getInProjectName()).append("\u3011\u7533\u8bf7\u8c03\u62e8\u7684\u7269\u8d44\u5df2\u88ab\u8c03\u51fa\u65b9\u53d6\u6d88\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(new String[]{orderEntity.getPurUserId().toString()});
        parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u8c03\u5165\u8ba2\u5355PC\u8be6\u60c5 + orderEntity.getId().toString());
        parameter.setContent(content.toString());
        parameter.setSubject(subject.toString());
        this.service.sendMsg(parameter, billId, "\u8c03\u51fa\u65b9\u8ba2\u5355\u53d6\u6d88\uff0c\u5411\u8c03\u5165\u65b9\u8054\u7cfb\u4eba");
        this.goodsService.updateAllotNum(this.service.getUpdateGoodList(orderEntity.getAllotOrderDetailList(), "release", "allot"), false);
        this.service.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

