/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.shelf.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.panhuo.shelf.bean.GoodsEntity;
import com.ejianc.business.panhuo.shelf.mapper.GoodsMapper;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.foundation.cons.PlanConstant;
import com.ejianc.foundation.panhuo.shelf.vo.GoodsVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsService")
public class GoodsServiceImpl
extends BaseServiceImpl<GoodsMapper, GoodsEntity>
implements IGoodsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IStoreService storeService;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public Boolean inOutStore(List<GoodsEntity> list) {
        this.checkNum(list);
        ArrayList<FlowmeterEntity> flowVOS = new ArrayList<FlowmeterEntity>();
        for (GoodsEntity goodsEntity : list) {
            FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
            flowmeterEntity.setMid(goodsEntity.getId());
            flowmeterEntity.setDetailId(goodsEntity.getId());
            flowmeterEntity.setMaterialId(goodsEntity.getMaterialId());
            flowmeterEntity.setBillCode(goodsEntity.getMaterialCode());
            flowmeterEntity.setProjectId(goodsEntity.getProjectId());
            flowmeterEntity.setProjectName(goodsEntity.getProjectName());
            flowmeterEntity.setStoreId(goodsEntity.getStoreId());
            flowmeterEntity.setStoreType(goodsEntity.getStoreType());
            flowmeterEntity.setStoreName(goodsEntity.getStoreName());
            flowmeterEntity.setSupplierId(goodsEntity.getCloudStoreId());
            flowmeterEntity.setSupplierName(goodsEntity.getCloudStoreName());
            flowmeterEntity.setMaterialCode(goodsEntity.getMaterialCode());
            flowmeterEntity.setMaterialName(goodsEntity.getMaterialName());
            flowmeterEntity.setSpecialModel(goodsEntity.getSpec());
            flowmeterEntity.setMaterialCategoryId(goodsEntity.getMaterialTypeId());
            flowmeterEntity.setMaterialCategoryCode(goodsEntity.getMaterialTypeCode());
            flowmeterEntity.setMaterialCategoryName(goodsEntity.getMaterialTypeName());
            flowmeterEntity.setBillStatus(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            flowmeterEntity.setBillTime(goodsEntity.getCreateTime());
            flowmeterEntity.setSubUnitId(goodsEntity.getCloudStoreId());
            flowmeterEntity.setSubUnitName(goodsEntity.getCloudStoreName());
            flowmeterEntity.setOperationType("\u51fa\u5e93");
            flowmeterEntity.setAccessType("\u76d8\u6d3b\u4e0a\u67b6");
            flowmeterEntity.setTime(goodsEntity.getCreateTime());
            flowmeterEntity.setQuantity(goodsEntity.getNum());
            flowmeterEntity.setAmountIncluetax(goodsEntity.getTaxMny());
            flowmeterEntity.setAmountExcluetax(goodsEntity.getMny());
            flowmeterEntity.setUnitPriceIncluetax(goodsEntity.getTaxPrice());
            flowmeterEntity.setUnitPriceExcluetax(goodsEntity.getPrice());
            flowmeterEntity.setOrgId(goodsEntity.getOrgId());
            flowmeterEntity.setOrgName(goodsEntity.getOrgName());
            flowmeterEntity.setMeasurementUnit(goodsEntity.getUnitName());
            flowmeterEntity.setProjectDepartmentId(goodsEntity.getOrgId());
            flowmeterEntity.setOutId(goodsEntity.getId());
            flowmeterEntity.setBillType(1);
            flowVOS.add(flowmeterEntity);
        }
        this.logger.info("\u8c03\u7528\u5e93\u5b58\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString(flowVOS));
        this.flowmeterService.saveOrUpdateBatch(flowVOS);
        for (GoodsEntity entity : list) {
            this.realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
        }
        return true;
    }

    private void checkNum(List<GoodsEntity> list) {
        BigDecimal inNum;
        String key;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.and(q -> {
            for (GoodsEntity f : list) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.ne((Object)"mid", (Object)f.getId())).eq((Object)"store_id", (Object)f.getStoreId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        List flowmeterEntities = this.flowmeterService.list((Wrapper)wrapper);
        HashMap<String, BigDecimal> numInMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> numOutMap = new HashMap<String, BigDecimal>();
        for (FlowmeterEntity flow : flowmeterEntities) {
            key = flow.getStoreId() + "@" + flow.getMaterialId();
            if (flow.getOperationType().equals("\u5165\u5e93")) {
                inNum = numInMap.containsKey(key) ? (BigDecimal)numInMap.get(key) : BigDecimal.ZERO;
                inNum = ComputeUtil.safeAdd((BigDecimal)inNum, (BigDecimal)flow.getQuantity());
                numInMap.put(key, inNum);
                continue;
            }
            if (!flow.getOperationType().equals("\u51fa\u5e93")) continue;
            BigDecimal outNum = numOutMap.containsKey(key) ? (BigDecimal)numOutMap.get(key) : BigDecimal.ZERO;
            outNum = ComputeUtil.safeAdd((BigDecimal)outNum, (BigDecimal)flow.getQuantity());
            numOutMap.put(key, outNum);
        }
        for (GoodsEntity goodsEntity : list) {
            if (null == goodsEntity.getStoreId()) continue;
            key = goodsEntity.getStoreId() + "@" + goodsEntity.getMaterialId();
            inNum = numInMap.containsKey(key) ? (BigDecimal)numInMap.get(key) : BigDecimal.ZERO;
            BigDecimal outNum = numOutMap.containsKey(key) ? (BigDecimal)numOutMap.get(key) : BigDecimal.ZERO;
            BigDecimal subtract = ComputeUtil.safeSub((BigDecimal)inNum, (BigDecimal)outNum);
            if (!ComputeUtil.isGreaterThan((BigDecimal)goodsEntity.getNum(), (BigDecimal)subtract)) continue;
            throw new BusinessException("\u7269\u8d44\u7f16\u53f7:" + goodsEntity.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + goodsEntity.getMaterialName() + "\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u80fd\u4e0a\u67b6!");
        }
    }

    @Override
    public Boolean inOutStoreRollback(List<GoodsEntity> list) {
        List idList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(FlowmeterEntity::getMid, idList);
        queryWrapper.eq(FlowmeterEntity::getBillState, (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        this.flowmeterService.remove((Wrapper)queryWrapper);
        for (GoodsEntity entity : list) {
            this.realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
        }
        return true;
    }

    @Override
    public List<GoodsVO> updateAllotNum(List<GoodsVO> vos, Boolean flag) {
        List ids = vos.stream().map(BaseVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return vos;
        }
        Map<Long, GoodsVO> map = vos.stream().collect(Collectors.toMap(x -> x.getId(), x -> x, (v1, v2) -> v2));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", ids));
        List list = super.queryList(param);
        for (GoodsEntity entity : list) {
            BigDecimal num = map.get(entity.getId()).getAllotNum();
            if (flag.booleanValue()) {
                entity.setAllotNum(ComputeUtil.safeAdd((BigDecimal)entity.getAllotNum(), (BigDecimal)num));
            } else {
                entity.setAllotNum(ComputeUtil.safeSub((BigDecimal)entity.getAllotNum(), (BigDecimal)num));
            }
            entity.setSurplusNum(ComputeUtil.safeSub((BigDecimal)entity.getNum(), (BigDecimal[])new BigDecimal[]{entity.getAllotedNum(), entity.getAllotNum()}));
            if (ComputeUtil.isLessThan((BigDecimal)entity.getSurplusNum(), (BigDecimal)BigDecimal.ZERO)) {
                throw new BusinessException("\u5269\u4f59\u53ef\u8c03\u62e8\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0!");
            }
            if (ComputeUtil.isEmpty((BigDecimal)entity.getSurplusNum()).booleanValue()) {
                entity.setStatus(PlanConstant.GOODS_STATUS_OUT);
                entity.setLowerType(PlanConstant.OUT_TYPE_SALE);
                entity.setLowerId(InvocationInfoProxy.getUserid());
                entity.setLowerName(this.sessionManager.getUserContext().getUserName());
                entity.setLowerCode(InvocationInfoProxy.getUsercode());
                entity.setLowerTime(DateFormater.getCurrentDate());
                entity.setLowerNum(entity.getSurplusNum());
            }
            if (!PlanConstant.GOODS_STATUS_OUT.equals(entity.getStatus()) || !ComputeUtil.isGreaterThan((BigDecimal)entity.getSurplusNum(), (BigDecimal)BigDecimal.ZERO)) continue;
            entity.setStatus(PlanConstant.GOODS_STATUS_ON);
        }
        super.saveOrUpdateBatch((Collection)list);
        return BeanMapper.mapList((Iterable)list, GoodsVO.class);
    }

    @Override
    public List<GoodsVO> updateAllotedNum(List<GoodsVO> vos, Boolean flag) {
        List ids = vos.stream().map(BaseVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return vos;
        }
        Map<Long, GoodsVO> map = vos.stream().collect(Collectors.toMap(x -> x.getId(), x -> x, (v1, v2) -> v2));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", ids));
        List list = super.queryList(param);
        for (GoodsEntity entity : list) {
            BigDecimal num = map.get(entity.getId()).getAllotedNum();
            if (flag.booleanValue()) {
                entity.setAllotedNum(ComputeUtil.safeAdd((BigDecimal)entity.getAllotedNum(), (BigDecimal)num));
            } else {
                entity.setAllotedNum(ComputeUtil.safeSub((BigDecimal)entity.getAllotedNum(), (BigDecimal)num));
            }
            entity.setSurplusNum(ComputeUtil.safeSub((BigDecimal)entity.getNum(), (BigDecimal[])new BigDecimal[]{entity.getAllotedNum(), entity.getAllotNum()}));
            if (ComputeUtil.isLessThan((BigDecimal)entity.getSurplusNum(), (BigDecimal)BigDecimal.ZERO)) {
                throw new BusinessException("\u5269\u4f59\u53ef\u8c03\u62e8\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0!");
            }
            if (ComputeUtil.isEmpty((BigDecimal)entity.getSurplusNum()).booleanValue()) {
                entity.setStatus(PlanConstant.GOODS_STATUS_OUT);
                entity.setLowerType(PlanConstant.OUT_TYPE_SALE);
                entity.setLowerId(InvocationInfoProxy.getUserid());
                entity.setLowerName(this.sessionManager.getUserContext().getUserName());
                entity.setLowerCode(InvocationInfoProxy.getUsercode());
                entity.setLowerTime(DateFormater.getCurrentDate());
                entity.setLowerNum(entity.getSurplusNum());
            }
            if (!PlanConstant.GOODS_STATUS_OUT.equals(entity.getStatus()) || !ComputeUtil.isGreaterThan((BigDecimal)entity.getSurplusNum(), (BigDecimal)BigDecimal.ZERO)) continue;
            entity.setStatus(PlanConstant.GOODS_STATUS_ON);
        }
        super.saveOrUpdateBatch((Collection)list);
        return BeanMapper.mapList((Iterable)list, GoodsVO.class);
    }

    @Override
    public Map<Long, BigDecimal> getAllotableNum(List<Long> ids) {
        HashMap<Long, BigDecimal> resp = new HashMap<Long, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"id", "surplus_num"});
        query.in((Object)"id", ids);
        List rs = super.listMaps((Wrapper)query);
        rs.stream().forEach(item -> resp.put(Long.valueOf(item.get("id").toString()), new BigDecimal(item.get("surplus_num").toString())));
        return resp;
    }

    @Override
    public List<GoodsEntity> getAllByIds(List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"id", ids);
        return super.list((Wrapper)query);
    }

    @Override
    public GoodsVO queryGoodsDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)super.selectById((Serializable)id));
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(GoodsEntity::getProjectId, (Object)entity.getProjectId());
        lambdachange.eq(GoodsEntity::getStatus, (Object)PlanConstant.GOODS_STATUS_ON);
        lambdachange.gt(GoodsEntity::getSurplusNum, (Object)0);
        int nums = super.count((Wrapper)lambdachange);
        vo.setOtherNums(nums);
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(GoodsEntity::getProjectId, (Object)entity.getProjectId());
        lambdachange2.eq(GoodsEntity::getStatus, (Object)PlanConstant.GOODS_STATUS_ON);
        lambdachange2.ne(BaseEntity::getId, (Object)id);
        lambdachange2.gt(GoodsEntity::getSurplusNum, (Object)0);
        lambdachange2.last("limit 3");
        List list = super.list((Wrapper)lambdachange2);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setOthersGoods(BeanMapper.mapList((Iterable)list, GoodsVO.class));
        }
        return vo;
    }
}

