package com.ejianc.business.material.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.DeviceexitrecordsEntity;
import com.ejianc.business.material.bean.DeviceverificationrecordsEntity;
import com.ejianc.business.material.bean.WastematerialresulttailEntity;
import com.ejianc.business.material.service.IDeviceexitrecordsService;
import com.ejianc.business.material.service.IDeviceverificationrecordsService;
import com.ejianc.business.material.service.IEquipmentEntryExitService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.business.material.vo.ReturnVO;
import com.ejianc.foundation.material.vo.EquipmentEntryExitVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 大型机械设备管理台账
 * @author biying
 */
@Controller
@RequestMapping("equipmentEntryExit")
public class EquipmentEntryExitController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IEquipmentEntryExitService service;
    @Autowired
    private IDeviceverificationrecordsService deviceverificationrecordsService;
    @Autowired
    private IDeviceexitrecordsService deviceexitrecordsService;

    /**
     * 查询列表数据
     *
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EquipmentEntryExitVO>> queryList(@RequestBody QueryParam param) {
        List<Long> ids = new ArrayList<>();
        List<EquipmentEntryExitVO> list = new ArrayList<>();
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<DeviceverificationrecordsEntity> entityList = deviceverificationrecordsService.queryList(param);
        if (CollectionUtils.isNotEmpty(entityList)) {
            for (DeviceverificationrecordsEntity entity : entityList) {
                ids.add(entity.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            list = service.queryEquipment(ids);
        }
        IPage<EquipmentEntryExitVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), list.size());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<EquipmentEntryExitVO> list = queryList(param).getData().getRecords();
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("EquipmentEntryExit-export.xlsx", beans, response);
    }

    /**
     * 查询列表数据
     *
     * @return
     */
    @RequestMapping(value = "/queryEntry", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EquipmentEntryExitVO>> queryEntry(@RequestBody QueryParam param){
        Long projectId = null;
        String equipmentCode = null;
        String spec = null;
        String supplierName = param.getSearchText();
        List<Long> ids = new ArrayList<>();
        List<EquipmentEntryExitVO> list = new ArrayList<>();
        if (param.getParams().get("projectId") != null) {
            projectId = Long.valueOf(param.getParams().get("projectId").getValue().toString());
            param.getParams().remove("projectId");
        }
        if (param.getParams().get("equipmentCode") != null) {
            equipmentCode = param.getParams().get("equipmentCode").getValue().toString();
            param.getParams().remove("equipmentCode");
        }
        if (param.getParams().get("spec") != null) {
            spec = param.getParams().get("spec").getValue().toString();
            param.getParams().remove("spec");
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<DeviceverificationrecordsEntity> entityList = deviceverificationrecordsService.queryList(param);
        if (CollectionUtils.isNotEmpty(entityList)) {
            for (DeviceverificationrecordsEntity entity : entityList) {
                ids.add(entity.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            list = service.queryEntry(projectId, equipmentCode, spec, supplierName,ids);
        }
        IPage<EquipmentEntryExitVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), list.size());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/entryExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void entryExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<EquipmentEntryExitVO> list = queryEntry(param).getData().getRecords();
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Entry-export.xlsx", beans, response);
    }

    /**
     * 查询列表数据
     *
     * @return
     */
    @RequestMapping(value = "/queryExit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EquipmentEntryExitVO>> queryExit(@RequestBody QueryParam param){
        Long projectId = null;
        String equipmentCode = null;
        String spec = null;
        String subcontractor = param.getSearchText();
        List<Long> ids = new ArrayList<>();
        List<EquipmentEntryExitVO> list = new ArrayList<>();
        if (param.getParams().get("projectId") != null) {
            projectId = Long.valueOf(param.getParams().get("projectId").getValue().toString());
            param.getParams().remove("projectId");
        }
        if (param.getParams().get("equipmentCode") != null) {
            equipmentCode = param.getParams().get("equipmentCode").getValue().toString();
            param.getParams().remove("equipmentCode");
        }
        if (param.getParams().get("spec") != null) {
            spec = param.getParams().get("spec").getValue().toString();
            param.getParams().remove("spec");
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<DeviceexitrecordsEntity> entityList = deviceexitrecordsService.queryList(param);
        if (CollectionUtils.isNotEmpty(entityList)) {
            for (DeviceexitrecordsEntity entity : entityList) {
                ids.add(entity.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(ids)){
            list = service.queryExit(projectId, equipmentCode, spec, subcontractor, ids);
        }
        IPage<EquipmentEntryExitVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), list.size());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/ExitExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void exitExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<EquipmentEntryExitVO> list = queryExit(param).getData().getRecords();
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Exit-export.xlsx", beans, response);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
