package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.RealtimebalanceEntity;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.service.IMaterialWarehousingService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.utils.PageUtil;
import com.ejianc.business.material.vo.MaterialWarehousingdetailVO;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @Author liyongjia
 * @Date 2020/6/6 仓库管理请控制器
 * @Description storeController
 */

@Controller
@RequestMapping("store")
public class StoreController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IStoreService storeService;
    @Autowired
    IMaterialWarehousingService materialWarehousingService;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;


    /**
     * @Author liyongjia
     * @Date 2020/6/10  保存修改
     * @Description saveOrUpdate
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.storeVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StoreVO> saveOrUpdate(@RequestBody StoreVO vo) {
        StoreEntity entity = BeanMapper.map(vo, StoreEntity.class);
        if(entity.getStoreType() == 0){//成品库 影响成本
            entity.setIsInfluenceCost(0);
        }else{
            entity.setIsInfluenceCost(1);
        }
        //校验一个项目只有一种类型的仓库

        LambdaQueryWrapper<StoreEntity> storeScheme = Wrappers.<StoreEntity>lambdaQuery();
        if (vo.getId() != null){
            storeScheme.ne(StoreEntity::getId, vo.getId());
        }
        storeScheme.eq(StoreEntity::getProjectId, vo.getProjectId());
        storeScheme.eq(StoreEntity::getStoreType, vo.getStoreType());
        List<StoreEntity> storeEntityList = storeService.list(storeScheme);
        if (CollectionUtils.isNotEmpty(storeEntityList)){
            throw new BusinessException("同一个项目下只能新增一种类型的仓库!");
        }

        storeService.saveOrUpdate(entity, false);
        StoreVO backVo = BeanMapper.map(entity, StoreVO.class);
        return CommonResponse.success("保存或修改单据成功！", backVo);
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/2 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.storeVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StoreVO> queryDetail(Long id) {
        StoreEntity entity = storeService.selectById(id);
        StoreVO vo = BeanMapper.map(entity, StoreVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @RequestMapping(value = "/storematerialList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> storematerialList(@RequestBody QueryParam params) {

        if (params.getParams().get("storeId") == null) {
            return CommonResponse.error("仓库id不能为空");
        }

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = params.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialCategoryCode");
        fuzzyFields.add("materialCategoryName");
        Long storeId = Long.parseLong(params.getParams().get("storeId").getValue().toString());
        Integer type = Integer.parseInt(params.getParams().get("type").getValue().toString());
        params.getParams().remove("type");
//        String projectId = params.getParams().get("projectId").toString();
//        params.getParams().put("quantity", new Parameter(QueryParam.GT, new BigDecimal(0.00)));

        /** 租户隔离 */
        params.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        if(storeId != null){
//            params.getParams().put("storeId", new Parameter(QueryParam.EQ, storeId));
//        }
//        if(projectId != null && !projectId.isEmpty()){
//            params.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//            params.getParams().put("quantity", new Parameter(QueryParam.GT, new BigDecimal(0.00)));
//        }
        IPage<RealtimebalanceEntity> page = realtimebalanceService.queryPage(params,false);
        List<RealtimebalanceEntity> realtimebalanceEntities = page.getRecords();
        List<RealtimebalanceEntity> realtimeBalance = realtimebalanceService.getRealtimeBalance(storeId, type, realtimebalanceEntities);
//        page.setRecords(realtimeBalance);
//        IPage<RealtimebalanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RealtimebalanceVO.class));

        JSONObject pageData = new JSONObject();
        pageData.put("current", "" + params.getPageIndex());
        pageData.put("size", "" + params.getPageSize());
        pageData.put("records", new ArrayList<>());
        pageData.put("total", "" + 0);
        pageData.put("pages", "" + 0);

        if (CollectionUtils.isNotEmpty(realtimeBalance)){
            // 分页
            int total = realtimeBalance.size();//总条数
            JSONArray jsonArray = JSONArray.parseArray(JSONArray.toJSONString(realtimeBalance));
            JSONArray records = PageUtil.listToPage(jsonArray, params.getPageIndex(), params.getPageSize());
            int pages = PageUtil.getPages(total,  params.getPageSize());//有几页
            pageData.put("records", records);
            pageData.put("total", "" + total);
            pageData.put("pages", "" + pages);
        }

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/10 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "/excelStoreMaterialList", method = RequestMethod.POST)
    @ResponseBody
    public void excelStoreMaterialList(@RequestBody Map<String,Object> params, HttpServletResponse response) {
        if (params.get("storeId") == null) {
            throw new BusinessException("仓库id不能为空");
        }

        Long storeId = Long.parseLong(params.get("storeId").toString());
        Integer type = Integer.parseInt(params.get("type").toString());
        String projectId = params.get("projectId").toString();
        String searchText = null;
        QueryParam param = new QueryParam();
        param.setPageIndex(0);
        param.setPageSize(10000);
        if (params.get("searchText") != null) {
            searchText = params.get("searchText").toString();
            param.getParams().put("materialName", new Parameter(QueryParam.EQ, searchText));
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(storeId != null){
            param.getParams().put("storeId", new Parameter(QueryParam.EQ, storeId));
        }
        if(projectId != null && !projectId.isEmpty()){
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//            param.getParams().put("quantity", new Parameter(QueryParam.GT, new BigDecimal(0.00)));
        }
        IPage<RealtimebalanceEntity> page = realtimebalanceService.queryPage(param,false);
        List<RealtimebalanceEntity> realtimebalanceEntities = page.getRecords();
        List<RealtimebalanceEntity> realtimeBalance = realtimebalanceService.getRealtimeBalance(storeId, type, realtimebalanceEntities);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", realtimeBalance);
        String fileName = "storeMaterialExport.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }
    @SuppressWarnings("unused")
    private String getText(String str, String pat, int num) {
        Pattern pattern = Pattern.compile(pat);
        Matcher findMatcher = pattern.matcher(str);
        int number = 0;
        while (findMatcher.find()) {
            number++;
            if (number == num) {//
                break;
            }
        }
        int i = findMatcher.start();//第num次出现的位置
        return str.substring(0, i);
    }

    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");

        //租户隔离
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        //param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContext = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContext.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<StoreVO> page = storeService.queryForList(param, false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/10 查询打印数据
     * @Description queryPrint
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("store", storeService.selectById(id));
        return CommonResponse.success("查询打印数据成功！", json);
    }

    /**
     * @Author liyongjia
     * @Date 2020/6/10 删除
     * @Description delete
     * @Param [vos]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StoreVO> vos) {
        return storeService.delete(vos);
    }


    /**
     * @Author liyongjia
     * @Date 2020/6/10 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");

        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContext.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<StoreVO> voPage = storeService.queryForList(queryParam, false);
        List<StoreVO> list = voPage.getRecords();
        for (StoreVO storeVO : list){
            if (storeVO.getStoreType() != null){
//                仓库类型 0-成品库 1-废旧物资库 2-资产库
                if (storeVO.getStoreType() == 0) {
                    storeVO.setStoreTypeName("成品库");
                }
                if (storeVO.getStoreType() == 1) {
                    storeVO.setStoreTypeName("废旧物资库");
                }
                if (storeVO.getStoreType() == 2) {
                    storeVO.setStoreTypeName("资产库");
                }
            }
            if (storeVO.getState() != null){
//                //仓库状态（1、启用，0、停用）
                if (storeVO.getState().equals("0")) {
                    storeVO.setStateName("停用");
                }
                if (storeVO.getState().equals("1")) {
                    storeVO.setStateName("启用");
                }
            }

        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("storeListExport.xlsx", beans, response);
    }

    @RequestMapping(value = "/queryRefList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> queryRefList(
            @RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required = false) String searchText, @RequestParam(required = false) String condition
            , @RequestParam(required = false) String searchObject) {
        Long orgId = null;
        QueryParam param = new QueryParam();

        if (StringUtils.isNotBlank(condition)) {
            JSONObject json = JSONObject.parseObject(condition);
            if (json.get("orgId") != null) {
                orgId = Long.parseLong(json.get("orgId").toString());
                if (null != json.get("selfAndUnderData")) {
                    param.getParams().put("orgId", new Parameter(QueryParam.IN,
                            iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                } else {
                    //默认查本组织的
                    /** 数据隔离 所选组织 */
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
                }
            } else {
                return CommonResponse.error("condition条件缺少orgId！");
            }
            if (null != json.get("sort")) {
                Map<String, Object> sort = JSONObject.parseObject(json.getString("sort"), Map.class);
                for (String key : sort.keySet()) {
                    param.getOrderMap().put(key, sort.get(key).toString());
                }
            }
        } else {
            return CommonResponse.error("缺少condition条件");
        }

        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            for (String key : search.keySet()) {
                param.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
            }
        }
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        if (StringUtils.isNotBlank(searchText)) {
            param.setSearchText(searchText);
            /** 模糊搜索配置字段示例 */
            List<String> fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("name");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }

        //启用的仓库
        param.getParams().put("state", new Parameter(QueryParam.EQ, 1));
        return CommonResponse.success("查询仓库数据成功！", storeService.queryForList(param, false));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/13 根据入库子表计算该入库子表出库时候可用数量
     * @Description calculateCanUseNum
     * @Param [inStoreSubId, materialId]
     * @Return CommonResponse<BigDecimal>
     */
    @RequestMapping(value = "/calculateCanUseNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> calculateCanUseNum(@RequestParam Long inStoreSubId, @RequestParam Long materialId, @RequestParam Long outSubId) {
        return CommonResponse.success("计算可用库存成功！", storeService.calculateCanUseNum(inStoreSubId, materialId, outSubId).toString());
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/17 根据组织查询最新仓库数据
     * @Description queryNewestStoreByOrgId
     * @Param [orgId]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.StoreVO>
     */
    @RequestMapping(value = "/queryNewestStoreByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StoreVO> queryNewestStoreByOrgId(@RequestParam Long orgId) {
        return CommonResponse.success("查询组织最新仓库成功！", storeService.queryNewestStoreByOrgId(orgId));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/17
     * @Description refCanUseNumData 查询库存可用数量参照
     * @Param [pageNumber, pageSize, condition, searchText]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.material.vo.MaterialWarehousingVO>>
     */
    @RequestMapping(value = "/refCanUseNumData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialWarehousingdetailVO>> refCanUseNumData(@RequestParam Integer pageNumber,
                                                                               @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchText, String searchObject) throws ParseException {


        if(StringUtils.isBlank(condition)){
            return CommonResponse.error("查询条件condition不能为空");
        }
        JSONObject con = JSONObject.parseObject(condition);
        String storeIdStr = con.getString("storeId");
        Long storeId = null;
        if(StringUtils.isBlank(storeIdStr)){
            return CommonResponse.error("查询条件【仓库】不能为空");
        }else {
            storeId = Long.parseLong(storeIdStr);
        }
        String outDate = con.getString("outDate");
        if(StringUtils.isBlank(outDate)){
            return CommonResponse.error("查询条件【出库日期】不能为空");
        }

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("storeId",new Parameter(QueryParam.EQ,storeId));
        queryParam.getParams().put("puinTime",new Parameter(QueryParam.LE,outDate));

        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");
        IPage<MaterialWarehousingdetailVO> pageVo = new Page<>();
        IPage<MaterialWarehousingdetailVO> entityPage =
                materialWarehousingService.queryStoreCanUseNumPageData(
                        searchText,
                        searchObject,
                        outDate,
                        storeId,
                        pageNumber, pageSize);
        if (entityPage != null) {
            List<MaterialWarehousingdetailVO> voList = new ArrayList<>();
            entityPage.getRecords().forEach(e -> {
                MaterialWarehousingdetailVO vo = BeanMapper.map(e, MaterialWarehousingdetailVO.class);
                vo.setCanUseNumber(storeService.calculateCanUseNum(vo.getId(), vo.getMaterialId(), null));
                voList.add(vo);
            });
            pageVo.setRecords(voList);
            pageVo.setSize(queryParam.getPageSize());
            pageVo.setCurrent(entityPage.getCurrent());
            pageVo.setPages(entityPage.getPages());
            pageVo.setTotal(entityPage.getTotal());
        }
        return CommonResponse.success("查询出库可用物资参照成功！", entityPage);
    }

    /**
     * 查询指定仓库中可用的物资列表，同一物资数量、总价进行合并，供盘点使用
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
//    @RequestMapping(value = "/refUsableSubMaterialList", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<IPage<MaterialWarehousingVO>> refUsableSubMaterialList(@RequestParam Integer pageNumber,
//                                                                     @RequestParam Integer pageSize,
//                                                                     String condition ,
//                                                                     String searchText, @RequestParam(required = false) String searchObject) {
//        if(StringUtils.isBlank(condition)){
//            return CommonResponse.error("查询条件condition不能为空");
//        }
//        HashMap<String, String> map = null;
//        if (StringUtils.isNotBlank(searchObject)) {
//            JSONObject search = JSONObject.parseObject(searchObject);
//            map = new HashMap<>();
//            if(search.get("materialCategoryName")!=null){
//                map.put("material_category_name",search.get("materialCategoryName").toString());
//    		}
//    		if(search.get("materialName")!=null){
//                map.put("material_name",search.get("materialName").toString());
//    		}
//    		if(search.get("materialSpec")!=null){
//                map.put("material_spec",search.get("materialSpec").toString());
//    		}
//        }
//        JSONObject con = JSONObject.parseObject(condition);
//        if(StringUtils.isBlank(con.getString("storeId"))){
//            return CommonResponse.error("查询条件【仓库】不能为空");
//        }
//        if(StringUtils.isBlank(con.getString("outDate"))){
//            return CommonResponse.error("查询条件【出库日期】不能为空");
//        }
//
//        List<Long> materialIds = null;
//        if(null != con.get("materialIds")) {
//            materialIds = JSONArray.parseArray(con.getString("materialIds"), Long.class);
//        }
//
//        IPage<MaterialWarehousingVO> pageVo = new Page<>();
//        IPage<MaterialWarehousingVO> entityPage =
//                materialWarehousingService.queryUsableSubMaterialList(
//                        searchText,
//                        con.getString("outDate"),
//                        con.getLong("storeId"),pageNumber,pageSize, materialIds, map);
//        if(entityPage!=null){
//            List<MaterialWarehousingVO> voList = new ArrayList<>();
//            entityPage.getRecords().forEach(e->{
//                MaterialWarehousingVO vo = BeanMapper.map(e,MaterialWarehousingVO.class);
//                vo.setCanUseNumber(storeService.calculateCanUseNum(vo.getId(),vo.getMaterialId(),null));
//                voList.add(vo);
//            });
//            pageVo.setRecords(voList);
//            pageVo.setSize(pageSize);
//            pageVo.setCurrent(entityPage.getCurrent());
//            pageVo.setPages(entityPage.getPages());
//            pageVo.setTotal(entityPage.getTotal());
//        }
//        return CommonResponse.success("查询出库可用物资参照成功！",pageVo);
//    }

    /**
     * @Description 仓库参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refStore", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> refStore(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if(_con.get("type")!=null){
                String[] type = _con.get("type").toString().split(",");
                List<String> list = Arrays.asList(type);
                param.getParams().put("store_type", new Parameter(QueryParam.IN, list));
            }
            if(_con.get("isInfluenceCost")!=null){
                param.getParams().put("isInfluenceCost", new Parameter(QueryParam.EQ, _con.get("isInfluenceCost")));
            }
        }

        IPage<StoreEntity> page = storeService.queryPage(param,false);
        IPage<StoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StoreVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description 仓库参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refStoreList", method = RequestMethod.GET)
    @ResponseBody
    public List<StoreVO> refStoreList(@RequestParam(required = false) String condition, @RequestParam(required = false) String searchText) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
                if (!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return null;
                }
                List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
            }
            if(_con.get("type")!=null){
                String[] type = _con.get("type").toString().split(",");
                List<String> list = Arrays.asList(type);
                param.getParams().put("store_type", new Parameter(QueryParam.IN, list));
            }
            if(_con.get("isInfluenceCost")!=null){
                param.getParams().put("isInfluenceCost", new Parameter(QueryParam.EQ, _con.get("isInfluenceCost")));
            }
        }

        List<StoreEntity> list = storeService.queryList(param,false);
        return BeanMapper.mapList(list, StoreVO.class);
    }
}
