package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.DeviceverificationrecordsEntity;
import com.ejianc.business.material.bean.DeviceverificationrecordsdetailEntity;
import com.ejianc.business.material.service.IDeviceverificationrecordsService;
import com.ejianc.business.material.service.IDeviceverificationrecordsdetailService;
import com.ejianc.business.material.vo.DeviceverificationrecordsdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 物资（周转）进场验证记录子表导入导出
 */
@Controller
@RequestMapping("deviceverificationrecordsdetailExport")
public class ExcelDeviceverificationrecordsdetailController {
    private static final long   serialVersionUID= 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDeviceverificationrecordsdetailService service;
    @Autowired
    private IDeviceverificationrecordsService deviceverificationrecordsService;
    /**
     * 导出模板下载
     */
    @RequestMapping(value = "/downloadDeviceverificationrecordsdetail")
    @ResponseBody
    public void downloadDeviceverificationrecordsdetail (HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Deviceverificationrecordsdetail-import.xlsx", "设备进场验证记录明细");
    }
    /**
     * 从Excel导入
     */
    @RequestMapping(value = "/excelImportDeviceverificationrecordsdetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportDeviceverificationrecordsdetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<DeviceverificationrecordsdetailVO> successList = new ArrayList<>();
        List<DeviceverificationrecordsdetailVO> errorList = new ArrayList<>();
        Map<String, DeviceverificationrecordsdetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();
                    String equipmentCode = datas.get(0);
                    String name = datas.get(1);
                    String spec = datas.get(2);
                    String unit = datas.get(3);
                    String enterCount = datas.get(4);//进场数量
                    String verificationCount = datas.get(5);//
                    String verificationWay = datas.get(6);
                    String code = datas.get(7);
                    String conclusion = datas.get(8);
                    String remarks = datas.get(9);
                    //循环进来TPID
                    DeviceverificationrecordsdetailVO DeviceverificationrecordsdetailVO = new DeviceverificationrecordsdetailVO();
                    DeviceverificationrecordsdetailVO.setId(IdWorker.getId());//id
//                    //三目判断值是否空
//                    DeviceverificationrecordsdetailVO.setMaterialCode(StringUtils.isNotBlank(materialCode) ? materialCode : null);
                    DeviceverificationrecordsdetailVO.setEquipmentCode(StringUtils.isNotBlank(equipmentCode) ? equipmentCode : null);
                    DeviceverificationrecordsdetailVO.setName(StringUtils.isNotBlank(name) ? name : null);
                    DeviceverificationrecordsdetailVO.setSpec(StringUtils.isNotBlank(spec) ? spec : null);
                    DeviceverificationrecordsdetailVO.setUnit(StringUtils.isNotBlank(unit) ? unit : null);
                    DeviceverificationrecordsdetailVO.setVerificationWay(StringUtils.isNotBlank(verificationWay) ? verificationWay : null);
                    DeviceverificationrecordsdetailVO.setCode(StringUtils.isNotBlank(code) ? code : null);
                    DeviceverificationrecordsdetailVO.setConclusion(StringUtils.isNotBlank(conclusion) ? conclusion : null);
                    DeviceverificationrecordsdetailVO.setRemarks(StringUtils.isNotBlank(remarks) ? remarks : null); // 备注
//                    //必填项校验
//                    if (name == null || TextUtils.isEmpty(name)) {
//                        DeviceverificationrecordsdetailVO.setErrorMsg("物资名称不能为空！");
//                        errorsMsgBuilder.append("物资名称不能为空！");
//                    }
//
                    Long id = service.queryMaterialByCode(equipmentCode);
                    if (id == null) {
                        DeviceverificationrecordsdetailVO.setErrorMsg("设备编码错误！");
                        errorsMsgBuilder.append("设备编码错误！");
                    }
                    //格式校验
                    if (!TextUtils.isEmpty(verificationCount) && !NumberUtil.isNumber(verificationCount)) {
                        DeviceverificationrecordsdetailVO.setErrorMsg("验证数量格式不正确！");
                        errorsMsgBuilder.append("验证数量格式不正确！");
                    } else {
                        DeviceverificationrecordsdetailVO.setVerificationCount(StringUtils.isNotBlank(verificationCount) ? new BigDecimal(verificationCount) : null); //验证数量
                    }
                    if (!TextUtils.isEmpty(enterCount) && !NumberUtil.isNumber(enterCount)) {
                        DeviceverificationrecordsdetailVO.setErrorMsg("进场数量格式不正确！");
                        errorsMsgBuilder.append("进场数量格式不正确！");
                    } else {
                        DeviceverificationrecordsdetailVO.setEnterCount(StringUtils.isNotBlank(enterCount) ? new BigDecimal(enterCount) : null); //进场数量
                    }
                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(DeviceverificationrecordsdetailVO);
                    }else {
                        successList.add(DeviceverificationrecordsdetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        DeviceverificationrecordsdetailVO resVo = new DeviceverificationrecordsdetailVO();
//        json.put("total", resList);
        json.put("total", resVo);
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDeviceverificationrecordsdetailFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDeviceverificationrecordsdetailFromDatabase(@RequestBody DeviceverificationrecordsdetailVO DeviceverificationrecordsdetailVO, HttpServletResponse response) {
        QueryWrapper<DeviceverificationrecordsdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", DeviceverificationrecordsdetailVO.getId());
        queryWrapper.eq("dr", 0);
        List<DeviceverificationrecordsdetailEntity> list = service.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Deviceverificationrecordsdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDeviceverificationrecordsdetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDeviceverificationrecordsdetailFromPage(@RequestBody List<DeviceverificationrecordsdetailVO> list, HttpServletResponse response) {
        DeviceverificationrecordsEntity deviceverificationrecordsEntity = deviceverificationrecordsService.selectById(list.get(0).getMid());
        for (DeviceverificationrecordsdetailVO vo : list) {
            vo.setProjectName(deviceverificationrecordsEntity.getProjectName());
            vo.setOrgName(deviceverificationrecordsEntity.getOrgName());
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Deviceverificationrecordsdetail-export.xlsx", beans, response);
    }

}
