package com.ejianc.business.material.service.impl;

import com.ejianc.business.material.bean.GatherDetailEntity;
import com.ejianc.business.material.bean.GatherEntity;
import com.ejianc.business.material.mapper.GatherMapper;
import com.ejianc.business.material.service.IGatherDetailService;
import com.ejianc.business.material.service.IGatherService;
import com.ejianc.business.material.vo.GatherDetailVO;
import com.ejianc.business.material.vo.GatherVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 处置统计汇总表
 *
 * @author generator
 */
@Service("gatherService")
public class GatherServiceImpl extends BaseServiceImpl<GatherMapper, GatherEntity> implements IGatherService {

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "GATHER_CODE";//此处需要根据实际修改

    @Autowired
    private IGatherDetailService gatherDetailService;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;

    @Override
    public void generation(String generateDate) {
        LocalDate today = LocalDate.now();
        boolean isFirstDayOfQuarter = true;
//        boolean isFirstDayOfQuarter = isFirstDayOfQuarter(today);

        if (isFirstDayOfQuarter) {
            LocalDate firstDayOfLastQuarter = getFirstDayOfLastQuarter(today);
            LocalDate lastDayOfLastQuarter = getLastDayOfLastQuarter(today);

            LocalDateTime firstTime = firstDayOfLastQuarter.atStartOfDay();
            LocalDateTime lastTime = lastDayOfLastQuarter.atTime(23, 59, 59);

            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String beginDate = firstTime.format(formatter);
            String endDate = lastTime.format(formatter);

            int month = today.getMonthValue();
            int lastQuarterYear;
            int lastQuarterNumber;

            if (month <= 3) {
                lastQuarterYear = today.getYear() - 1; // 去年
                lastQuarterNumber = 4; // 第四季度
            } else if (month <= 6) {
                lastQuarterYear = today.getYear(); // 今年
                lastQuarterNumber = 1; // 第一季度
            } else if (month <= 9) {
                lastQuarterYear = today.getYear(); // 今年
                lastQuarterNumber = 2; // 第二季度
            } else {
                lastQuarterYear = today.getYear(); // 今年
                lastQuarterNumber = 3; // 第三季度
            }

            List<GatherEntity> result = new ArrayList<>();
            List<GatherDetailEntity> detailResult = new ArrayList<>();
            List<GatherDetailVO> recordVOs = baseMapper.generationRecord(beginDate, endDate);
            if (CollectionUtils.isNotEmpty(recordVOs)) {
                Map<String, List<GatherDetailVO>> map = recordVOs.stream().collect(Collectors.groupingBy(x -> x.getParentOrgId() + "@" + x.getParentOrgName() + "@" + x.getOrgId() + "@" + x.getProjectId()  + "@" + x.getProjectName()));
                for (String key : map.keySet()) {
                    Long gatherId = IdWorker.getId();
                    GatherVO gatherVO = new GatherVO();
                    gatherVO.setId(gatherId);
                    gatherVO.setGatherYear(String.valueOf(lastQuarterYear));
                    gatherVO.setGatherQuarter(String.valueOf(lastQuarterNumber));
                    String[] arr = key.split("@");
                    gatherVO.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
                    gatherVO.setParentOrgId(Long.valueOf(arr[0]));
                    gatherVO.setParentOrgName(arr[1]);
                    gatherVO.setOrgId(Long.valueOf(arr[2]));
                    gatherVO.setProjectId(Long.valueOf(arr[3]));
                    gatherVO.setProjectName(arr[4]);
                    CommonResponse<ProjectVO> response = zjkjProjectApi.queryDetailById(gatherVO.getProjectId());
                    if (response.isSuccess() && null != response.getData()) {
                        gatherVO.setProjectCode(response.getData().getBillCode());
                    }
                    BigDecimal totalMny = BigDecimal.ZERO;
                    for (GatherDetailVO detailVO : map.get(key)) {
                        totalMny = ComputeUtil.safeAdd(totalMny, detailVO.getDealMny());
                        GatherDetailEntity detailEntity = BeanMapper.map(detailVO, GatherDetailEntity.class);
                        detailEntity.setGatherId(gatherId);
                        detailResult.add(detailEntity);
                    }
                    gatherVO.setTotalMny(totalMny);
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), gatherVO);
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if (billCode.isSuccess()) {
                        gatherVO.setBillCode(billCode.getData());
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    result.add(BeanMapper.map(gatherVO, GatherEntity.class));
                }
                if (CollectionUtils.isNotEmpty(result)) {
                    saveOrUpdateBatch(result);
                }
                if (CollectionUtils.isNotEmpty(detailResult)) {
                    gatherDetailService.saveOrUpdateBatch(detailResult);
                }
            }
        }
    }

    private boolean isFirstDayOfQuarter(LocalDate date) {
        return (date.getMonthValue() == 1 && date.getDayOfMonth() == 1) ||
                (date.getMonthValue() == 4 && date.getDayOfMonth() == 1) ||
                (date.getMonthValue() == 7 && date.getDayOfMonth() == 1) ||
                (date.getMonthValue() == 10 && date.getDayOfMonth() == 1);
    }

    private LocalDate getFirstDayOfLastQuarter(LocalDate date) {
        int month = date.getMonthValue();
        if (month <= 3) {
            return LocalDate.of(date.getYear() - 1, 10, 1); // 去年第四季度
        } else if (month <= 6) {
            return LocalDate.of(date.getYear(), 1, 1); // 今年第一季度
        } else if (month <= 9) {
            return LocalDate.of(date.getYear(), 4, 1); // 今年第二季度
        } else {
            return LocalDate.of(date.getYear(), 7, 1); // 今年第三季度
        }
    }

    private LocalDate getLastDayOfLastQuarter(LocalDate date) {
        int month = date.getMonthValue();
        if (month <= 3) {
            return LocalDate.of(date.getYear() - 1, 12, 31); // 去年第四季度
        } else if (month <= 6) {
            return LocalDate.of(date.getYear(), 3, 31); // 今年第一季度
        } else if (month <= 9) {
            return LocalDate.of(date.getYear(), 6, 30); // 今年第二季度
        } else {
            return LocalDate.of(date.getYear(), 9, 30); // 今年第三季度
        }
    }
}
