package com.ejianc.business.material.vo;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DealTypeEnum {

    TARGET_STATE(1, "调拨"),
    BID_STATE(2, "废旧回收"),
    ANNOUNCEMENT_STATE(3, "销售"),
    DOCUMENT_STATE(4, "其他");

    private final Integer tenderTypeCode;
    private final String description;
    private static Map<Integer, DealTypeEnum> enumMap = new HashMap();

    private DealTypeEnum(Integer tenderTypeCode, String description) {
        this.tenderTypeCode = tenderTypeCode;
        this.description = description;
    }

    public Integer getTenderTypeCode() {
        return this.tenderTypeCode;
    }

    public String getDescription() {
        return this.description;
    }

    public static DealTypeEnum getEnumByStateCode(Integer tenderTypeCode) {
        return (DealTypeEnum)enumMap.get(tenderTypeCode);
    }

    static {
        enumMap = (Map)EnumSet.allOf(DealTypeEnum.class).stream().collect(Collectors.toMap(DealTypeEnum::getTenderTypeCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
