package com.ejianc.business.panhuo.apply.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.panhuo.apply.bean.AllotApplyDetailEntity;
import com.ejianc.business.panhuo.apply.bean.AllotApplyEntity;
import com.ejianc.business.panhuo.apply.mapper.AllotApplyMapper;
import com.ejianc.business.panhuo.apply.service.IAllotApplyService;
import com.ejianc.business.panhuo.cart.bean.ShopCartEntity;
import com.ejianc.business.panhuo.cart.service.IShopCartService;
import com.ejianc.foundation.cons.enums.ZjkjMaterialCommonEnums;
import com.ejianc.foundation.panhuo.apply.vo.AllotApplyDetailVO;
import com.ejianc.foundation.panhuo.apply.vo.AllotApplyVO;
import com.ejianc.business.panhuo.shelf.bean.GoodsEntity;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.foundation.panhuo.shelf.vo.GoodsVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 调拨申请
 *
 * @author generator
 */
@Service("allotApplyService")
public class AllotApplyServiceImpl extends BaseServiceImpl<AllotApplyMapper, AllotApplyEntity> implements IAllotApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IShopCartService shopCartService;
    @Autowired
    private IGoodsService goodsService;
    private static final String BILL_CODE = "ALLOT_ACCEPT";//此处需要根据实际修改

    @Override

    public void upShopCart(AllotApplyEntity entity) {
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            List<AllotApplyDetailEntity> detailList = entity.getDetailList();
            List<AllotApplyDetailEntity> collect = detailList.stream().filter(e -> e.getSourceType().equals(ZjkjMaterialCommonEnums.购物车.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                List<Long> collect1 = collect.stream().map(e -> e.getSourceCartId()).collect(Collectors.toList());
                shopCartService.upShopCart(collect1);
            }

        }
    }


    @Override
    public AllotApplyVO addAllotApplyByCart(List<ShopCartEntity> carts) {
        Map<Long, ShopCartEntity> collect = carts.stream().collect(Collectors.toMap(ShopCartEntity::getMarketId, e -> e));
        List<Long> collect1 = carts.stream().map(e -> e.getMarketId()).collect(Collectors.toList());
        //根据闲置物资id查询对应闲置物资
        QueryWrapper<GoodsEntity> queryGoods = new QueryWrapper<>();
        queryGoods.in("id", collect1);
        List<GoodsEntity> goods = goodsService.list(queryGoods);
        //根据集市物资添加对应的申请明细

        AllotApplyVO saveOrUpdateVO = new AllotApplyVO();
        List<AllotApplyDetailVO> list = new ArrayList<>();
        for (GoodsEntity go : goods) {
            ShopCartEntity shopCartEntity = collect.get(go.getId());
            BigDecimal allotNum = shopCartEntity.getAllotNum();
            Long sourceCartId = shopCartEntity.getId();
            list.add(makeAllotApply(go, allotNum, 1, sourceCartId));
        }
        saveOrUpdateVO.setDetailList(list);
        List<Long> collect3 = saveOrUpdateVO.getDetailList().stream().map(e -> e.getSourceId()).collect(Collectors.toList());
        Map<Long, BigDecimal> allotableNum = goodsService.getAllotableNum(collect3);
        for (AllotApplyDetailVO detail: saveOrUpdateVO.getDetailList()){
            if (allotableNum.containsKey(detail.getSourceId())){
                detail.setResAllotNum(allotableNum.get(detail.getSourceId()));
            }else {
                detail.setResAllotNum(BigDecimal.ZERO);
            }
        }
        String materialTypeNames = saveOrUpdateVO.getDetailList().stream().map(AllotApplyDetailVO::getMaterialTypeName).collect(Collectors.toSet()).stream().distinct().collect(Collectors.joining(","));
        saveOrUpdateVO.setMaterialNames(materialTypeNames);
        return saveOrUpdateVO;
    }

    @Override
    public AllotApplyVO addAllotApplyByGoods(GoodsVO goodsVO) {
        GoodsEntity goodsEntity = goodsService.selectById(goodsVO.getId());
        goodsEntity.setAllotNum(goodsVO.getAllotNum());
        AllotApplyVO saveOrUpdateVO = new AllotApplyVO();
        List<AllotApplyDetailVO> list = new ArrayList<>();
        list.add(makeAllotApply(goodsEntity, goodsVO.getAllotNum(), 2, null));
        BigDecimal taxMny = list.stream().collect(Collectors.reducing(BigDecimal.ZERO, AllotApplyDetailVO::getAllotTaxMny, BigDecimal::add));
        BigDecimal mny = list.stream().collect(Collectors.reducing(BigDecimal.ZERO, AllotApplyDetailVO::getAllotMny, BigDecimal::add));
        saveOrUpdateVO.setTaxMny(taxMny);
        saveOrUpdateVO.setMny(mny);
        saveOrUpdateVO.setDetailList(list);
        List<Long> collect = saveOrUpdateVO.getDetailList().stream().map(e -> e.getSourceId()).collect(Collectors.toList());
        Map<Long, BigDecimal> allotableNum = goodsService.getAllotableNum(collect);
        for (AllotApplyDetailVO detail: saveOrUpdateVO.getDetailList()){
            if (allotableNum.containsKey(detail.getSourceId())){
                detail.setResAllotNum(allotableNum.get(detail.getSourceId()));
            }else {
                detail.setResAllotNum(BigDecimal.ZERO);
            }
        }
        String materialTypeNames = saveOrUpdateVO.getDetailList().stream().map(AllotApplyDetailVO::getMaterialTypeName).collect(Collectors.toSet()).stream().distinct().collect(Collectors.joining(","));
        saveOrUpdateVO.setMaterialNames(materialTypeNames);
        return saveOrUpdateVO;
    }

    @Override
//    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<AllotApplyVO> queryDetail(Long id) {
        AllotApplyEntity entity = super.selectById(id);
//        upShopCart(entity);
        AllotApplyVO vo = BeanMapper.map(entity, AllotApplyVO.class);
        List<AllotApplyDetailVO> detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)){
            List<Long> collect = detailList.stream().map(e -> e.getSourceId()).collect(Collectors.toList());
            Map<Long, BigDecimal> allotableNum = goodsService.getAllotableNum(collect);
            for (AllotApplyDetailVO detailVO:detailList){
                if (allotableNum.containsKey(detailVO.getSourceId())){
                    detailVO.setResAllotNum(allotableNum.get(detailVO.getSourceId()));
                }
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    public AllotApplyDetailVO makeAllotApply(GoodsEntity go, BigDecimal allotNum, Integer sourceType, Long sourceCartId) {
        AllotApplyDetailVO detail = new AllotApplyDetailVO();
        detail.setSourceId(go.getId());
        detail.setSourceCartId(sourceCartId);
        detail.setSourceType(sourceType);
        detail.setResAllotNum(go.getSurplusNum());
        detail.setMaterialId(go.getMaterialId());
        detail.setMaterialName(go.getMaterialName());
        detail.setMaterialCode(go.getMaterialCode());
        detail.setMaterialId(go.getMaterialId());
        detail.setProductCode(go.getProductCode());
        detail.setPropertyValue(go.getPropertyValue());
        detail.setUnitName(go.getUnitName());
        detail.setUnitId(go.getUnitId());
        detail.setBrandName(go.getBrandName());
        detail.setBrandId(go.getBrandId());
        detail.setMaterialTypeId(go.getMaterialTypeId());
        detail.setMaterialTypeName(go.getMaterialTypeName());
        detail.setMaterialTypeCode(go.getMaterialTypeCode());
        detail.setAvgTaxPrice(go.getOriginalTaxPrice());
        detail.setAvgPrice(go.getOriginalPrice());
        detail.setAvgTaxMny(go.getOriginalTaxMny());
        detail.setAvgMny(go.getOriginalMny());
        detail.setSellTaxPrice(go.getTaxPrice());
        detail.setSellPrice(go.getPrice());
        BigDecimal taxPrice = go.getTaxPrice();
        BigDecimal price = go.getPrice();
        BigDecimal taxMny = ComputeUtil.safeMultiply(allotNum, taxPrice);
        BigDecimal mny = ComputeUtil.safeMultiply(allotNum, price);
        detail.setAllotNum(allotNum);
        detail.setAllotTaxMny(taxMny);
        detail.setAllotMny(mny);
        detail.setOutOrgId(go.getOrgId());
        detail.setOutOrgName(go.getOrgName());
        detail.setOutOrgCode(go.getOrgCode());
        detail.setOutParentOrgId(go.getParentOrgId());
        detail.setOutParentOrgCode(go.getParentOrgCode());
        detail.setOutParentOrgName(go.getParentOrgName());
        detail.setOutProjectId(go.getProjectId());
        detail.setOutProjectName(go.getProjectName());
        detail.setOutProjectCode(go.getProjectCode());
        detail.setOutProjectAddress(go.getAddress());
        if (go.getStoreType().equals(ZjkjMaterialCommonEnums.大区.getCode())) {
            detail.setExceedOrgId(go.getOrgId());
            detail.setExceedOrgName(go.getOrgName());
            detail.setExceedOrgCode(go.getOrgCode());
            detail.setOutStoreId(go.getStoreId());
            detail.setOutStoreName(go.getStoreName());
        } else {
            detail.setExceedOrgId(go.getProjectId());
            detail.setExceedOrgName(go.getProjectName());
            detail.setExceedOrgCode(go.getProjectCode());
            detail.setOutStoreId(go.getStoreId());
            detail.setOutStoreName(go.getStoreName());
        }
        detail.setCorpId(go.getCorpId());
        detail.setCorpCode(go.getCorpCode());
        detail.setCorpName(go.getCorpName());
        detail.setStoreType(go.getStoreType());
        detail.setAttrFlag(go.getAttrFlag().toString());
        detail.setSellUserId(go.getSellUserId());
        detail.setSellUserName(go.getSellUserName());
        detail.setSellUserCode(go.getSellerUserCode());
        detail.setSellUserPhone(go.getSellUserPhone());
        detail.setSellDate(go.getShelfTime());
        detail.setDiscount(go.getDiscount());
        return detail;
    }

//    public void addOrderBy
}
