package com.ejianc.business.panhuo.order.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 调拨订单明细表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_allot_order_detail")
public class AllotOrderDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="source_id")
    private Long sourceId; // 物资在集市id
    @TableField(value="order_id")
    private Long orderId; // 订单Id
    @TableField(value="allot_apply_detail_id")
    private Long allotApplyDetailId; // 调拨申请子表id
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_code")
    private String materialCode; // 物资编码
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资分类名称
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资分类id
    @TableField(value="material_type_code")
    private String materialTypeCode; // 物资分类编码
    @TableField(value="brand_id")
    private Long brandId; // 品牌Id
    @TableField(value="brand_name")
    private String brandName; // 品牌名称
    @TableField(value="unit_name")
    private String unitName; // 计量单位
    @TableField(value="unit_id")
    private Long unitId; // 计量单位id
    @TableField(value="product_code")
    private String productCode; // 产品代码
    @TableField(value="property_value")
    private String propertyValue; // 属性
    @TableField(value="sell_user_id")
    private Long sellUserId; // 发布人id
    @TableField(value="sell_user_name")
    private String sellUserName; // 发布人名称
    @TableField(value="sell_user_code")
    private String sellUserCode; // 发布人编码
    @TableField(value="sell_user_phone")
    private String sellUserPhone; // 发布人手机号
    @TableField(value = "initial_allot_num")
    private BigDecimal initialAllotNum; // 初始调拨量
    @TableField(value="allot_num")
    private BigDecimal allotNum; // 调拨量
    @TableField(value="avg_tax_price")
    private BigDecimal avgTaxPrice; // 原材料均价（含税）
    @TableField(value="avg_price")
    private BigDecimal avgPrice; // 原材料均价
    @TableField(value="sell_tax_price")
    private BigDecimal sellTaxPrice; // 出售单价（含税）
    @TableField(value="sell_price")
    private BigDecimal sellPrice; // 出售单价
    @TableField(value = "sell_num")
    private BigDecimal sellNum; //出售数量
    @TableField(value="initial_sell_tax_price")
    private BigDecimal initialSellTaxPrice; // 初始出售单价（含税）
    @TableField(value="initial_sell_price")
    private BigDecimal initialSellPrice; // 初始出售单价
    @TableField(value="detail_allot_tax_mny")
    private BigDecimal detailAllotTaxMny; // 调拨金额（含税）
    @TableField(value="detail_allot_mny")
    private BigDecimal detailAllotMny; // 调拨金额
    @TableField(value="initial_allot_tax_mny")
    private BigDecimal initialAllotTaxMny; // 初始调拨金额（含税）
    @TableField(value="initial_allot_mny")
    private BigDecimal initialAllotMny; // 初始调拨金额
    @TableField(value="detail_asset_tax_mny")
    private BigDecimal detailAssetTaxMny; // 资产金额（含税）
    @TableField(value="detail_asset_mny")
    private BigDecimal detailAssetMny; // 资产金额
    @TableField(value="initial_asset_tax_mny")
    private BigDecimal initialAssetTaxMny; // 初始资产金额（含税）
    @TableField(value="initial_asset_mny")
    private BigDecimal initialAssetMny; // 初始资产金额
    @TableField(value="out_store_id")
    private Long outStoreId; // 物料来源仓库Id
    @TableField(value="out_store_name")
    private String outStoreName; // 物料来源仓库名称
    @TableField(value="attr_flag")
    private Integer attrFlag; // 物料来源仓库属性  1-主材库；2-临建材库，3-甲供材库，4-实际仓
    @TableField(value="store_type")
    private Integer storeType; // 物料来源仓库类型：1-项目仓，2-大区仓
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(value = "in_store_id")
    private Long inStoreId; // 调入仓库Id
    @TableField(value = "in_store_name")
    private String inStoreName; // 调入仓库名称
    @TableField(value = "in_store_attr_flag")
    private Integer inStoreAttrFlag; // 调入仓库属性  1-主材库；2-临建材库，3-甲供材库，4-实际仓

    //用于从调拨申请接受数据字段
    @TableField(exist = false)
    private BigDecimal allotMny; // 调拨金额(无税)
    @TableField(exist = false)
    private BigDecimal allotTaxMny; // 调拨金额

    public BigDecimal getSellNum() {
        return sellNum;
    }

    public void setSellNum(BigDecimal sellNum) {
        this.sellNum = sellNum;
    }

    public BigDecimal getAllotMny() {
        return allotMny;
    }

    public void setAllotMny(BigDecimal allotMny) {
        this.allotMny = allotMny;
    }

    public BigDecimal getAllotTaxMny() {
        return allotTaxMny;
    }

    public void setAllotTaxMny(BigDecimal allotTaxMny) {
        this.allotTaxMny = allotTaxMny;
    }

    public BigDecimal getInitialAllotNum() {
        return initialAllotNum;
    }

    public void setInitialAllotNum(BigDecimal initialAllotNum) {
        this.initialAllotNum = initialAllotNum;
    }

    public Long getInStoreId() {
        return inStoreId;
    }

    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }

    public String getInStoreName() {
        return inStoreName;
    }

    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }

    public Integer getInStoreAttrFlag() {
        return inStoreAttrFlag;
    }

    public void setInStoreAttrFlag(Integer inStoreAttrFlag) {
        this.inStoreAttrFlag = inStoreAttrFlag;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public Long getAllotApplyDetailId() {
        return allotApplyDetailId;
    }

    public void setAllotApplyDetailId(Long allotApplyDetailId) {
        this.allotApplyDetailId = allotApplyDetailId;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }
    public String getPropertyValue() {
        return propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }
    public Long getSellUserId() {
        return sellUserId;
    }

    public void setSellUserId(Long sellUserId) {
        this.sellUserId = sellUserId;
    }
    public String getSellUserName() {
        return sellUserName;
    }

    public void setSellUserName(String sellUserName) {
        this.sellUserName = sellUserName;
    }
    public String getSellUserCode() {
        return sellUserCode;
    }

    public void setSellUserCode(String sellUserCode) {
        this.sellUserCode = sellUserCode;
    }
    public String getSellUserPhone() {
        return sellUserPhone;
    }

    public void setSellUserPhone(String sellUserPhone) {
        this.sellUserPhone = sellUserPhone;
    }
    public BigDecimal getAllotNum() {
        return allotNum;
    }

    public void setAllotNum(BigDecimal allotNum) {
        this.allotNum = allotNum;
    }
    public BigDecimal getAvgTaxPrice() {
        return avgTaxPrice;
    }

    public void setAvgTaxPrice(BigDecimal avgTaxPrice) {
        this.avgTaxPrice = avgTaxPrice;
    }
    public BigDecimal getAvgPrice() {
        return avgPrice;
    }

    public void setAvgPrice(BigDecimal avgPrice) {
        this.avgPrice = avgPrice;
    }
    public BigDecimal getSellTaxPrice() {
        return sellTaxPrice;
    }

    public void setSellTaxPrice(BigDecimal sellTaxPrice) {
        this.sellTaxPrice = sellTaxPrice;
    }
    public BigDecimal getSellPrice() {
        return sellPrice;
    }

    public void setSellPrice(BigDecimal sellPrice) {
        this.sellPrice = sellPrice;
    }
    public BigDecimal getInitialSellTaxPrice() {
        return initialSellTaxPrice;
    }

    public void setInitialSellTaxPrice(BigDecimal initialSellTaxPrice) {
        this.initialSellTaxPrice = initialSellTaxPrice;
    }
    public BigDecimal getInitialSellPrice() {
        return initialSellPrice;
    }

    public void setInitialSellPrice(BigDecimal initialSellPrice) {
        this.initialSellPrice = initialSellPrice;
    }
    public BigDecimal getDetailAllotTaxMny() {
        return detailAllotTaxMny;
    }

    public void setDetailAllotTaxMny(BigDecimal detailAllotTaxMny) {
        this.detailAllotTaxMny = detailAllotTaxMny;
    }
    public BigDecimal getInitialAllotTaxMny() {
        return initialAllotTaxMny;
    }

    public void setInitialAllotTaxMny(BigDecimal initialAllotTaxMny) {
        this.initialAllotTaxMny = initialAllotTaxMny;
    }
    public BigDecimal getDetailAssetTaxMny() {
        return detailAssetTaxMny;
    }

    public void setDetailAssetTaxMny(BigDecimal detailAssetTaxMny) {
        this.detailAssetTaxMny = detailAssetTaxMny;
    }
    public BigDecimal getInitialAssetTaxMny() {
        return initialAssetTaxMny;
    }

    public void setInitialAssetTaxMny(BigDecimal initialAssetTaxMny) {
        this.initialAssetTaxMny = initialAssetTaxMny;
    }
    public Long getOutStoreId() {
        return outStoreId;
    }

    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }
    public String getOutStoreName() {
        return outStoreName;
    }

    public void setOutStoreName(String outStoreName) {
        this.outStoreName = outStoreName;
    }
    public Integer getAttrFlag() {
        return attrFlag;
    }

    public void setAttrFlag(Integer attrFlag) {
        this.attrFlag = attrFlag;
    }
    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getDetailAllotMny() {
        return detailAllotMny;
    }

    public void setDetailAllotMny(BigDecimal detailAllotMny) {
        this.detailAllotMny = detailAllotMny;
    }

    public BigDecimal getDetailAssetMny() {
        return detailAssetMny;
    }

    public void setDetailAssetMny(BigDecimal detailAssetMny) {
        this.detailAssetMny = detailAssetMny;
    }

    public BigDecimal getInitialAssetMny() {
        return initialAssetMny;
    }

    public void setInitialAssetMny(BigDecimal initialAssetMny) {
        this.initialAssetMny = initialAssetMny;
    }

    public BigDecimal getInitialAllotMny() {
        return initialAllotMny;
    }

    public void setInitialAllotMny(BigDecimal initialAllotMny) {
        this.initialAllotMny = initialAllotMny;
    }
}
