/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.RealtimebalanceEntity;
import com.ejianc.business.material.mapper.RealtimebalanceMapper;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="realtimebalanceService")
public class RealtimebalanceServiceImpl
extends BaseServiceImpl<RealtimebalanceMapper, RealtimebalanceEntity>
implements IRealtimebalanceService {
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;

    @Override
    @Transactional
    public void updateRealtimeBalance(Long storeId) {
        LambdaQueryWrapper lambdaReal = Wrappers.lambdaQuery();
        lambdaReal.eq(RealtimebalanceEntity::getStoreId, (Object)storeId);
        super.remove((Wrapper)lambdaReal);
        LambdaQueryWrapper lambdaFlow = Wrappers.lambdaQuery();
        lambdaFlow.eq(FlowmeterEntity::getStoreId, (Object)storeId);
        List flowmeterEntityList = this.flowmeterService.list((Wrapper)lambdaFlow);
        if (CollectionUtils.isNotEmpty((Collection)flowmeterEntityList)) {
            ArrayList<RealtimebalanceEntity> realtimebalanceEntities = new ArrayList<RealtimebalanceEntity>();
            List flowmeterEntityListNew = flowmeterEntityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FlowmeterEntity>(Comparator.comparing(f -> f.getMaterialId()))), ArrayList::new));
            Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> mnyTaxInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> mnyTaxOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> mnyInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> mnyOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            BigDecimal inNum = BigDecimal.ZERO;
            BigDecimal outNum = BigDecimal.ZERO;
            BigDecimal mnyTaxIn = BigDecimal.ZERO;
            BigDecimal mnyTaxOut = BigDecimal.ZERO;
            BigDecimal mnyIn = BigDecimal.ZERO;
            BigDecimal mnyOut = BigDecimal.ZERO;
            for (FlowmeterEntity flowmeterEntity : flowmeterEntityListNew) {
                inNum = BigDecimal.ZERO;
                outNum = BigDecimal.ZERO;
                mnyTaxIn = BigDecimal.ZERO;
                mnyTaxOut = BigDecimal.ZERO;
                mnyIn = BigDecimal.ZERO;
                mnyOut = BigDecimal.ZERO;
                RealtimebalanceEntity realtimebalanceEntity = new RealtimebalanceEntity();
                realtimebalanceEntity.setProjectId(flowmeterEntity.getProjectId());
                realtimebalanceEntity.setProjectName(flowmeterEntity.getProjectName());
                realtimebalanceEntity.setMaterialCode(flowmeterEntity.getMaterialCode());
                realtimebalanceEntity.setMaterialName(flowmeterEntity.getMaterialName());
                realtimebalanceEntity.setMaterialId(flowmeterEntity.getMaterialId());
                realtimebalanceEntity.setMaterialCategoryId(flowmeterEntity.getMaterialCategoryId());
                realtimebalanceEntity.setMaterialCategoryCode(flowmeterEntity.getMaterialCategoryCode());
                realtimebalanceEntity.setMaterialCategoryName(flowmeterEntity.getMaterialCategoryName());
                realtimebalanceEntity.setStoreId(flowmeterEntity.getStoreId());
                realtimebalanceEntity.setStoreName(flowmeterEntity.getStoreName());
                if (numInMap.containsKey(flowmeterEntity.getMaterialId())) {
                    inNum = numInMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : numInMap.get(flowmeterEntity.getMaterialId());
                    mnyTaxIn = mnyTaxInMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : mnyTaxInMap.get(flowmeterEntity.getMaterialId());
                    BigDecimal bigDecimal = mnyIn = mnyInMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : mnyInMap.get(flowmeterEntity.getMaterialId());
                }
                if (numOutMap.containsKey(flowmeterEntity.getMaterialId())) {
                    outNum = numOutMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : numOutMap.get(flowmeterEntity.getMaterialId());
                    mnyTaxOut = mnyTaxOutMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : mnyTaxOutMap.get(flowmeterEntity.getMaterialId());
                    mnyOut = mnyOutMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : mnyOutMap.get(flowmeterEntity.getMaterialId());
                }
                realtimebalanceEntity.setQuantity(inNum.subtract(outNum));
                if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    realtimebalanceEntity.setAmountIncluetax(mnyTaxIn.subtract(mnyTaxOut));
                    realtimebalanceEntity.setAmountExcluetax(mnyIn.subtract(mnyOut));
                    realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                    realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                } else {
                    realtimebalanceEntity.setAmountIncluetax(new BigDecimal(0.0));
                    realtimebalanceEntity.setAmountExcluetax(new BigDecimal(0.0));
                    realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.0));
                    realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.0));
                }
                realtimebalanceEntity.setOrgId(flowmeterEntity.getOrgId());
                realtimebalanceEntity.setOrgName(flowmeterEntity.getOrgName());
                realtimebalanceEntity.setMeasurementUnit(flowmeterEntity.getMeasurementUnit());
                realtimebalanceEntity.setSpecialModel(flowmeterEntity.getSpecialModel());
                realtimebalanceEntity.setProjectDepartmentId(flowmeterEntity.getProjectDepartmentId());
                realtimebalanceEntities.add(realtimebalanceEntity);
            }
            this.realtimebalanceService.saveBatch(realtimebalanceEntities);
        }
    }

    @Override
    @Transactional
    public List<RealtimebalanceEntity> getRealtimeBalance(Long storeId, Integer type, List<RealtimebalanceEntity> realtimebalanceEntityList) {
        if (CollectionUtils.isNotEmpty(realtimebalanceEntityList)) {
            List flowmeterEntityList;
            List materialIds = realtimebalanceEntityList.stream().map(RealtimebalanceEntity::getMaterialId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaFlow = Wrappers.lambdaQuery();
            lambdaFlow.eq(FlowmeterEntity::getStoreId, (Object)storeId);
            lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
            if (type == 0) {
                lambdaFlow.eq(FlowmeterEntity::getBillStatus, (Object)1);
            }
            if (CollectionUtils.isNotEmpty((Collection)(flowmeterEntityList = this.flowmeterService.list((Wrapper)lambdaFlow)))) {
                ArrayList<RealtimebalanceEntity> realtimebalanceEntities = new ArrayList<RealtimebalanceEntity>();
                List flowmeterEntityListNew = flowmeterEntityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FlowmeterEntity>(Comparator.comparing(f -> f.getMaterialId()))), ArrayList::new));
                Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> mnyTaxInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> mnyTaxOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> mnyInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> mnyOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                BigDecimal inNum = BigDecimal.ZERO;
                BigDecimal outNum = BigDecimal.ZERO;
                BigDecimal mnyTaxIn = BigDecimal.ZERO;
                BigDecimal mnyTaxOut = BigDecimal.ZERO;
                BigDecimal mnyIn = BigDecimal.ZERO;
                BigDecimal mnyOut = BigDecimal.ZERO;
                for (FlowmeterEntity flowmeterEntity : flowmeterEntityListNew) {
                    inNum = BigDecimal.ZERO;
                    outNum = BigDecimal.ZERO;
                    mnyTaxIn = BigDecimal.ZERO;
                    mnyTaxOut = BigDecimal.ZERO;
                    mnyIn = BigDecimal.ZERO;
                    mnyOut = BigDecimal.ZERO;
                    RealtimebalanceEntity realtimebalanceEntity = new RealtimebalanceEntity();
                    realtimebalanceEntity.setProjectId(flowmeterEntity.getProjectId());
                    realtimebalanceEntity.setProjectName(flowmeterEntity.getProjectName());
                    realtimebalanceEntity.setMaterialCode(flowmeterEntity.getMaterialCode());
                    realtimebalanceEntity.setMaterialName(flowmeterEntity.getMaterialName());
                    realtimebalanceEntity.setMaterialId(flowmeterEntity.getMaterialId());
                    realtimebalanceEntity.setMaterialCategoryId(flowmeterEntity.getMaterialCategoryId());
                    realtimebalanceEntity.setMaterialCategoryCode(flowmeterEntity.getMaterialCategoryCode());
                    realtimebalanceEntity.setMaterialCategoryName(flowmeterEntity.getMaterialCategoryName());
                    realtimebalanceEntity.setStoreId(flowmeterEntity.getStoreId());
                    realtimebalanceEntity.setStoreName(flowmeterEntity.getStoreName());
                    if (numInMap.containsKey(flowmeterEntity.getMaterialId())) {
                        inNum = numInMap.get(flowmeterEntity.getMaterialId());
                        mnyTaxIn = mnyTaxInMap.get(flowmeterEntity.getMaterialId());
                        mnyIn = mnyInMap.get(flowmeterEntity.getMaterialId());
                    }
                    if (numOutMap.containsKey(flowmeterEntity.getMaterialId())) {
                        outNum = numOutMap.get(flowmeterEntity.getMaterialId());
                        mnyTaxOut = mnyTaxOutMap.get(flowmeterEntity.getMaterialId());
                        mnyOut = mnyOutMap.get(flowmeterEntity.getMaterialId());
                    }
                    realtimebalanceEntity.setQuantity(inNum.subtract(outNum));
                    if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                        realtimebalanceEntity.setAmountIncluetax(mnyTaxIn.subtract(mnyTaxOut));
                        realtimebalanceEntity.setAmountExcluetax(mnyIn.subtract(mnyOut));
                        realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                        realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                    } else {
                        realtimebalanceEntity.setAmountIncluetax(new BigDecimal(0.0));
                        realtimebalanceEntity.setAmountExcluetax(new BigDecimal(0.0));
                        realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.0));
                        realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.0));
                    }
                    realtimebalanceEntity.setOrgId(flowmeterEntity.getOrgId());
                    realtimebalanceEntity.setOrgName(flowmeterEntity.getOrgName());
                    realtimebalanceEntity.setMeasurementUnit(flowmeterEntity.getMeasurementUnit());
                    realtimebalanceEntity.setSpecialModel(flowmeterEntity.getSpecialModel());
                    realtimebalanceEntity.setProjectDepartmentId(flowmeterEntity.getProjectDepartmentId());
                    realtimebalanceEntities.add(realtimebalanceEntity);
                }
                Map realMap = realtimebalanceEntities.stream().collect(Collectors.toMap(RealtimebalanceEntity::getMaterialId, Function.identity()));
                for (RealtimebalanceEntity realtimebalanceEntity : realtimebalanceEntityList) {
                    if (!realMap.containsKey(realtimebalanceEntity.getMaterialId())) continue;
                    RealtimebalanceEntity realtimebalanceData = (RealtimebalanceEntity)((Object)realMap.get(realtimebalanceEntity.getMaterialId()));
                    realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceData.getUnitPriceExcluetax());
                    realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceData.getUnitPriceIncluetax());
                    realtimebalanceEntity.setAmountExcluetax(realtimebalanceData.getAmountExcluetax());
                    realtimebalanceEntity.setAmountIncluetax(realtimebalanceData.getAmountIncluetax());
                    realtimebalanceEntity.setQuantity(realtimebalanceData.getQuantity());
                }
            }
        }
        List<RealtimebalanceEntity> collect = new ArrayList<RealtimebalanceEntity>();
        if (CollectionUtils.isNotEmpty(realtimebalanceEntityList)) {
            collect = realtimebalanceEntityList.stream().filter(s -> s.getQuantity().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.toList());
        }
        return collect;
    }
}

