/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import org.apache.commons.lang3.StringUtils;

public class ComputeUtil {
    public static int precision = 8;

    public static BigDecimal safeAdd(BigDecimal decimal1, BigDecimal ... addNums) {
        for (BigDecimal temp : addNums) {
            decimal1 = ComputeUtil.safeAdd(decimal1, temp);
        }
        return decimal1;
    }

    public static BigDecimal safeAdd(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            return decimal2;
        }
        if (decimal2 == null) {
            return decimal1;
        }
        return decimal1.add(decimal2);
    }

    public static BigDecimal safeSub(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }
        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }
        return decimal1.subtract(decimal2);
    }

    public static BigDecimal safeSub(BigDecimal decimal1, BigDecimal ... subNums) {
        for (BigDecimal temp : subNums) {
            decimal1 = ComputeUtil.safeSub(decimal1, temp);
        }
        return decimal1;
    }

    public static BigDecimal safeDiv(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null || decimal2 == null || decimal2.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal(0);
        }
        return decimal1.divide(decimal2, precision, 4);
    }

    public static BigDecimal safeDiv(BigDecimal decimal1, BigDecimal ... divNums) {
        for (BigDecimal temp : divNums) {
            decimal1 = ComputeUtil.safeDiv(decimal1, temp);
        }
        return decimal1.setScale(precision, 4);
    }

    public static BigDecimal safeMultiply(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }
        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }
        return decimal1.multiply(decimal2).setScale(precision, 4);
    }

    public static BigDecimal safeMultiply(BigDecimal decimal1, BigDecimal ... mulNums) {
        for (BigDecimal temp : mulNums) {
            decimal1 = ComputeUtil.safeMultiply(decimal1, temp);
        }
        return decimal1.setScale(precision, 4);
    }

    public static BigDecimal scaleTwo(BigDecimal src) {
        return ComputeUtil.scale(src, 2);
    }

    public static BigDecimal scale(BigDecimal x, int scale) {
        if (x == null) {
            return null;
        }
        return x.setScale(scale, 4);
    }

    public static BigDecimal toBigDecimal(Integer x) {
        if (x == null) {
            return null;
        }
        return new BigDecimal(x.toString());
    }

    public static BigDecimal toBigDecimal(Long x) {
        if (x == null) {
            return null;
        }
        return new BigDecimal(x.toString());
    }

    public static BigDecimal toBigDecimal(Double x) {
        if (x == null) {
            return null;
        }
        return new BigDecimal(x.toString());
    }

    public static BigDecimal toBigDecimal(Float x) {
        if (x == null) {
            return null;
        }
        return new BigDecimal(x.toString());
    }

    public static BigDecimal toBigDecimal(String x) {
        if (StringUtils.isEmpty((CharSequence)x)) {
            return null;
        }
        return new BigDecimal(x);
    }

    public static BigDecimal toBigDecimal(Object x) {
        if (x == null) {
            return null;
        }
        BigDecimal result = null;
        try {
            result = new BigDecimal(x.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isGreaterThan(BigDecimal num1, BigDecimal num2) {
        return ComputeUtil.nullToZero(num1).compareTo(ComputeUtil.nullToZero(num2)) == 1;
    }

    public static boolean isGreaterOrEqual(BigDecimal num1, BigDecimal num2) {
        return ComputeUtil.isGreaterThan(num1, num2) || ComputeUtil.equals(num1, num2);
    }

    public static boolean isLessThan(BigDecimal num1, BigDecimal num2) {
        return ComputeUtil.nullToZero(num1).compareTo(ComputeUtil.nullToZero(num2)) == -1;
    }

    public static boolean isLessOrEqual(BigDecimal num1, BigDecimal num2) {
        return ComputeUtil.isLessThan(num1, num2) || ComputeUtil.equals(num1, num2);
    }

    public static boolean equals(BigDecimal num1, BigDecimal num2) {
        return ComputeUtil.nullToZero(num1).compareTo(ComputeUtil.nullToZero(num2)) == 0;
    }

    public static String getPercentage(BigDecimal num1, BigDecimal num2) {
        BigDecimal result = ComputeUtil.nullToZero(num1).divide(num2, 4, RoundingMode.HALF_UP);
        NumberFormat percent = NumberFormat.getPercentInstance();
        percent.setMaximumFractionDigits(2);
        return percent.format(result.doubleValue());
    }

    public static BigDecimal bigDecimalPercent(Integer num1, Integer num2, int point) {
        if (num1 == null || num2 == null) {
            return BigDecimal.ZERO;
        }
        if (num2.equals(0)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimalNum1 = new BigDecimal(num1);
        BigDecimal bigDecimalNum2 = new BigDecimal(num2);
        return ComputeUtil.bigDecimalPercent(bigDecimalNum1, bigDecimalNum2, point);
    }

    public static BigDecimal bigDecimalPercent(BigDecimal num1, BigDecimal num2, int point) {
        if (num1 == null || num2 == null) {
            return BigDecimal.ZERO;
        }
        if (ComputeUtil.equals(BigDecimal.ZERO, num2)) {
            return BigDecimal.ZERO;
        }
        BigDecimal percent = num1.divide(num2, point + 2, RoundingMode.HALF_UP);
        BigDecimal percent100 = percent.multiply(new BigDecimal(100)).setScale(point);
        return percent100;
    }

    public static Boolean isEmpty(BigDecimal num) {
        return null == num || BigDecimal.ZERO.compareTo(num) == 0;
    }

    public static Boolean isNotEmpty(BigDecimal num) {
        return ComputeUtil.isEmpty(num) == false;
    }

    public static BigDecimal convertToMinusNumber(BigDecimal num) {
        if (ComputeUtil.isLessOrEqual(num, BigDecimal.ZERO)) {
            return num;
        }
        return BigDecimal.ZERO.subtract(num);
    }

    public static BigDecimal nullToZero(BigDecimal num) {
        return ComputeUtil.isEmpty(num) != false ? BigDecimal.ZERO : num;
    }

    public static void main(String[] args) {
        System.out.println(ComputeUtil.bigDecimalPercent(BigDecimal.TEN, ComputeUtil.toBigDecimal("100"), 2));
    }
}

