/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.service.ITransferorderdetailService;
import com.ejianc.business.material.vo.TransferorderVO;
import com.ejianc.business.material.vo.TransferorderdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"transferorderdetailExport"})
public class ExeclTransferorderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITransferorderdetailService iTransferorderdetailService;

    @RequestMapping(value={"/downloadTransferorderdetail"})
    @ResponseBody
    public void downloadTransferorderdetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"transferorderdetail-import.xlsx", (String)"\u7269\u8d44\u8c03\u62e8\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportTransferorderdetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTransferorderdetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<TransferorderdetailVO> successList = new ArrayList<TransferorderdetailVO>();
        ArrayList<TransferorderdetailVO> errorList = new ArrayList<TransferorderdetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String materialCode = (String)datas.get(0);
                String materialName = (String)datas.get(1);
                String specialModel = (String)datas.get(2);
                String measurementUnit = (String)datas.get(3);
                String quantity = (String)datas.get(4);
                String transferPrice = (String)datas.get(5);
                String transferAmount = (String)datas.get(6);
                String remarks = (String)datas.get(7);
                TransferorderdetailVO transferorderdetailVO = new TransferorderdetailVO();
                transferorderdetailVO.setId(IdWorker.getId());
                if (!TextUtils.isEmpty((CharSequence)materialCode) && !NumberUtil.isNumber((String)materialCode)) {
                    transferorderdetailVO.setErrorMsg("\u6750\u6599\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6750\u6599\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    transferorderdetailVO.setMaterialCode(StringUtils.isNotBlank((CharSequence)materialCode) ? new String(materialCode) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)materialName) && !NumberUtil.isNumber((String)materialName)) {
                    transferorderdetailVO.setErrorMsg("\u7269\u8d44\u540d\u79f0\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u7269\u8d44\u540d\u79f0\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    transferorderdetailVO.setMaterialName(StringUtils.isNotBlank((CharSequence)materialName) ? new String(materialName) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)specialModel) && !NumberUtil.isNumber((String)specialModel)) {
                    transferorderdetailVO.setErrorMsg("\u89c4\u683c\u578b\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u89c4\u683c\u578b\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    transferorderdetailVO.setSpecialModel(StringUtils.isNotBlank((CharSequence)specialModel) ? new String(specialModel) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)measurementUnit) && !NumberUtil.isNumber((String)measurementUnit)) {
                    transferorderdetailVO.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u8ba1\u91cf\u5355\u4f4d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    transferorderdetailVO.setMeasurementUnit(StringUtils.isNotBlank((CharSequence)measurementUnit) ? new String(measurementUnit) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)quantity) && !NumberUtil.isNumber((String)quantity)) {
                    transferorderdetailVO.setErrorMsg("\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    transferorderdetailVO.setQuantity(StringUtils.isNotBlank((CharSequence)quantity) ? new BigDecimal(quantity) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)transferPrice) && !NumberUtil.isNumber((String)transferPrice)) {
                    transferorderdetailVO.setErrorMsg("\u8c03\u62e8\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u8c03\u62e8\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    transferorderdetailVO.setTransferPrice(StringUtils.isNotBlank((CharSequence)transferPrice) ? new BigDecimal(transferPrice) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)transferAmount) && !NumberUtil.isNumber((String)transferAmount)) {
                    transferorderdetailVO.setErrorMsg("\u8c03\u62e8\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u8c03\u62e8\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    transferorderdetailVO.setTransferAmount(StringUtils.isNotBlank((CharSequence)transferAmount) ? new BigDecimal(transferAmount) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)remarks) && !NumberUtil.isNumber((String)remarks)) {
                    transferorderdetailVO.setErrorMsg("\u5907\u6ce8\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5907\u6ce8\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    transferorderdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)remarks) ? new String(remarks) : null);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(transferorderdetailVO);
                    continue;
                }
                successList.add(transferorderdetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        TransferorderdetailVO resVo = new TransferorderdetailVO();
        json.put("total", successList);
        json.put("total", (Object)resVo);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportTransferorderdetailFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTransferorderFromDatabase(@RequestBody TransferorderVO transferorderVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)transferorderVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.iTransferorderdetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("transferorderdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportTransferorderdetailFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTransferorderFromPage(@RequestBody List<TransferorderdetailVO> list, HttpServletResponse response) {
        ArrayList<TransferorderdetailVO> concatList = new ArrayList<TransferorderdetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                TransferorderdetailVO transferorderdetailVO = list.get(i);
                concatList.add(transferorderdetailVO);
            }
        }
        List<TransferorderdetailVO> allList = this.handleList(list, concatList);
        HashMap<String, List<TransferorderdetailVO>> beans = new HashMap<String, List<TransferorderdetailVO>>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("transferorderdetail-export.xlsx", beans, response);
    }

    private List<TransferorderdetailVO> handleList(List<TransferorderdetailVO> list, List<TransferorderdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            TransferorderdetailVO transferorderdetailVO = list.get(i);
            List<TransferorderdetailVO> children = transferorderdetailVO.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        return concatList;
    }
}

