/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.shelf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.utils.OrgUtil;
import com.ejianc.business.panhuo.shelf.bean.ShelfDetailEntity;
import com.ejianc.business.panhuo.shelf.bean.ShelfEntity;
import com.ejianc.business.panhuo.shelf.mapper.ShelfMapper;
import com.ejianc.business.panhuo.shelf.service.IShelfService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.panhuo.shelf.vo.ShelfDetailVO;
import com.ejianc.foundation.panhuo.shelf.vo.ShelfVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="shelfService")
public class ShelfServiceImpl
extends BaseServiceImpl<ShelfMapper, ShelfEntity>
implements IShelfService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZJKJ_MATERIAL_SHELF";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public ShelfVO saveOrUpdate(ShelfVO saveOrUpdateVO) {
        Map<Long, OrgVO> corpMap;
        ShelfEntity data = saveOrUpdateVO.getId() == null ? null : (ShelfEntity)((Object)this.selectById(saveOrUpdateVO.getId()));
        this.validateStoreNum(saveOrUpdateVO);
        ShelfEntity entity = (ShelfEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ShelfEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        OrgVO corp = (corpMap = this.orgUtil.findListByIds(new ArrayList<Long>(Arrays.asList(entity.getOrgId())))).containsKey(entity.getOrgId()) ? corpMap.get(entity.getOrgId()) : new OrgVO();
        entity.setCorpId(corp.getId());
        entity.setCorpCode(corp.getCode());
        entity.setCorpName(corp.getName());
        if (entity.getCreateUserId() == null) {
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        super.saveOrUpdate((Object)entity, false);
        List<ShelfDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            ArrayList<String> fileIds = new ArrayList<String>();
            for (ShelfDetailEntity detail : detailList) {
                if (!StringUtils.isNotEmpty((CharSequence)detail.getFileIds())) continue;
                List<String> strings = Arrays.asList(detail.getFileIds().split(","));
                fileIds.addAll(strings);
                this.attachmentApi.updateAttachRef(detail.getId(), strings.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()));
            }
            if (data != null) {
                List<ShelfDetailEntity> dataList = data.getDetailList();
                ArrayList<String> delIds = new ArrayList<String>();
                for (ShelfDetailEntity detail : dataList) {
                    if (!StringUtils.isNotEmpty((CharSequence)detail.getFileIds())) continue;
                    delIds.addAll(Arrays.asList(detail.getFileIds().split(",")));
                }
                delIds.removeAll(fileIds);
                if (CollectionUtils.isNotEmpty(delIds)) {
                    this.attachmentApi.delete(delIds.stream().collect(Collectors.joining(",")));
                }
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public ShelfVO queryDetail(Long id) {
        ShelfEntity entity = (ShelfEntity)((Object)super.selectById((Serializable)id));
        ShelfVO vo = (ShelfVO)BeanMapper.map((Object)((Object)entity), ShelfVO.class);
        if (BillStateEnum.COMMITED_STATE.equals((Object)entity.getBillState()) || BillStateEnum.PASSED_STATE.equals((Object)entity.getBillState())) {
            return vo;
        }
        Map<String, BigDecimal> storeMap = this.getStoreMap(vo);
        List detailList = vo.getDetailList();
        for (ShelfDetailVO detail : detailList) {
            String key = detail.getStoreId() + "@" + detail.getMaterialId();
            if (!storeMap.containsKey(key)) continue;
            detail.setStoreNum(storeMap.get(key));
        }
        return vo;
    }

    @Override
    public Boolean validateStoreNum(ShelfVO vo) {
        Map<String, BigDecimal> storeMap = this.getStoreMap(vo);
        for (ShelfDetailVO detailVO : vo.getDetailList()) {
            if (null == detailVO.getStoreId()) continue;
            String key = detailVO.getStoreId() + "@" + detailVO.getMaterialId();
            BigDecimal subtract = storeMap.get(key);
            if (!ComputeUtil.isGreaterThan((BigDecimal)detailVO.getNum(), (BigDecimal)subtract)) continue;
            throw new BusinessException("\u7269\u8d44\u7f16\u53f7:" + detailVO.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + detailVO.getMaterialName() + "\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u80fd\u4e0a\u67b6!");
        }
        return true;
    }

    private Map<String, BigDecimal> getStoreMap(ShelfVO vo) {
        BigDecimal inNum;
        String key;
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        List list = vo.getDetailList();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.and(q -> {
            for (ShelfDetailVO f : list) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"store_id", (Object)f.getStoreId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        List flowmeterEntities = this.flowmeterService.list((Wrapper)wrapper);
        HashMap<String, BigDecimal> numInMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> numOutMap = new HashMap<String, BigDecimal>();
        for (FlowmeterEntity flow : flowmeterEntities) {
            key = flow.getStoreId() + "@" + flow.getMaterialId();
            if (flow.getOperationType().equals("\u5165\u5e93")) {
                inNum = numInMap.containsKey(key) ? (BigDecimal)numInMap.get(key) : BigDecimal.ZERO;
                inNum = ComputeUtil.safeAdd((BigDecimal)inNum, (BigDecimal)flow.getQuantity());
                numInMap.put(key, inNum);
                continue;
            }
            if (!flow.getOperationType().equals("\u51fa\u5e93")) continue;
            BigDecimal outNum = numOutMap.containsKey(key) ? (BigDecimal)numOutMap.get(key) : BigDecimal.ZERO;
            outNum = ComputeUtil.safeAdd((BigDecimal)outNum, (BigDecimal)flow.getQuantity());
            numOutMap.put(key, outNum);
        }
        for (ShelfDetailVO detailVO : list) {
            key = detailVO.getStoreId() + "@" + detailVO.getMaterialId();
            inNum = numInMap.containsKey(key) ? (BigDecimal)numInMap.get(key) : BigDecimal.ZERO;
            BigDecimal outNum = numOutMap.containsKey(key) ? (BigDecimal)numOutMap.get(key) : BigDecimal.ZERO;
            BigDecimal subtract = ComputeUtil.safeSub((BigDecimal)inNum, (BigDecimal)outNum);
            result.put(key, subtract);
        }
        return result;
    }
}

