package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 物资结存(新)
 *
 * @author generator
 *
 */
 @TableName("ejc_material_check")
public class CheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="remarks")
    private String remarks; // 备注
    @TableField(value="agent_id")
    private Long agentId; // 经办人
    @TableField(value="agent_name")
    private String agentName; // 经办人姓名
    @TableField(value="dept_id")
    private Long deptId; // 经办部门id
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="store_id")
    private Long storeId; // 仓库id
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="last_check_num")
    private BigDecimal lastCheckNum; // 上月结存数量
    @TableField(value="last_check_tax_mny")
    private BigDecimal lastCheckTaxMny; // 上月结存金额（含税）
    @TableField(value="last_check_mny")
    private BigDecimal lastCheckMny; // 上月结存金额（无税）
    @TableField(value="check_num")
    private BigDecimal checkNum; // 本月结存数量
    @TableField(value="check_tax_mny")
    private BigDecimal checkTaxMny; // 本月结存金额（含税）
    @TableField(value="check_mny")
    private BigDecimal checkMny; // 本月结存金额（无税）
    @TableField(value="use_num")
    private BigDecimal useNum; // 本月消耗数量
    @TableField(value="use_tax_mny")
    private BigDecimal useTaxMny; // 本月消耗金额（含税）
    @TableField(value="use_mny")
    private BigDecimal useMny; // 本月消耗金额（无税）
    @TableField(value="check_month")
    private Date checkMonth; // 结存月份
    @TableField(value="is_settlement")
    private Integer isSettlement; // 是否归集标记
    @TableField(exist = false)
    private String billStateStr;


    @TableField(exist=false)
    @SubEntity(serviceName="checkDetailService", pidName = "checkId")
    private List<CheckDetailEntity> detailList = new ArrayList<>(); // 物资结存子表(新)


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public BigDecimal getLastCheckNum() {
        return lastCheckNum;
    }

    public void setLastCheckNum(BigDecimal lastCheckNum) {
        this.lastCheckNum = lastCheckNum;
    }
    public BigDecimal getLastCheckTaxMny() {
        return lastCheckTaxMny;
    }

    public void setLastCheckTaxMny(BigDecimal lastCheckTaxMny) {
        this.lastCheckTaxMny = lastCheckTaxMny;
    }
    public BigDecimal getLastCheckMny() {
        return lastCheckMny;
    }

    public void setLastCheckMny(BigDecimal lastCheckMny) {
        this.lastCheckMny = lastCheckMny;
    }
    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }
    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }
    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }

    public BigDecimal getUseNum() {
        return useNum;
    }

    public void setUseNum(BigDecimal useNum) {
        this.useNum = useNum;
    }

    public BigDecimal getUseTaxMny() {
        return useTaxMny;
    }

    public void setUseTaxMny(BigDecimal useTaxMny) {
        this.useTaxMny = useTaxMny;
    }

    public BigDecimal getUseMny() {
        return useMny;
    }

    public void setUseMny(BigDecimal useMny) {
        this.useMny = useMny;
    }

    public Date getCheckMonth() {
        return checkMonth;
    }

    public void setCheckMonth(Date checkMonth) {
        this.checkMonth = checkMonth;
    }
    public Integer getIsSettlement() {
        return isSettlement;
    }

    public void setIsSettlement(Integer isSettlement) {
        this.isSettlement = isSettlement;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public List<CheckDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CheckDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
