package com.ejianc.business.material.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IGatherSendService;
import com.ejianc.business.material.vo.FlowmeterVO;
import com.ejianc.foundation.material.vo.GatherSendVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 收发存报表
 * @author
 */

@Controller
@RequestMapping("gathersend")
public class GatherSendController implements Serializable {
    private static final long serialVersionUID = 1L;


    @Autowired
    private IGatherSendService service;

    @Autowired
    private IFlowmeterService flowmeterService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOrgApi iOrgApi;

 /*
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GatherSendVO>> queryReportList(@RequestBody QueryParam param ) {
        Parameter approveTime = param.getParams().get("approveTime");
        //开始日期
        String stateDate = null;
        //开始日期减一个月
        String stateDateSub = null;
        //结束日期
        String endDate = null;
        if(approveTime!= null){
            Date dateSub = null;
            String[] date = approveTime.getValue().toString().split(",");
            stateDate = date[0];
            endDate = date[1];

            try {
                dateSub = DateUtils.parseDate(date[0],"yyyy-MM-dd");
            } catch (ParseException e) {
                e.printStackTrace();
            }
            stateDateSub = DateFormatUtils.format(DateUtils.addMonths(dateSub, -1), "yyyy-MM-dd");
        }
        Parameter storeTypepar = param.getParams().get("storeType");
        Integer storeType = null;
        if(storeTypepar != null){
            storeType = Integer.parseInt(param.getParams().get("storeType").getValue().toString());
        }
        String searchText = param.getSearchText();
        List<GatherSendVO> enterVoIpage = new ArrayList<>();
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        //如果等等空不查询上月结存
        if(stateDate == null || endDate == null){
            enterVoIpage = service.queryList(storeType,stateDate,endDate,searchText,commonOrgIds,departmentIds);
        }else{
            enterVoIpage = service.queryListAll(storeType,stateDate,endDate,searchText,stateDateSub,commonOrgIds,departmentIds);
        }

        IPage<GatherSendVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), enterVoIpage.size());
        pageData.setRecords(enterVoIpage);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }*/


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GatherSendVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectId");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("specialModel");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCategoryCode");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("operationType");
        fuzzyFields.add("accessType");
        fuzzyFields.add("time");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billStatus", new Parameter(QueryParam.EQ, 1));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        //查询本期
        List<FlowmeterEntity> flowmeterEntityList = flowmeterService.queryList(param,false);
        //查询上期
        Parameter approveTime = param.getParams().get("approveTime");
        //开始日期减一个月
        String stateDateSub = null;
        if(approveTime!= null){
            Date dateSub = null;
            String[] date = approveTime.getValue().toString().split(",");

            try {
                dateSub = DateUtils.parseDate(date[0],"yyyy-MM-dd");
            } catch (ParseException e) {
                e.printStackTrace();
            }
            stateDateSub = DateFormatUtils.format(DateUtils.addDays(dateSub, -1), "yyyy-MM-dd");
        }
        List<FlowmeterEntity> flowmeterEntityListTop = new ArrayList<>();
        if(stateDateSub != null){
            param.getParams().remove("approveTime");
            param.getParams().put("approveTime", new Parameter(QueryParam.LE, stateDateSub));
            flowmeterEntityListTop = flowmeterService.queryList(param,false); //上期数据
        }
        List<GatherSendVO> gatherSendVOList = service.queryFlow(flowmeterEntityList,flowmeterEntityListTop);


        IPage<GatherSendVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), gatherSendVOList.size());
        pageData.setRecords(gatherSendVOList);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectId");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("specialModel");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCategoryCode");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("operationType");
        fuzzyFields.add("accessType");
        fuzzyFields.add("time");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billStatus", new Parameter(QueryParam.EQ, 1));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        //查询本期
        List<FlowmeterEntity> flowmeterEntityList = flowmeterService.queryList(param,false);
        //查询上期
        Parameter approveTime = param.getParams().get("approveTime");
        //开始日期减一个月
        String stateDateSub = null;
        if(approveTime!= null){
            Date dateSub = null;
            String[] date = approveTime.getValue().toString().split(",");

            try {
                dateSub = DateUtils.parseDate(date[0],"yyyy-MM-dd");
            } catch (ParseException e) {
                e.printStackTrace();
            }
            stateDateSub = DateFormatUtils.format(DateUtils.addDays(dateSub, -1), "yyyy-MM-dd");
        }
        List<FlowmeterEntity> flowmeterEntityListTop = new ArrayList<>();
        if(stateDateSub != null){
            param.getParams().remove("approveTime");
            param.getParams().put("approveTime", new Parameter(QueryParam.LE, stateDateSub));
            flowmeterEntityListTop = flowmeterService.queryList(param,false); //上期数据
        }
        List<GatherSendVO> gatherSendVOList = service.queryFlow(flowmeterEntityList,flowmeterEntityListTop);

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", gatherSendVOList);
        ExcelExport.getInstance().export("GatherSend-export.xlsx", beans, response);
    }


    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

}
