package com.ejianc.business.outputValue.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 公司经营指标 （产值）变更
 *
 * @author generator
 *
 */
 @TableName("ejc_output_value_company_business_quota_change")
public class CompanyBusinessQuotaChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="data_id")
    private Long dataId; // 项目补充信息id
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="org_short_name")
    private String orgShortName; // 区域简称
    @TableField(value="year")
    private String year; // 年度

    @TableField(value="this_year_revenue_quota")
    private BigDecimal thisYearRevenueQuota; // 本年下达的营业收入指标(亿元)
    @TableField(value="last_year_completed_project_number")
    private Long lastYearCompletedProjectNumber; // 上年竣工项目数（个）
    @TableField(value="last_year_completed_space")
    private BigDecimal lastYearCompletedSpace; // 上年竣工面积（万平米）
    @TableField(value="last_year_project_confirmed_output_value")
    private BigDecimal lastYearProjectConfirmedOutputValue; // 上年项目确认产值(亿元)
    @TableField(value="last_year_project_completed_output_value")
    private BigDecimal lastYearProjectCompletedOutputValue; // 上年项目完成产值(亿元)
    @TableField(value="last_year_start_work_project_number")
    private Long lastYearStartWorkProjectNumber; // 上年开工项目数（个）
    @TableField(value="last_year_start_work_space")
    private BigDecimal lastYearStartWorkSpace; // 上年开工面积（万平米）
    @TableField(value="last_year_pc_output_value")
    private BigDecimal lastYearPcOutputValue; // 上年PC工厂产值(亿元)
    @TableField(value="last_year_complete_total_output_value")
    private BigDecimal lastYearCompleteTotalOutputValue; // 上年完成总产值(亿元)
    @TableField(value="this_year_plan_first_quarter")
    private BigDecimal thisYearPlanFirstQuarter; // 本年计划产值-一季度产值计划(亿元)
    @TableField(value="this_year_plan_second_quarter")
    private BigDecimal thisYearPlanSecondQuarter; // 本年计划产值-二季度产值计划(亿元)
    @TableField(value="this_year_plan_third_quarter")
    private BigDecimal thisYearPlanThirdQuarter; // 本年计划产值-三季度产值计划(亿元)
    @TableField(value="this_year_plan_furth_quarter")
    private BigDecimal thisYearPlanFurthQuarter; // 本年计划产值-四季度产值计划(亿元)
    @TableField(value="this_year_plan_undertake_output_value")
    private BigDecimal thisYearPlanUndertakeOutputValue; // 本年计划产值-新承接项目计划完成产值(亿元)
    @TableField(value="this_year_plan_building_output_value")
    private BigDecimal thisYearPlanBuildingOutputValue; // 本年计划产值-在施项目计划完成产值(亿元)
    @TableField(value="this_year_plan_pc_output_value")
    private BigDecimal thisYearPlanPcOutputValue; // 本年计划产值-PC工厂计划完成产值(亿元)
    @TableField(value="this_year_plan_total_output_value")
    private BigDecimal thisYearPlanTotalOutputValue; // 本年计划产值-总计划完成产值(亿元)
    @TableField(value="this_year_plan_business_indicator_description")
    private String thisYearPlanBusinessIndicatorDescription; // 本年计划产值-经营指标描述
    @TableField(value="this_year_plan_responsibility_letter")
    private String thisYearPlanResponsibilityLetter; // 本年计划产值-责任书
    @TableField(value="this_year_complete_total_output_value")
    private BigDecimal thisYearCompleteTotalOutputValue; // 本年完成产值-总完成产值(亿元)
    @TableField(value="this_year_complete_project_output_value")
    private BigDecimal thisYearCompleteProjectOutputValue; // 本年完成产值-项目完成产值(亿元)
    @TableField(value="this_year_complete_project_confirmed_output_value")
    private BigDecimal thisYearCompleteProjectConfirmedOutputValue; // 本年完成产值-项目确认产值(亿元)
    @TableField(value="this_year_complete_building_project_number")
    private Long thisYearCompleteBuildingProjectNumber; // 本年完成产值-在施项目数（个）
    @TableField(value="this_year_complete_pc_output_value")
    private BigDecimal thisYearCompletePcOutputValue; // 本年完成产值-PC工厂完成产值(亿元)
    @TableField(value="this_year_complete_start_work_space")
    private BigDecimal thisYearCompleteStartWorkSpace; // 本年完成产值-开工面积(万平米)
    @TableField(value="this_year_complete_completed_space")
    private BigDecimal thisYearCompleteCompletedSpace; // 本年完成产值-竣工面积(万平米)
    @TableField(value="this_year_complete_building_space")
    private BigDecimal thisYearCompleteBuildingSpace; // 本年完成产值-施工面积（万平方米）
    @TableField(value="this_year_complete_building_project_contract_surplus")
    private BigDecimal thisYearCompleteBuildingProjectContractSurplus; // 本年完成产值-在施项目合同余量(亿元)
    @TableField(value="this_year_complete_building_project_contract_amount")
    private BigDecimal thisYearCompleteBuildingProjectContractAmount; // 本年完成产值-在施项目合同额(亿元)

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Long getDataId() {
        return dataId;
    }

    public void setDataId(Long dataId) {
        this.dataId = dataId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgShortName() {
        return orgShortName;
    }

    public void setOrgShortName(String orgShortName) {
        this.orgShortName = orgShortName;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public BigDecimal getThisYearRevenueQuota() {
        return thisYearRevenueQuota;
    }

    public void setThisYearRevenueQuota(BigDecimal thisYearRevenueQuota) {
        this.thisYearRevenueQuota = thisYearRevenueQuota;
    }

    public Long getLastYearCompletedProjectNumber() {
        return lastYearCompletedProjectNumber;
    }

    public void setLastYearCompletedProjectNumber(Long lastYearCompletedProjectNumber) {
        this.lastYearCompletedProjectNumber = lastYearCompletedProjectNumber;
    }

    public BigDecimal getLastYearCompletedSpace() {
        return lastYearCompletedSpace;
    }

    public void setLastYearCompletedSpace(BigDecimal lastYearCompletedSpace) {
        this.lastYearCompletedSpace = lastYearCompletedSpace;
    }

    public BigDecimal getLastYearProjectConfirmedOutputValue() {
        return lastYearProjectConfirmedOutputValue;
    }

    public void setLastYearProjectConfirmedOutputValue(BigDecimal lastYearProjectConfirmedOutputValue) {
        this.lastYearProjectConfirmedOutputValue = lastYearProjectConfirmedOutputValue;
    }

    public BigDecimal getLastYearProjectCompletedOutputValue() {
        return lastYearProjectCompletedOutputValue;
    }

    public void setLastYearProjectCompletedOutputValue(BigDecimal lastYearProjectCompletedOutputValue) {
        this.lastYearProjectCompletedOutputValue = lastYearProjectCompletedOutputValue;
    }

    public Long getLastYearStartWorkProjectNumber() {
        return lastYearStartWorkProjectNumber;
    }

    public void setLastYearStartWorkProjectNumber(Long lastYearStartWorkProjectNumber) {
        this.lastYearStartWorkProjectNumber = lastYearStartWorkProjectNumber;
    }

    public BigDecimal getLastYearStartWorkSpace() {
        return lastYearStartWorkSpace;
    }

    public void setLastYearStartWorkSpace(BigDecimal lastYearStartWorkSpace) {
        this.lastYearStartWorkSpace = lastYearStartWorkSpace;
    }

    public BigDecimal getLastYearPcOutputValue() {
        return lastYearPcOutputValue;
    }

    public void setLastYearPcOutputValue(BigDecimal lastYearPcOutputValue) {
        this.lastYearPcOutputValue = lastYearPcOutputValue;
    }

    public BigDecimal getLastYearCompleteTotalOutputValue() {
        return lastYearCompleteTotalOutputValue;
    }

    public void setLastYearCompleteTotalOutputValue(BigDecimal lastYearCompleteTotalOutputValue) {
        this.lastYearCompleteTotalOutputValue = lastYearCompleteTotalOutputValue;
    }

    public BigDecimal getThisYearPlanFirstQuarter() {
        return thisYearPlanFirstQuarter;
    }

    public void setThisYearPlanFirstQuarter(BigDecimal thisYearPlanFirstQuarter) {
        this.thisYearPlanFirstQuarter = thisYearPlanFirstQuarter;
    }

    public BigDecimal getThisYearPlanSecondQuarter() {
        return thisYearPlanSecondQuarter;
    }

    public void setThisYearPlanSecondQuarter(BigDecimal thisYearPlanSecondQuarter) {
        this.thisYearPlanSecondQuarter = thisYearPlanSecondQuarter;
    }

    public BigDecimal getThisYearPlanThirdQuarter() {
        return thisYearPlanThirdQuarter;
    }

    public void setThisYearPlanThirdQuarter(BigDecimal thisYearPlanThirdQuarter) {
        this.thisYearPlanThirdQuarter = thisYearPlanThirdQuarter;
    }

    public BigDecimal getThisYearPlanFurthQuarter() {
        return thisYearPlanFurthQuarter;
    }

    public void setThisYearPlanFurthQuarter(BigDecimal thisYearPlanFurthQuarter) {
        this.thisYearPlanFurthQuarter = thisYearPlanFurthQuarter;
    }

    public BigDecimal getThisYearPlanUndertakeOutputValue() {
        return thisYearPlanUndertakeOutputValue;
    }

    public void setThisYearPlanUndertakeOutputValue(BigDecimal thisYearPlanUndertakeOutputValue) {
        this.thisYearPlanUndertakeOutputValue = thisYearPlanUndertakeOutputValue;
    }

    public BigDecimal getThisYearPlanBuildingOutputValue() {
        return thisYearPlanBuildingOutputValue;
    }

    public void setThisYearPlanBuildingOutputValue(BigDecimal thisYearPlanBuildingOutputValue) {
        this.thisYearPlanBuildingOutputValue = thisYearPlanBuildingOutputValue;
    }

    public BigDecimal getThisYearPlanPcOutputValue() {
        return thisYearPlanPcOutputValue;
    }

    public void setThisYearPlanPcOutputValue(BigDecimal thisYearPlanPcOutputValue) {
        this.thisYearPlanPcOutputValue = thisYearPlanPcOutputValue;
    }

    public BigDecimal getThisYearPlanTotalOutputValue() {
        return thisYearPlanTotalOutputValue;
    }

    public void setThisYearPlanTotalOutputValue(BigDecimal thisYearPlanTotalOutputValue) {
        this.thisYearPlanTotalOutputValue = thisYearPlanTotalOutputValue;
    }

    public String getThisYearPlanBusinessIndicatorDescription() {
        return thisYearPlanBusinessIndicatorDescription;
    }

    public void setThisYearPlanBusinessIndicatorDescription(String thisYearPlanBusinessIndicatorDescription) {
        this.thisYearPlanBusinessIndicatorDescription = thisYearPlanBusinessIndicatorDescription;
    }

    public String getThisYearPlanResponsibilityLetter() {
        return thisYearPlanResponsibilityLetter;
    }

    public void setThisYearPlanResponsibilityLetter(String thisYearPlanResponsibilityLetter) {
        this.thisYearPlanResponsibilityLetter = thisYearPlanResponsibilityLetter;
    }

    public BigDecimal getThisYearCompleteTotalOutputValue() {
        return thisYearCompleteTotalOutputValue;
    }

    public void setThisYearCompleteTotalOutputValue(BigDecimal thisYearCompleteTotalOutputValue) {
        this.thisYearCompleteTotalOutputValue = thisYearCompleteTotalOutputValue;
    }

    public BigDecimal getThisYearCompleteProjectOutputValue() {
        return thisYearCompleteProjectOutputValue;
    }

    public void setThisYearCompleteProjectOutputValue(BigDecimal thisYearCompleteProjectOutputValue) {
        this.thisYearCompleteProjectOutputValue = thisYearCompleteProjectOutputValue;
    }

    public BigDecimal getThisYearCompleteProjectConfirmedOutputValue() {
        return thisYearCompleteProjectConfirmedOutputValue;
    }

    public void setThisYearCompleteProjectConfirmedOutputValue(BigDecimal thisYearCompleteProjectConfirmedOutputValue) {
        this.thisYearCompleteProjectConfirmedOutputValue = thisYearCompleteProjectConfirmedOutputValue;
    }

    public Long getThisYearCompleteBuildingProjectNumber() {
        return thisYearCompleteBuildingProjectNumber;
    }

    public void setThisYearCompleteBuildingProjectNumber(Long thisYearCompleteBuildingProjectNumber) {
        this.thisYearCompleteBuildingProjectNumber = thisYearCompleteBuildingProjectNumber;
    }

    public BigDecimal getThisYearCompletePcOutputValue() {
        return thisYearCompletePcOutputValue;
    }

    public void setThisYearCompletePcOutputValue(BigDecimal thisYearCompletePcOutputValue) {
        this.thisYearCompletePcOutputValue = thisYearCompletePcOutputValue;
    }

    public BigDecimal getThisYearCompleteStartWorkSpace() {
        return thisYearCompleteStartWorkSpace;
    }

    public void setThisYearCompleteStartWorkSpace(BigDecimal thisYearCompleteStartWorkSpace) {
        this.thisYearCompleteStartWorkSpace = thisYearCompleteStartWorkSpace;
    }

    public BigDecimal getThisYearCompleteCompletedSpace() {
        return thisYearCompleteCompletedSpace;
    }

    public void setThisYearCompleteCompletedSpace(BigDecimal thisYearCompleteCompletedSpace) {
        this.thisYearCompleteCompletedSpace = thisYearCompleteCompletedSpace;
    }

    public BigDecimal getThisYearCompleteBuildingSpace() {
        return thisYearCompleteBuildingSpace;
    }

    public void setThisYearCompleteBuildingSpace(BigDecimal thisYearCompleteBuildingSpace) {
        this.thisYearCompleteBuildingSpace = thisYearCompleteBuildingSpace;
    }

    public BigDecimal getThisYearCompleteBuildingProjectContractSurplus() {
        return thisYearCompleteBuildingProjectContractSurplus;
    }

    public void setThisYearCompleteBuildingProjectContractSurplus(BigDecimal thisYearCompleteBuildingProjectContractSurplus) {
        this.thisYearCompleteBuildingProjectContractSurplus = thisYearCompleteBuildingProjectContractSurplus;
    }

    public BigDecimal getThisYearCompleteBuildingProjectContractAmount() {
        return thisYearCompleteBuildingProjectContractAmount;
    }

    public void setThisYearCompleteBuildingProjectContractAmount(BigDecimal thisYearCompleteBuildingProjectContractAmount) {
        this.thisYearCompleteBuildingProjectContractAmount = thisYearCompleteBuildingProjectContractAmount;
    }
}
