package com.ejianc.business.outputValue.bean;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目信息补充与维护记录
 *
 * @author generator
 *
 */
 @TableName("ejc_output_value_proect_supplement_record")
public class ProjectSupplementRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="data_id")
    private Long dataId; // 项目补充信息id
    @TableField(value="bill_version")
    private String billVersion; // 单据版本
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id

    @TableField(value="project_num")
    private Integer projectNum; // 项目序号
    @TableField(value="pc_factory")
    private Boolean pcFactory; // 是否PC厂
    @TableField(value="project_status")
    private String projectStatus; // 项目状态
    @TableField(value="graphic_progress")
    private String graphicProgress; // 形象进度
    @TableField(value="project_nature")
    private String projectNature; // 项目性质
    @TableField(value="provisional_amount")
    private BigDecimal provisionalAmount; // 暂列金金额
    @TableField(value="has_construction_permit")
    private Boolean hasConstructionPermit; // 是/否办理施工许可证
    @TableField(value="permit_explain")
    private String permitExplain; // 未办理施工许可证说明

    @TableField(value = "plan_start_date",fill = FieldFill.UPDATE)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date planStartDate; // 计划开工日期
    @TableField(value = "plan_end_date",fill = FieldFill.UPDATE)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date planEndDate; // 计划竣工日期'
    @TableField(value="plan_duration")
    private Integer planDuration; // 计划工期（日历天）
    @TableField(value="contract_nodes")
    private String contractNodes; // 合同过程重大节点
    @TableField(value="establish_project_department")
    private Boolean establishProjectDepartment; // 是/否建立项目经理部
    @TableField(value="project_department_explain")
    private String projectDepartmentExplain; // 未建立项目经理部情况说明
    @TableField(value="management_person_num")
    private Integer managementPersonNum; // 管理人员数量
    @TableField(value="labor_person_num")
    private Integer laborPersonNum; // 劳务人员数量
    @TableField(value="contract_goal")
    private String contractGoal; // 合同创优目标

    @TableField(value = "effect_last_date",fill = FieldFill.UPDATE)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date effectLastDate; // 最后生效日期

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Long getDataId() {
        return dataId;
    }

    public void setDataId(Long dataId) {
        this.dataId = dataId;
    }

    public String getBillVersion() {
        return billVersion;
    }

    public void setBillVersion(String billVersion) {
        this.billVersion = billVersion;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Integer getProjectNum() {
        return projectNum;
    }

    public void setProjectNum(Integer projectNum) {
        this.projectNum = projectNum;
    }

    public Boolean getPcFactory() {
        return pcFactory;
    }

    public void setPcFactory(Boolean pcFactory) {
        this.pcFactory = pcFactory;
    }

    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    public String getGraphicProgress() {
        return graphicProgress;
    }

    public void setGraphicProgress(String graphicProgress) {
        this.graphicProgress = graphicProgress;
    }

    public String getProjectNature() {
        return projectNature;
    }

    public void setProjectNature(String projectNature) {
        this.projectNature = projectNature;
    }

    public BigDecimal getProvisionalAmount() {
        return provisionalAmount;
    }

    public void setProvisionalAmount(BigDecimal provisionalAmount) {
        this.provisionalAmount = provisionalAmount;
    }

    public Boolean getHasConstructionPermit() {
        return hasConstructionPermit;
    }

    public void setHasConstructionPermit(Boolean hasConstructionPermit) {
        this.hasConstructionPermit = hasConstructionPermit;
    }

    public String getPermitExplain() {
        return permitExplain;
    }

    public void setPermitExplain(String permitExplain) {
        this.permitExplain = permitExplain;
    }

    public Date getPlanStartDate() {
        return planStartDate;
    }

    public void setPlanStartDate(Date planStartDate) {
        this.planStartDate = planStartDate;
    }

    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    public Integer getPlanDuration() {
        return planDuration;
    }

    public void setPlanDuration(Integer planDuration) {
        this.planDuration = planDuration;
    }

    public String getContractNodes() {
        return contractNodes;
    }

    public void setContractNodes(String contractNodes) {
        this.contractNodes = contractNodes;
    }

    public Boolean getEstablishProjectDepartment() {
        return establishProjectDepartment;
    }

    public void setEstablishProjectDepartment(Boolean establishProjectDepartment) {
        this.establishProjectDepartment = establishProjectDepartment;
    }

    public String getProjectDepartmentExplain() {
        return projectDepartmentExplain;
    }

    public void setProjectDepartmentExplain(String projectDepartmentExplain) {
        this.projectDepartmentExplain = projectDepartmentExplain;
    }

    public Integer getManagementPersonNum() {
        return managementPersonNum;
    }

    public void setManagementPersonNum(Integer managementPersonNum) {
        this.managementPersonNum = managementPersonNum;
    }

    public Integer getLaborPersonNum() {
        return laborPersonNum;
    }

    public void setLaborPersonNum(Integer laborPersonNum) {
        this.laborPersonNum = laborPersonNum;
    }

    public String getContractGoal() {
        return contractGoal;
    }

    public void setContractGoal(String contractGoal) {
        this.contractGoal = contractGoal;
    }

    public Date getEffectLastDate() {
        return effectLastDate;
    }

    public void setEffectLastDate(Date effectLastDate) {
        this.effectLastDate = effectLastDate;
    }
}
