package com.ejianc.business.outputValue.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaChangeEntity;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaEntity;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaRecordEntity;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaChangeService;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaRecordService;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.vo.CompanyBusinessQuotaChangeVO;
import com.ejianc.business.outputValue.vo.CompanyBusinessQuotaRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 公司经营指标
 *
 */
@RestController
@RequestMapping("/companyBusinessQuotaChange/")
public class CompanyBusinessQuotaChangeController {

    @Autowired
    private ICompanyBusinessQuotaService companyBusinessQuotaService;
    @Autowired
    private ICompanyBusinessQuotaChangeService changeService;
	@Autowired
	private ICompanyBusinessQuotaRecordService recordService;

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CompanyBusinessQuotaChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgShortName");
        fuzzyFields.add("year");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(param.getParams().get("dataId")==null){
        	throw new BusinessException("缺少公司经营指标id");
        }
        IPage<CompanyBusinessQuotaChangeEntity> page = changeService.queryPage(param,false);
        IPage<CompanyBusinessQuotaChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CompanyBusinessQuotaChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByDataId")
    public CommonResponse<CompanyBusinessQuotaChangeVO> queryDetailByDataId(@RequestParam(value = "dataId") Long dataId) {
        CompanyBusinessQuotaEntity entity = companyBusinessQuotaService.selectById(dataId);
        CompanyBusinessQuotaChangeVO changeVO = BeanMapper.map(entity, CompanyBusinessQuotaChangeVO.class);
        changeVO.setDataId(dataId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(null);
        changeVO.setUpdateUserCode(null);
        return CommonResponse.success("查询详情成功！", changeVO);
    	
    }
    
    /**
     * 查询变更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetail")
    public CommonResponse<CompanyBusinessQuotaChangeVO> queryDetail(@RequestParam(value = "id") Long id) {
        CompanyBusinessQuotaChangeEntity entity = changeService.selectById(id);
        CompanyBusinessQuotaChangeVO vo = BeanMapper.map(entity, CompanyBusinessQuotaChangeVO.class);

        //当前单据变更过则显示变更记录
        QueryWrapper<CompanyBusinessQuotaRecordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("data_id", vo.getDataId());
        List<CompanyBusinessQuotaRecordEntity> records = recordService.list(queryWrapper);
        if(records!=null&&records.size()>0){
            vo.setRecordList(BeanMapper.mapList(records, CompanyBusinessQuotaRecordVO.class));
        }
        return CommonResponse.success("查询详情成功！", vo);
    	
    }

    /**
     * 项目申请保存/更新
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "saveChange")
    public CommonResponse<CompanyBusinessQuotaChangeVO> saveChange(@RequestBody CompanyBusinessQuotaChangeVO vo) {
    	return changeService.saveChange(vo);
    	
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CompanyBusinessQuotaChangeVO> vos) {
        return changeService.delete(vos);
    }

}
