package com.ejianc.business.outputValue.controller;

import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaRecordEntity;
import com.ejianc.business.outputValue.service.ICompanyUndertakeQuotaRecordService;
import com.ejianc.business.outputValue.vo.CompanyUndertakeQuotaRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * 公司新承接项目指标
 *
 */
@RestController
@RequestMapping("/companyUndertakeQuotaRecord/")
public class CompanyUndertakeQuotaRecordController {

	@Autowired
	private ICompanyUndertakeQuotaRecordService recordService;
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CompanyUndertakeQuotaRecordVO> queryDetail(Long id) {
        CompanyUndertakeQuotaRecordEntity entity = recordService.selectById(id);
        CompanyUndertakeQuotaRecordVO vo = BeanMapper.map(entity, CompanyUndertakeQuotaRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
