package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementEntity;
import com.ejianc.business.outputValue.mapper.CompanyBusinessQuotaMapper;
import com.ejianc.business.outputValue.mapper.PcMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.mapper.ProjectMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.mapper.ProjectSupplementMapper;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.service.IProjectSupplementService;
import com.ejianc.business.outputValue.vo.CompanyBusinessQuotaVO;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueVO;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.business.outputValue.vo.ProjectSupplementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 公司经营指标 （产值）
 * 
 * @author generator
 * 
 */
@Service("companyBusinessQuotaService")
public class CompanyBusinessQuotaServiceImpl extends BaseServiceImpl<CompanyBusinessQuotaMapper, CompanyBusinessQuotaEntity> implements ICompanyBusinessQuotaService {

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectSupplementService projectSupplementService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ProjectSupplementMapper projectSupplementMapper;
    @Autowired
    private PcMonthActualOutputValueMapper pcMonthActualOutputValueMapper;
    @Autowired
    private ProjectMonthActualOutputValueMapper projectMonthActualOutputValueMapper;

    @Override
    public CompanyBusinessQuotaVO queryInfoByProjectId(Long orgId, String year) {

        CompanyBusinessQuotaVO vo = new CompanyBusinessQuotaVO();
        QueryWrapper<CompanyBusinessQuotaEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("org_id", orgId);
        //上一年
        LocalDateTime currentTime = LocalDateTime.parse(year);
        LocalDateTime last = currentTime.minusYears(1);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");
        String lastYear = last.format(formatter);
        wrapper.eq("year", year);
        wrapper.orderByDesc("create_time");
        List<CompanyBusinessQuotaEntity> list = this.list(wrapper);
        if(list!=null && list.size()>0){
            CompanyBusinessQuotaEntity lastEntity = list.get(0);
//            private Long lastYearCompletedProjectNumber; // 上年竣工项目数（个）
            QueryWrapper<ProjectSupplementEntity> projectWrapper = new QueryWrapper<>();
            projectWrapper.like("effect_last_date", lastYear);
            projectWrapper.in("bill_state", 1,3);
            projectWrapper.in("project_status", 5,6);//竣工的
            Integer lastYearStartWorkProjectNumber = projectSupplementService.count(projectWrapper);
            vo.setLastYearStartWorkProjectNumber(Long.parseLong(lastYearStartWorkProjectNumber.toString())); // 上年开工项目数（个）

            QueryWrapper<ProjectSupplementEntity> projectWrapper2 = new QueryWrapper<>();
            projectWrapper2.like("effect_last_date", lastYear);
            projectWrapper2.in("bill_state", 1,3);
            projectWrapper2.in("project_status", "2");//在施
            Integer thisYearCompleteBuildingProjectNumber = projectSupplementService.count(projectWrapper2);
            vo.setThisYearCompleteBuildingProjectNumber(Long.parseLong(thisYearCompleteBuildingProjectNumber.toString())); // 在施项目数（个）

            vo.setLastYearCompletedSpace(lastEntity.getThisYearCompleteCompletedSpace());// 上年竣工面积（万平米）
            vo.setLastYearProjectConfirmedOutputValue(lastEntity.getThisYearCompleteProjectConfirmedOutputValue()); // 上年项目确认产值(亿元)
            vo.setLastYearProjectCompletedOutputValue(lastEntity.getThisYearCompleteProjectOutputValue()); // 上年项目完成产值(亿元)
            vo.setLastYearStartWorkSpace(lastEntity.getThisYearCompleteStartWorkSpace()); // 上年开工面积（万平米）
            vo.setLastYearPcOutputValue(lastEntity.getThisYearCompletePcOutputValue()); // 上年PC工厂产值(亿元)
            vo.setLastYearCompleteTotalOutputValue(lastEntity.getThisYearCompleteTotalOutputValue()); // 上年完成总产值(亿元)
        }

        Map<String,Object> param = new HashMap<>();
        param.put("twoOrgId", orgId);
        param.put("year", year);
        ProjectMonthActualOutputValueVO projectData = projectMonthActualOutputValueMapper.selectSumData(param);
        if(projectData!=null && projectData.getThisMonthActualOutputValue()!=null){
            // 本月实际完成产值       万元--->亿元
            vo.setThisYearCompleteProjectOutputValue(CommonUtils.parseDivide4(projectData.getThisMonthActualOutputValue(), 3));
            // 本月确认产值       万元--->亿元
            vo.setThisYearCompleteProjectConfirmedOutputValue(CommonUtils.parseDivide4(projectData.getThisMonthConfirmedOutputValue(), 3));
        }else{
            vo.setThisYearCompletePcOutputValue(new BigDecimal(0));
        }
        PcMonthActualOutputValueVO pcData = pcMonthActualOutputValueMapper.selectSumData(param);
        if(pcData!=null && pcData.getThisMonthCompletedTotalOutputValue()!=null){
            //万元--->亿元
            vo.setThisYearCompletePcOutputValue(CommonUtils.parseDivide4(pcData.getThisMonthCompletedTotalOutputValue(), 3));
        }else{
            vo.setThisYearCompletePcOutputValue(new BigDecimal(0));
        }
        // 本年完成产值-总完成产值(亿元)
        vo.setThisYearCompleteTotalOutputValue(CommonUtils.addBigDecimal(vo.getThisYearCompleteProjectOutputValue(),vo.getThisYearCompletePcOutputValue()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        //获取项目档案中的基本信息
        ProjectSupplementVO building = projectSupplementMapper.selectSumData(commonOrgIds, lastYear, "2");//在施
        if(building!=null){
            vo.setThisYearCompleteStartWorkSpace(CommonUtils.parseDivide4(building.getBuiltAllArea(),3)); // 本年完成产值-开工面积(万平米)
            vo.setThisYearCompleteBuildingSpace(CommonUtils.parseDivide4(building.getBuiltAllArea(),3)); // 本年完成产值-施工面积（万平方米）
            vo.setThisYearCompleteBuildingProjectContractSurplus(CommonUtils.parseDivide8(building.getContractAmount(),4)); // 本年完成产值-在施项目合同余量(亿元)
            vo.setThisYearCompleteBuildingProjectContractAmount(CommonUtils.parseDivide8(building.getContractAmount(),4)); // 本年完成产值-在施项目合同额(亿元)
        }else{
            vo.setThisYearCompleteStartWorkSpace(new BigDecimal(0)); // 本年完成产值-开工面积(万平米)
            vo.setThisYearCompleteBuildingSpace(new BigDecimal(0)); // 本年完成产值-施工面积（万平方米）
            vo.setThisYearCompleteBuildingProjectContractSurplus(new BigDecimal(0)); // 本年完成产值-在施项目合同余量(亿元)
            vo.setThisYearCompleteBuildingProjectContractAmount(new BigDecimal(0)); // 本年完成产值-在施项目合同额(亿元)
        }
        ProjectSupplementVO finish = projectSupplementMapper.selectSumData(commonOrgIds, lastYear, "5,6");//在施
        if(finish!=null){
            vo.setThisYearCompleteCompletedSpace(CommonUtils.parseDivide4(finish.getBuiltAllArea(),3)); // 本年完成产值-竣工面积(万平米)
        }else{
            vo.setThisYearCompleteCompletedSpace(new BigDecimal(0)); // 本年完成产值-开工面积(万平米)
        }
        return vo;
    }
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @Override
    public void updateProjectPcInfo(Long orgId, String year){
        //更新公司经营指标---先判断该组织是否存在单据，存在则修改
        QueryWrapper<CompanyBusinessQuotaEntity> companyWrapper = new QueryWrapper<>();
        companyWrapper.eq("org_id", orgId);
        companyWrapper.eq("year", year);
        companyWrapper.in("bill_state", 1,3);
        List<CompanyBusinessQuotaEntity> companyList = this.list(companyWrapper);
        if(companyList!=null && companyList.size()>0){
            CompanyBusinessQuotaEntity companyEntity = companyList.get(0);
            Map<String,Object> param = new HashMap<>();
            param.put("twoOrgId", orgId);
            param.put("year", year);
            ProjectMonthActualOutputValueVO sumData = projectMonthActualOutputValueMapper.selectSumData(param);

            // 本月实际完成产值       万元--->亿元
            companyEntity.setThisYearCompleteProjectOutputValue(CommonUtils.parseDivide4(sumData.getThisMonthActualOutputValue(), 3));
            // 本月确认产值       万元--->亿元
            companyEntity.setThisYearCompleteProjectConfirmedOutputValue(CommonUtils.parseDivide4(sumData.getThisMonthConfirmedOutputValue(), 3));

            PcMonthActualOutputValueVO pcData = pcMonthActualOutputValueMapper.selectSumData(param);
            companyEntity.setThisYearCompletePcOutputValue(CommonUtils.parseDivide4(pcData.getThisMonthCompletedTotalOutputValue(), 3));

            // 本年完成产值-总完成产值(亿元)
            companyEntity.setThisYearCompleteTotalOutputValue(CommonUtils.addBigDecimal(companyEntity.getThisYearCompleteProjectOutputValue(),companyEntity.getThisYearCompletePcOutputValue()));
            this.saveOrUpdate(companyEntity, false);
        }
    }
}
