package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaChangeEntity;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaEntity;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaRecordEntity;
import com.ejianc.business.outputValue.service.ICompanyUndertakeQuotaChangeService;
import com.ejianc.business.outputValue.service.ICompanyUndertakeQuotaRecordService;
import com.ejianc.business.outputValue.service.ICompanyUndertakeQuotaService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("companyUndertakeQuotaChange")
public class CompanyUndertakeQuotaChangeBpmServiceImpl implements ICommonBusinessService {
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String COMPANYUNDERTAKEQUOTA_SOURCETYPE = "companyUndertakeQuota";//
    private static final String COMPANYUNDERTAKEQUOTA_CHANGE_SOURCETYPE = "companyUndertakeQuotaChange";//变更
    private static final String COMPANYUNDERTAKEQUOTA_RECORD_SOURCETYPE = "companyUndertakeQuotaRecord";//记录

    private static final String COMPANYUNDERTAKEQUOTA_BILLTYPE_CODE = "EJCBT202411000002";
    private static final String COMPANYUNDERTAKEQUOTA_CHANGE_BILLTYPE_CODE = "EJCBT202411000017";
    private static final String COMPANYUNDERTAKEQUOTA_RECORD_BILLTYPE_CODE = "EJCBT202411000018";

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ICompanyUndertakeQuotaService companyUndertakeQuotaService;
	@Autowired
	private ICompanyUndertakeQuotaChangeService changeService;

    @Autowired
    private ICompanyUndertakeQuotaRecordService recordService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}
	
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前合同信息、变更信息
		CompanyUndertakeQuotaChangeEntity changeEntity = changeService.selectById(billId);
		CompanyUndertakeQuotaEntity companyUndertakeQuotaEntity = companyUndertakeQuotaService.selectById(changeEntity.getDataId());

		//获取历史版本条数
		QueryWrapper<CompanyUndertakeQuotaRecordEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("data_id", companyUndertakeQuotaEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordService.count(recordWrapper);
		//2、生成历史版本
		//2.1、
		CompanyUndertakeQuotaRecordEntity recordEntity = BeanMapper.map(companyUndertakeQuotaEntity, CompanyUndertakeQuotaRecordEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordEntity);
		recordEntity.setBillState(null);
		recordEntity.setDataId(companyUndertakeQuotaEntity.getId());
		recordEntity.setBillVersion(String.valueOf(count+1));
		recordEntity.setId(recordId);
		recordEntity.setChangeReason(changeEntity.getChangeReason());

		//复制合同附件信息到记录中
		String sourceBillType = COMPANYUNDERTAKEQUOTA_BILLTYPE_CODE;
		String targetBillType = COMPANYUNDERTAKEQUOTA_RECORD_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(companyUndertakeQuotaEntity.getId().toString(), sourceBillType, COMPANYUNDERTAKEQUOTA_SOURCETYPE, recordId.toString(), targetBillType, COMPANYUNDERTAKEQUOTA_RECORD_SOURCETYPE);
		recordService.saveOrUpdate(recordEntity, false);
		logger.info("---------生成合同信息完成--------");
		//3、修改当前合同信息
		CompanyUndertakeQuotaEntity newContractEntity = BeanMapper.map(changeEntity, CompanyUndertakeQuotaEntity.class);
		newContractEntity.setChangeState("3");//状态改为已变更
		newContractEntity.setChangeId(null);
		newContractEntity.setBillCode(companyUndertakeQuotaEntity.getBillCode());
		newContractEntity.setBillState(companyUndertakeQuotaEntity.getBillState());
		newContractEntity.setId(companyUndertakeQuotaEntity.getId());
		newContractEntity.setCreateTime(companyUndertakeQuotaEntity.getCreateTime());
		newContractEntity.setCreateUserCode(companyUndertakeQuotaEntity.getCreateUserCode());
		newContractEntity.setTenantId(companyUndertakeQuotaEntity.getTenantId());
		newContractEntity.setVersion(companyUndertakeQuotaEntity.getVersion());
		companyUndertakeQuotaService.saveOrUpdate(newContractEntity, false);
		//复制合同附件信息到记录中
		sourceBillType = COMPANYUNDERTAKEQUOTA_CHANGE_BILLTYPE_CODE;
		targetBillType = COMPANYUNDERTAKEQUOTA_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, COMPANYUNDERTAKEQUOTA_CHANGE_SOURCETYPE, companyUndertakeQuotaEntity.getId().toString(), targetBillType, COMPANYUNDERTAKEQUOTA_SOURCETYPE);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单不允许弃审");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
