package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueChangeEntity;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueRecordEntity;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueChangeService;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueRecordService;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("pcMonthActualOutputValueChange")
public class PcMonthActualOutputValueChangeBpmServiceImpl implements ICommonBusinessService {
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PCMONTHACTUALOUTPUTVALUE_SOURCETYPE = "pcMonthActualOutputValue";//
    private static final String PCMONTHACTUALOUTPUTVALUE_CHANGE_SOURCETYPE = "pcMonthActualOutputValueChange";//变更
    private static final String PCMONTHACTUALOUTPUTVALUE_RECORD_SOURCETYPE = "pcMonthActualOutputValueRecord";//记录

    private static final String PCMONTHACTUALOUTPUTVALUE_BILLTYPE_CODE = "EJCBT202411000006";
    private static final String PCMONTHACTUALOUTPUTVALUE_CHANGE_BILLTYPE_CODE = "EJCBT202411000015";
    private static final String PCMONTHACTUALOUTPUTVALUE_RECORD_BILLTYPE_CODE = "EJCBT202411000016";

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPcMonthActualOutputValueService pcMonthActualOutputValueService;
	@Autowired
	private IPcMonthActualOutputValueChangeService changeService;
	@Autowired
	private ICompanyBusinessQuotaService companyBusinessQuotaService;

    @Autowired
    private IPcMonthActualOutputValueRecordService recordService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}
	
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前合同信息、变更信息
		PcMonthActualOutputValueChangeEntity changeEntity = changeService.selectById(billId);
		PcMonthActualOutputValueEntity pcMonthActualOutputValueEntity = pcMonthActualOutputValueService.selectById(changeEntity.getDataId());

		//获取历史版本条数
		QueryWrapper<PcMonthActualOutputValueRecordEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("data_id", pcMonthActualOutputValueEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordService.count(recordWrapper);
		//2、生成历史版本
		//2.1、
		PcMonthActualOutputValueRecordEntity recordEntity = BeanMapper.map(pcMonthActualOutputValueEntity, PcMonthActualOutputValueRecordEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordEntity);
		recordEntity.setBillState(null);
		recordEntity.setDataId(pcMonthActualOutputValueEntity.getId());
		recordEntity.setBillVersion(String.valueOf(count+1));
		recordEntity.setId(recordId);
		recordEntity.setChangeReason(changeEntity.getChangeReason());

		//复制合同附件信息到记录中
		String sourceBillType = PCMONTHACTUALOUTPUTVALUE_BILLTYPE_CODE;
		String targetBillType = PCMONTHACTUALOUTPUTVALUE_RECORD_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(pcMonthActualOutputValueEntity.getId().toString(), sourceBillType, PCMONTHACTUALOUTPUTVALUE_SOURCETYPE, recordId.toString(), targetBillType, PCMONTHACTUALOUTPUTVALUE_RECORD_SOURCETYPE);
		recordService.saveOrUpdate(recordEntity, false);
		logger.info("---------生成合同信息完成--------");
		//3、修改当前合同信息
		PcMonthActualOutputValueEntity newContractEntity = BeanMapper.map(changeEntity, PcMonthActualOutputValueEntity.class);
		newContractEntity.setChangeState("3");//状态改为已变更
		newContractEntity.setChangeId(null);
		newContractEntity.setBillCode(pcMonthActualOutputValueEntity.getBillCode());
		newContractEntity.setBillState(pcMonthActualOutputValueEntity.getBillState());
		newContractEntity.setId(pcMonthActualOutputValueEntity.getId());
		newContractEntity.setCreateTime(pcMonthActualOutputValueEntity.getCreateTime());
		newContractEntity.setCreateUserCode(pcMonthActualOutputValueEntity.getCreateUserCode());
		newContractEntity.setTenantId(pcMonthActualOutputValueEntity.getTenantId());
		newContractEntity.setVersion(pcMonthActualOutputValueEntity.getVersion());
		pcMonthActualOutputValueService.saveOrUpdate(newContractEntity, false);
		//复制合同附件信息到记录中
		sourceBillType = PCMONTHACTUALOUTPUTVALUE_CHANGE_BILLTYPE_CODE;
		targetBillType = PCMONTHACTUALOUTPUTVALUE_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, PCMONTHACTUALOUTPUTVALUE_CHANGE_SOURCETYPE, pcMonthActualOutputValueEntity.getId().toString(), targetBillType, PCMONTHACTUALOUTPUTVALUE_SOURCETYPE);

		//更新公司经营指标---先判断该组织是否存在单据，存在则修改
		companyBusinessQuotaService.updateProjectPcInfo(changeEntity.getTwoOrgId(), changeEntity.getYear());
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单不允许弃审");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
