package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueChangeEntity;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueRecordEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementEntity;
import com.ejianc.business.outputValue.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("projectMonthActualOutputValueChange")
public class ProjectMonthActualOutputValueChangeBpmServiceImpl implements ICommonBusinessService {
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PROJECTMONTHACTUALOUTPUTVALUE_SOURCETYPE = "projectMonthActualOutputValue";//合同
    private static final String PROJECTMONTHACTUALOUTPUTVALUE_CHANGE_SOURCETYPE = "projectMonthActualOutputValueChange";//变更
    private static final String PROJECTMONTHACTUALOUTPUTVALUE_RECORD_SOURCETYPE = "projectMonthActualOutputValueRecord";//记录

    private static final String PROJECTMONTHACTUALOUTPUTVALUE_BILLTYPE_CODE = "EJCBT202411000005";
    private static final String PROJECTMONTHACTUALOUTPUTVALUE_CHANGE_BILLTYPE_CODE = "EJCBT202411000013";
    private static final String PROJECTMONTHACTUALOUTPUTVALUE_RECORD_BILLTYPE_CODE = "EJCBT202411000014";

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProjectMonthActualOutputValueService projectMonthActualOutputValueService;
	@Autowired
	private IProjectMonthActualOutputValueChangeService changeService;
	@Autowired
	private ICompanyBusinessQuotaService companyBusinessQuotaService;
	@Autowired
	private IProjectSupplementService projectSupplementService;
	@Autowired
	private IZjkjProjectApi projectApi;

    @Autowired
    private IProjectMonthActualOutputValueRecordService recordService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}
	
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前合同信息、变更信息
		ProjectMonthActualOutputValueChangeEntity changeEntity = changeService.selectById(billId);
		ProjectMonthActualOutputValueEntity projectMonthActualOutputValueEntity = projectMonthActualOutputValueService.selectById(changeEntity.getDataId());

		//获取历史版本条数
		QueryWrapper<ProjectMonthActualOutputValueRecordEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("data_id", projectMonthActualOutputValueEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordService.count(recordWrapper);
		//2、生成历史版本
		//2.1、
		ProjectMonthActualOutputValueRecordEntity recordEntity = BeanMapper.map(projectMonthActualOutputValueEntity, ProjectMonthActualOutputValueRecordEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordEntity);
		recordEntity.setBillState(null);
		recordEntity.setDataId(projectMonthActualOutputValueEntity.getId());
		recordEntity.setBillVersion(String.valueOf(count+1));
		recordEntity.setId(recordId);
		recordEntity.setChangeReason(changeEntity.getChangeReason());

		//复制合同附件信息到记录中
		String sourceBillType = PROJECTMONTHACTUALOUTPUTVALUE_BILLTYPE_CODE;
		String targetBillType = PROJECTMONTHACTUALOUTPUTVALUE_RECORD_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(projectMonthActualOutputValueEntity.getId().toString(), sourceBillType, PROJECTMONTHACTUALOUTPUTVALUE_SOURCETYPE, recordId.toString(), targetBillType, PROJECTMONTHACTUALOUTPUTVALUE_RECORD_SOURCETYPE);
		recordService.saveOrUpdate(recordEntity, false);
		logger.info("---------生成合同信息完成--------");
		//3、修改当前合同信息
		ProjectMonthActualOutputValueEntity newContractEntity = BeanMapper.map(changeEntity, ProjectMonthActualOutputValueEntity.class);
		newContractEntity.setChangeState("3");//状态改为已变更
		newContractEntity.setChangeId(null);
		newContractEntity.setBillCode(projectMonthActualOutputValueEntity.getBillCode());
		newContractEntity.setBillState(projectMonthActualOutputValueEntity.getBillState());
		newContractEntity.setId(projectMonthActualOutputValueEntity.getId());
		newContractEntity.setCreateTime(projectMonthActualOutputValueEntity.getCreateTime());
		newContractEntity.setCreateUserCode(projectMonthActualOutputValueEntity.getCreateUserCode());
		newContractEntity.setTenantId(projectMonthActualOutputValueEntity.getTenantId());
		newContractEntity.setVersion(projectMonthActualOutputValueEntity.getVersion());
		projectMonthActualOutputValueService.saveOrUpdate(newContractEntity, false);
		//复制合同附件信息到记录中
		sourceBillType = PROJECTMONTHACTUALOUTPUTVALUE_CHANGE_BILLTYPE_CODE;
		targetBillType = PROJECTMONTHACTUALOUTPUTVALUE_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, PROJECTMONTHACTUALOUTPUTVALUE_CHANGE_SOURCETYPE, projectMonthActualOutputValueEntity.getId().toString(), targetBillType, PROJECTMONTHACTUALOUTPUTVALUE_SOURCETYPE);

		//更新公司经营指标---先判断该组织是否存在单据，存在则修改
		companyBusinessQuotaService.updateProjectPcInfo(changeEntity.getTwoOrgId(), changeEntity.getYear());

		ProjectSupplementEntity projectSupplement = projectSupplementService.selectById(changeEntity.getProjectId());
		if(!changeEntity.getProjectImageProgress().equals(projectSupplement.getGraphicProgress())){
			projectSupplement.setGraphicProgress(changeEntity.getProjectImageProgress());
			projectSupplementService.saveOrUpdate(projectSupplement, false);
			CommonResponse<ProjectVO> projectResponse = projectApi.queryDetailById(changeEntity.getProjectId());
			if(projectResponse.isSuccess()&&projectResponse.getData()!=null){
				ProjectVO projectVO = projectResponse.getData();
				projectVO.setGraphicProgress(projectSupplement.getGraphicProgress()); // 形象进度
				CommonResponse<ProjectVO> saveback = projectApi.saveProject(projectVO);
				if(!saveback.isSuccess()){
					logger.info("反写项目信息失败----------------->"+saveback.getMsg());
				}
			}else{
				return CommonResponse.error("未查询到项目信息");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单不允许弃审");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
