package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaChangeEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaRecordEntity;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaChangeService;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaRecordService;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("projectPcYearBusinessQuotaChange")
public class ProjectPcYearBusinessQuotaChangeBpmServiceImpl implements ICommonBusinessService {
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PROJECTPCYEARBUSINESSQUOTA_SOURCETYPE = "projectPcYearBusinessQuota";//合同
    private static final String PROJECTPCYEARBUSINESSQUOTA_CHANGE_SOURCETYPE = "projectPcYearBusinessQuotaChange";//变更
    private static final String PROJECTPCYEARBUSINESSQUOTA_RECORD_SOURCETYPE = "projectPcYearBusinessQuotaRecord";//记录

    private static final String PROJECTPCYEARBUSINESSQUOTA_BILLTYPE_CODE = "EJCBT202411000004";
    private static final String PROJECTPCYEARBUSINESSQUOTA_CHANGE_BILLTYPE_CODE = "EJCBT202411000011";
    private static final String PROJECTPCYEARBUSINESSQUOTA_RECORD_BILLTYPE_CODE = "EJCBT202411000012";

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProjectPcYearBusinessQuotaService projectPcYearBusinessQuotaService;
	@Autowired
	private IProjectPcYearBusinessQuotaChangeService changeService;

    @Autowired
    private IProjectPcYearBusinessQuotaRecordService recordService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}
	
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前合同信息、变更信息
		ProjectPcYearBusinessQuotaChangeEntity changeEntity = changeService.selectById(billId);
		ProjectPcYearBusinessQuotaEntity projectPcYearBusinessQuotaEntity = projectPcYearBusinessQuotaService.selectById(changeEntity.getDataId());

		//获取历史版本条数
		QueryWrapper<ProjectPcYearBusinessQuotaRecordEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("data_id", projectPcYearBusinessQuotaEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordService.count(recordWrapper);
		//2、生成历史版本
		//2.1、
		ProjectPcYearBusinessQuotaRecordEntity recordEntity = BeanMapper.map(projectPcYearBusinessQuotaEntity, ProjectPcYearBusinessQuotaRecordEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordEntity);
		recordEntity.setBillState(null);
		recordEntity.setDataId(projectPcYearBusinessQuotaEntity.getId());
		recordEntity.setBillVersion(String.valueOf(count+1));
		recordEntity.setId(recordId);
		recordEntity.setChangeReason(changeEntity.getChangeReason());

		//复制合同附件信息到记录中
		String sourceBillType = PROJECTPCYEARBUSINESSQUOTA_BILLTYPE_CODE;
		String targetBillType = PROJECTPCYEARBUSINESSQUOTA_RECORD_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(projectPcYearBusinessQuotaEntity.getId().toString(), sourceBillType, PROJECTPCYEARBUSINESSQUOTA_SOURCETYPE, recordId.toString(), targetBillType, PROJECTPCYEARBUSINESSQUOTA_RECORD_SOURCETYPE);
		recordService.saveOrUpdate(recordEntity, false);
		logger.info("---------生成合同信息完成--------");
		//3、修改当前合同信息
		ProjectPcYearBusinessQuotaEntity newContractEntity = BeanMapper.map(changeEntity, ProjectPcYearBusinessQuotaEntity.class);
		newContractEntity.setChangeState("3");//状态改为已变更
		newContractEntity.setChangeId(null);
		newContractEntity.setBillCode(projectPcYearBusinessQuotaEntity.getBillCode());
		newContractEntity.setBillState(projectPcYearBusinessQuotaEntity.getBillState());
		newContractEntity.setId(projectPcYearBusinessQuotaEntity.getId());
		newContractEntity.setCreateTime(projectPcYearBusinessQuotaEntity.getCreateTime());
		newContractEntity.setCreateUserCode(projectPcYearBusinessQuotaEntity.getCreateUserCode());
		newContractEntity.setTenantId(projectPcYearBusinessQuotaEntity.getTenantId());
		newContractEntity.setVersion(projectPcYearBusinessQuotaEntity.getVersion());
		projectPcYearBusinessQuotaService.saveOrUpdate(newContractEntity, false);
		//复制合同附件信息到记录中
		sourceBillType = PROJECTPCYEARBUSINESSQUOTA_CHANGE_BILLTYPE_CODE;
		targetBillType = PROJECTPCYEARBUSINESSQUOTA_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, PROJECTPCYEARBUSINESSQUOTA_CHANGE_SOURCETYPE, projectPcYearBusinessQuotaEntity.getId().toString(), targetBillType, PROJECTPCYEARBUSINESSQUOTA_SOURCETYPE);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单不允许弃审");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
