package com.ejianc.business.outputValue.service.impl;

import com.ejianc.business.outputValue.bean.ProjectSupplementEntity;
import com.ejianc.business.outputValue.service.IProjectSupplementService;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("projectSupplement")
public class ProjectSupplementBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProjectSupplementService projectSupplementService;
	@Autowired
	private IZjkjProjectApi projectApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ProjectSupplementEntity projectSupplement = projectSupplementService.selectById(billId);
		projectSupplement.setChangeState("1");//未变更
		projectSupplement.setChangeId(null);
		projectSupplementService.saveOrUpdate(projectSupplement, false);
		CommonResponse<ProjectVO> projectResponse = projectApi.queryDetailById(projectSupplement.getProjectId());
		if(projectResponse.isSuccess()&&projectResponse.getData()!=null){
			ProjectVO projectVO = projectResponse.getData();
			projectVO.setProjectNum(projectSupplement.getProjectNum());// 项目序号
			projectVO.setPcFactory(projectSupplement.getPcFactory()); // 是否PC厂
			projectVO.setProjectStatus(projectSupplement.getProjectStatus()); // 项目状态
			projectVO.setGraphicProgress(projectSupplement.getGraphicProgress()); // 形象进度
			projectVO.setProjectNature(projectSupplement.getProjectNature()); // 项目性质
			projectVO.setProvisionalAmount(projectSupplement.getProvisionalAmount()); // 暂列金金额
			projectVO.setHasConstructionPermit(projectSupplement.getHasConstructionPermit()); // 是/否办理施工许可证
			projectVO.setPermitExplain(projectSupplement.getPermitExplain()); // 未办理施工许可证说明
			projectVO.setPlanStartDate(projectSupplement.getPlanStartDate());
			projectVO.setPlanEndDate(projectSupplement.getPlanEndDate());
			projectVO.setPlanDuration(projectSupplement.getPlanDuration());
			projectVO.setContractNodes(projectSupplement.getContractNodes()); // 合同过程重大节点
			projectVO.setEstablishProjectDepartment(projectSupplement.getEstablishProjectDepartment()); // 是/否建立项目经理部
			projectVO.setProjectDepartmentExplain(projectSupplement.getProjectDepartmentExplain()); // 未建立项目经理部情况说明
			projectVO.setManagementPersonNum(projectSupplement.getManagementPersonNum()); // 管理人员数量
			projectVO.setLaborPersonNum(projectSupplement.getLaborPersonNum()); // 劳务人员数量
			projectVO.setContractGoal(projectSupplement.getContractGoal()); // 合同创优目标
			CommonResponse<ProjectVO> saveback = projectApi.saveProject(projectVO);
			if(!saveback.isSuccess()){
				logger.info("反写项目信息失败----------------->"+saveback.getMsg());
			}
		}else{
			return CommonResponse.error("未查询到项目信息");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
