package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.*;
import com.ejianc.business.outputValue.service.IProjectSupplementChangeService;
import com.ejianc.business.outputValue.service.IProjectSupplementRecordService;
import com.ejianc.business.outputValue.service.IProjectSupplementService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("projectSupplementChange")
public class ProjectSupplementChangeBpmServiceImpl implements ICommonBusinessService {
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PROJECTSUPPLEMENT_SOURCETYPE = "incontract";//合同
    private static final String PROJECTSUPPLEMENT_CHANGE_SOURCETYPE = "incontractChange";//合同变更
    private static final String PROJECTSUPPLEMENT_RECORD_SOURCETYPE = "incontractRecord";//合同记录

    private static final String PROJECTSUPPLEMENT_BILLTYPE_CODE = "EJCBT202411000001";
    private static final String PROJECTSUPPLEMENT_CHANGE_BILLTYPE_CODE = "EJCBT202411000007";
    private static final String PROJECTSUPPLEMENT_RECORD_BILLTYPE_CODE = "EJCBT202411000008";

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProjectSupplementService projectSupplementService;
	@Autowired
	private IProjectSupplementChangeService changeService;

    @Autowired
    private IProjectSupplementRecordService recordService;

    @Autowired
    private IZjkjProjectApi zjkjProjectApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}
	
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前合同信息、变更信息
		ProjectSupplementChangeEntity changeEntity = changeService.selectById(billId);
		ProjectSupplementEntity projectSupplementEntity = projectSupplementService.selectById(changeEntity.getDataId());

		//获取历史版本条数
		QueryWrapper<ProjectSupplementRecordEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("data_id", projectSupplementEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordService.count(recordWrapper);
		//2、生成历史版本
		//2.1、
		ProjectSupplementRecordEntity recordEntity = BeanMapper.map(projectSupplementEntity, ProjectSupplementRecordEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordEntity);
		recordEntity.setBillState(null);
		recordEntity.setDataId(projectSupplementEntity.getId());
		recordEntity.setBillVersion(String.valueOf(count+1));
		recordEntity.setId(recordId);
		recordEntity.setChangeReason(changeEntity.getChangeReason());

		//复制合同附件信息到记录中
		String sourceBillType = PROJECTSUPPLEMENT_BILLTYPE_CODE;
		String targetBillType = PROJECTSUPPLEMENT_RECORD_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(projectSupplementEntity.getId().toString(), sourceBillType, PROJECTSUPPLEMENT_SOURCETYPE, recordId.toString(), targetBillType, PROJECTSUPPLEMENT_RECORD_SOURCETYPE);
		recordService.saveOrUpdate(recordEntity, false);
		logger.info("---------生成合同信息完成--------");
		//3、修改当前合同信息
		ProjectSupplementEntity newContractEntity = BeanMapper.map(changeEntity, ProjectSupplementEntity.class);
		newContractEntity.setChangeState("3");//状态改为已变更
		newContractEntity.setChangeId(null);
		newContractEntity.setBillState(projectSupplementEntity.getBillState());
		newContractEntity.setId(projectSupplementEntity.getId());
		newContractEntity.setCreateTime(projectSupplementEntity.getCreateTime());
		newContractEntity.setCreateUserCode(projectSupplementEntity.getCreateUserCode());
		newContractEntity.setTenantId(projectSupplementEntity.getTenantId());
		newContractEntity.setVersion(projectSupplementEntity.getVersion());
		projectSupplementService.saveOrUpdate(newContractEntity, false);
		//复制合同附件信息到记录中
		sourceBillType = PROJECTSUPPLEMENT_CHANGE_BILLTYPE_CODE;
		targetBillType = PROJECTSUPPLEMENT_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, PROJECTSUPPLEMENT_CHANGE_SOURCETYPE, projectSupplementEntity.getId().toString(), targetBillType, PROJECTSUPPLEMENT_SOURCETYPE);
		
		logger.info("---------修改合同信息完成--------");
		if(changeEntity.getProjectId()!=null){
			//反写项目的开工日期、竣工日期，工期数据
			CommonResponse<ProjectVO> projectData = zjkjProjectApi.queryDetailById(changeEntity.getProjectId());
			if(projectData.isSuccess()&&projectData.getData()!=null){
				ProjectVO projectVO = projectData.getData();
				projectVO.setProjectNum(changeEntity.getProjectNum());// 项目序号
				projectVO.setPcFactory(changeEntity.getPcFactory()); // 是否PC厂
				projectVO.setProjectStatus(changeEntity.getProjectStatus()); // 项目状态
				projectVO.setGraphicProgress(changeEntity.getGraphicProgress()); // 形象进度
				projectVO.setProjectNature(changeEntity.getProjectNature()); // 项目性质
				projectVO.setProvisionalAmount(changeEntity.getProvisionalAmount()); // 暂列金金额
				projectVO.setHasConstructionPermit(changeEntity.getHasConstructionPermit()); // 是/否办理施工许可证
				projectVO.setPermitExplain(changeEntity.getPermitExplain()); // 未办理施工许可证说明
				projectVO.setPlanStartDate(changeEntity.getPlanStartDate());
				projectVO.setPlanEndDate(changeEntity.getPlanEndDate());
				projectVO.setPlanDuration(changeEntity.getPlanDuration());
				projectVO.setContractNodes(changeEntity.getContractNodes()); // 合同过程重大节点
				projectVO.setEstablishProjectDepartment(changeEntity.getEstablishProjectDepartment()); // 是/否建立项目经理部
				projectVO.setProjectDepartmentExplain(changeEntity.getProjectDepartmentExplain()); // 未建立项目经理部情况说明
				projectVO.setManagementPersonNum(changeEntity.getManagementPersonNum()); // 管理人员数量
				projectVO.setLaborPersonNum(changeEntity.getLaborPersonNum()); // 劳务人员数量
				projectVO.setContractGoal(changeEntity.getContractGoal()); // 合同创优目标
				CommonResponse<ProjectVO> saveback = zjkjProjectApi.saveProject(projectVO);
				if(!saveback.isSuccess()){
					logger.info("反写项目信息失败----------------->"+saveback.getMsg());
					return CommonResponse.error("反写项目信息失败");
				}
			}else{
				return CommonResponse.error("未查询到项目信息");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单不允许弃审");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
