package com.ejianc.business.outputValue.utils;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaEntity;

import java.math.BigDecimal;
import java.util.LinkedList;

public class OutputValueUtils {

    private OutputValueUtils() {
    }

    /**
     * 获取小于当前月份的月份
     */
    public static String getMonths(String month) {
        LinkedList<String> monthList = new LinkedList<>();
        monthList.add("01月");
        monthList.add("02月");
        monthList.add("03月");
        monthList.add("04月");
        monthList.add("05月");
        monthList.add("06月");
        monthList.add("07月");
        monthList.add("08月");
        monthList.add("09月");
        monthList.add("10月");
        monthList.add("11月");
        monthList.add("12月");
        Integer nowMonth = Integer.parseInt(month.substring(0,2));
        String months = "";
        for(int i=0; i<nowMonth; i++){
            if(months.length()>0){
               months += ("," + monthList.get(i));
            }else{
                months += (monthList.get(i));
            }
        }
        return months;
    }

    public static String getReportingMonth(String year, String month) {
        String reportingMonth = year + "-";
        switch (month){
            case "1月":
                reportingMonth += "01";
                break;
            case "2月":
                reportingMonth += "02";
                break;
            case "3月":
                reportingMonth += "03";
                break;
            case "4月":
                reportingMonth += "04";
                break;
            case "5月":
                reportingMonth += "05";
                break;
            case "6月":
                reportingMonth += "06";
                break;
            case "7月":
                reportingMonth += "07";
                break;
            case "8月":
                reportingMonth += "08";
                break;
            case "9月":
                reportingMonth += "09";
                break;
            case "10月":
                reportingMonth += "10";
                break;
            case "11月":
                reportingMonth += "11";
                break;
            case "12月":
                reportingMonth += "12";
                break;
            default:
                break;
        }
        return reportingMonth;
    }

    // 年度目标产值余量====当前项目年度计划产值-以往月份的计划产值合计
    public static BigDecimal getMarginValue(ProjectPcYearBusinessQuotaEntity projectPcYearBusinessQuotaEntity, String month) {
        LinkedList<BigDecimal> monthValueList = new LinkedList<>();
        monthValueList.add(projectPcYearBusinessQuotaEntity.getJanuaryPlanOutputValue()); //1月计划产值（万元）
        monthValueList.add(projectPcYearBusinessQuotaEntity.getFebruaryPlanOutputValue()); //2月计划产值（万元）
        monthValueList.add(projectPcYearBusinessQuotaEntity.getMarchPlanOutputValue()); //3月计划产值（万元）
        monthValueList.add(projectPcYearBusinessQuotaEntity.getAprilPlanOutputValue()); //4月计划产值（万元）
        monthValueList.add(projectPcYearBusinessQuotaEntity.getMayPlanOutputValue()); //5月计划产值（万元）
        monthValueList.add(projectPcYearBusinessQuotaEntity.getJunePlanOutputValue()); //6月计划产值（万元）
        monthValueList.add(projectPcYearBusinessQuotaEntity.getJulyPlanOutputValue()); //7月计划产值（万元）
        monthValueList.add(projectPcYearBusinessQuotaEntity.getAugustPlanOutputValue()); //8月计划产值（万元）
        monthValueList.add(projectPcYearBusinessQuotaEntity.getSeptemberPlanOutputValue()); //9月计划产值（万元）
        monthValueList.add(projectPcYearBusinessQuotaEntity.getOctoberPlanOutputValue()); //10月计划产值（万元）
        monthValueList.add(projectPcYearBusinessQuotaEntity.getNovemberPlanOutputValue()); //11月计划产值（万元）
        monthValueList.add(projectPcYearBusinessQuotaEntity.getDecemberPlanOutputValue()); //12月计划产值（万元）
        BigDecimal allValue = new BigDecimal(0);
        Integer nowMonth = Integer.parseInt(month.substring(0,2));
        for(int i=0; i<nowMonth; i++){
            allValue = allValue.add(monthValueList.get(i));
        }
        BigDecimal marginValue = CommonUtils.subtractBigDecimal(projectPcYearBusinessQuotaEntity.getYearPlanOutputValue(), allValue);
        return marginValue;
    }
}
