package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 物资出库记录
 *
 * @author generator
 *
 */
 @TableName("ejc_material_deliveryrecord")
public class DeliveryrecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="approve_time")
    private java.util.Date approveTime; // 审批通过日期
    @TableField(value="projectdept_id")
    private java.lang.Long projectdeptId; // 项目部人员id
    @TableField(value="projectdept")
    private java.lang.String projectdept; // 项目部人员
    @TableField(value="bills_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private java.util.Date billsTime; // 单据日期
    @TableField(value="brands")
    private java.lang.String brands; // 品牌
    @TableField(value="picking_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private java.util.Date pickingTime; // 领料日期
    @TableField(value="picking_unit")
    private java.lang.String pickingUnit; // 领料单位
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目id
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="org_id")
    private java.lang.Long orgId; // 所属组织id
    @TableField(value="org_name")
    private java.lang.String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private java.lang.Long projectDepartmentId; // 项目部id
    @TableField(value="change_id")
    private java.lang.Long changeId; // 变更单据id
    @TableField(value="change_state")
    private java.lang.String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    @TableField(value="remarks")
    private java.lang.String remarks; // 备注
    @TableField(value="agent_id")
    private java.lang.Long agentId; // 经办人
    @TableField(value="agent_name")
    private java.lang.String agentName; // 经办人姓名
    @TableField(value="issue_num")
    private java.lang.String issueNum; // 出库编号
    @TableField(value="receiving_purpose")
    private java.lang.String receivingPurpose; // 领用用途
    @TableField(value="signature_cust")
    private java.lang.String signatureCust; // 保管员签字
    @TableField(value="project_material")
    private java.lang.String projectMaterial; // 项目物资部
    @TableField(value="project_engineer")
    private java.lang.String projectEngineer; // 项目管理部
    @TableField(value="ministry")
    private java.lang.String ministry; // 商务部
    @TableField(value="approval_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private java.util.Date approvalDate; // 审批日期
    @TableField(value="pickingUnit_id")
    private java.lang.Long pickingunitId; // 领料单位id
    @TableField(value="delivery_type")
    private Integer deliveryType; // 出库单类型 0-自动出库 1-手动出库
    @TableField(value="warehousing_id")
    private Long warehousingId; // 入库单id
    /**
     * 出库类型 0-成品出库 1-成品退库 2-直入直出退库  3-废旧物资出库 4-资产出库 5-废旧物资退库 6-资产退库7-直入直出退供应商 8-无来源退库
     * 出库类型 0-成品出库 1-成品退库    4-资产出库 5-废旧物资退库 6-资产退库7-直入直出退供应商 8-无来源退库
     */
    @TableField(value="delivery_types")
    private Integer deliveryTypes; //
    @TableField(value="delivery_id")
    private java.lang.Long deliveryId; // 出库单id
    @TableField(value="not_delivery_quantity")
    private BigDecimal notDeliveryQuantity;//未出库数量
    @TableField(value="receipt_doc_id")
    private Long receiptDocId; // 入库单id参照使用
    @TableField(value="returned_store_id")
    private Long returnedStoreId; // 退库仓库id
    @TableField(value="returned_store_name")
    private String returnedStoreName; // 退库仓库名称
    @TableField(value="returned_store_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private java.util.Date returnedStoreDate; // 退库仓库日期
    @TableField(value="store_id")
    private Long storeId;
    @TableField(value="store_name")
    private java.lang.String storeName; // 仓库名称

    @TableField(value="self_state")
    private java.lang.String selfState; // 是否自施 0-否 1-是
    @TableField(value="out_mny_tax")
    private BigDecimal outMnyTax; // 出库金额(含税)
    @TableField(value="out_mny")
    private BigDecimal outMny; // 出库金额
    @TableField(exist = false)
    private java.lang.String acceptanceType; // 验收类型

    @TableField(exist = false)
    private Integer storeType; // 仓库类型

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="puin_time_limit")
    private java.util.Date puinTimeLimit; // 入库单的入库日期校验用

    @TableField(exist=false)
    private Long sourceId;
    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String systemId;

    @TableField(value="sign_status")
    private Integer signStatus;//分包签字状态 1-未签字,2-已签字

    /**
     * 供方经办人名称
     */
    @TableField(value = "sup_operator_name")
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone;
    /**
     * 供方经办人账号
     */
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "sup_operate_time")
    private Date supOperateTime;

    @TableField(exist=false)
    @SubEntity(serviceName="deliveryrecorddetailService",pidName = "mid")
    private List<DeliveryrecorddetailEntity> deliveryrecorddetailEntities = new ArrayList<>(); // 物资出库记录子表


    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Date getPuinTimeLimit() {
        return puinTimeLimit;
    }

    public void setPuinTimeLimit(Date puinTimeLimit) {
        this.puinTimeLimit = puinTimeLimit;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public BigDecimal getOutMnyTax() {
        return outMnyTax;
    }

    public void setOutMnyTax(BigDecimal outMnyTax) {
        this.outMnyTax = outMnyTax;
    }

    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public String getSelfState() {
        return selfState;
    }

    public void setSelfState(String selfState) {
        this.selfState = selfState;
    }




    public Date getReturnedStoreDate() {
        return returnedStoreDate;
    }

    public void setReturnedStoreDate(Date returnedStoreDate) {
        this.returnedStoreDate = returnedStoreDate;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 审批通过日期
     */
    public java.util.Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批通过日期
     */
    public void setApproveTime(java.util.Date approveTime) {
        this.approveTime = approveTime;
    }
    /**
     * 项目部人员id
     */
    public java.lang.Long getProjectdeptId() {
        return projectdeptId;
    }

    /**
     * 项目部人员id
     */
    public void setProjectdeptId(java.lang.Long projectdeptId) {
        this.projectdeptId = projectdeptId;
    }
    /**
     * 项目部人员
     */
    public java.lang.String getProjectdept() {
        return projectdept;
    }

    /**
     * 项目部人员
     */
    public void setProjectdept(java.lang.String projectdept) {
        this.projectdept = projectdept;
    }
    /**
     * 单据日期
     */
    public java.util.Date getBillsTime() {
        return billsTime;
    }

    /**
     * 单据日期
     */
    public void setBillsTime(java.util.Date billsTime) {
        this.billsTime = billsTime;
    }
    /**
     * 品牌
     */
    public java.lang.String getBrands() {
        return brands;
    }

    /**
     * 品牌
     */
    public void setBrands(java.lang.String brands) {
        this.brands = brands;
    }
    /**
     * 领料日期
     */
    public java.util.Date getPickingTime() {
        return pickingTime;
    }

    /**
     * 领料日期
     */
    public void setPickingTime(java.util.Date pickingTime) {
        this.pickingTime = pickingTime;
    }
    /**
     * 领料单位
     */
    public java.lang.String getPickingUnit() {
        return pickingUnit;
    }

    /**
     * 领料单位
     */
    public void setPickingUnit(java.lang.String pickingUnit) {
        this.pickingUnit = pickingUnit;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 变更单据id
     */
    public java.lang.Long getChangeId() {
        return changeId;
    }

    /**
     * 变更单据id
     */
    public void setChangeId(java.lang.Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public java.lang.String getChangeState() {
        return changeState;
    }

    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public void setChangeState(java.lang.String changeState) {
        this.changeState = changeState;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }
    /**
     * 出库编号
     */
    public java.lang.String getIssueNum() {
        return issueNum;
    }

    /**
     * 出库编号
     */
    public void setIssueNum(java.lang.String issueNum) {
        this.issueNum = issueNum;
    }
    /**
     * 领用用途
     */
    public java.lang.String getReceivingPurpose() {
        return receivingPurpose;
    }

    /**
     * 领用用途
     */
    public void setReceivingPurpose(java.lang.String receivingPurpose) {
        this.receivingPurpose = receivingPurpose;
    }
    /**
     * 保管员签字
     */
    public java.lang.String getSignatureCust() {
        return signatureCust;
    }

    /**
     * 保管员签字
     */
    public void setSignatureCust(java.lang.String signatureCust) {
        this.signatureCust = signatureCust;
    }
    /**
     * 项目物资部
     */
    public java.lang.String getProjectMaterial() {
        return projectMaterial;
    }

    /**
     * 项目物资部
     */
    public void setProjectMaterial(java.lang.String projectMaterial) {
        this.projectMaterial = projectMaterial;
    }
    /**
     * 项目管理部
     */
    public java.lang.String getProjectEngineer() {
        return projectEngineer;
    }

    /**
     * 项目管理部
     */
    public void setProjectEngineer(java.lang.String projectEngineer) {
        this.projectEngineer = projectEngineer;
    }
    /**
     * 商务部
     */
    public java.lang.String getMinistry() {
        return ministry;
    }

    /**
     * 商务部
     */
    public void setMinistry(java.lang.String ministry) {
        this.ministry = ministry;
    }
    /**
     * 审批日期
     */
    public java.util.Date getApprovalDate() {
        return approvalDate;
    }

    /**
     * 审批日期
     */
    public void setApprovalDate(java.util.Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    /**
     * 物资出库记录子表
     */
    public List<DeliveryrecorddetailEntity> getDeliveryrecorddetailEntities() {
        return deliveryrecorddetailEntities;
    }

    /**
     * 物资出库记录子表
     */
    public void setDeliveryrecorddetailEntities(List<DeliveryrecorddetailEntity> deliveryrecorddetailEntities) {
        this.deliveryrecorddetailEntities = deliveryrecorddetailEntities;
    }

    @ReferSerialTransfer(referCode="zjkj-outcontract-supplier")
    public Long getPickingunitId() {
        return pickingunitId;
    }

    @ReferDeserialTransfer
    public void setPickingunitId(Long pickingunitId) {
        this.pickingunitId = pickingunitId;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Long getWarehousingId() {
        return warehousingId;
    }

    public void setWarehousingId(Long warehousingId) {
        this.warehousingId = warehousingId;
    }

    public Integer getDeliveryTypes() {
        return deliveryTypes;
    }

    public void setDeliveryTypes(Integer deliveryTypes) {
        this.deliveryTypes = deliveryTypes;
    }

    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }

    public BigDecimal getNotDeliveryQuantity() {
        return notDeliveryQuantity;
    }

    public void setNotDeliveryQuantity(BigDecimal notDeliveryQuantity) {
        this.notDeliveryQuantity = notDeliveryQuantity;
    }
    public Long getReceiptDocId() {
        return receiptDocId;
    }

    public void setReceiptDocId(Long receiptDocId) {
        this.receiptDocId = receiptDocId;
    }

    public Long getReturnedStoreId() {
        return returnedStoreId;
    }

    public void setReturnedStoreId(Long returnedStoreId) {
        this.returnedStoreId = returnedStoreId;
    }

    public String getReturnedStoreName() {
        return returnedStoreName;
    }

    public void setReturnedStoreName(String returnedStoreName) {
        this.returnedStoreName = returnedStoreName;
    }

    public String getAcceptanceType() {
        return acceptanceType;
    }

    public void setAcceptanceType(String acceptanceType) {
        this.acceptanceType = acceptanceType;
    }
}
