package com.ejianc.business.material.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.material.bean.StoreBalanceDetailEntity;
/**
 * 物资结存
 *
 * @author generator
 *
 */
 @TableName("ejc_material_storebalance")
public class StoreBalanceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="remarks")
    private String remarks; // 备注
    @TableField(value="agent_id")
    private Long agentId; // 经办人
    @TableField(value="agent_name")
    private String agentName; // 经办人姓名
    @TableField(value="store_id")
    private Long storeId; // 仓库id
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="month")
    private Date month;
    @TableField(value="instore_quantity_total")
    private BigDecimal instoreQuantityTotal; // 本月入库数量
    @TableField(value="instore_amount_tax_total")
    private BigDecimal instoreAmountTaxTotal; // 本月入库金额（含税）
    @TableField(value="instore_amount_untax_total")
    private BigDecimal instoreAmountUntaxTotal; // 本月入库金额（无税）
    @TableField(value="outstore_quantity_total")
    private BigDecimal outstoreQuantityTotal; // 本月消耗数量
    @TableField(value="outstore_amount_tax_total")
    private BigDecimal outstoreAmountTaxTotal; // 本月消耗金额（含税）
    @TableField(value="outstore_amount_untax_total")
    private BigDecimal outstoreAmountUntaxTotal; // 本月消耗金额（无税）
    @TableField(value="last_quantity_total")
    private BigDecimal lastQuantityTotal; // 上月结存数量
    @TableField(value="last_amount_tax_total")
    private BigDecimal lastAmountTaxTotal; // 上月结存金额（含税）
    @TableField(value="last_amount_untax_total")
    private BigDecimal lastAmountUntaxTotal; // 上月结存金额（无税）
    @TableField(value="current_quantity_total")
    private BigDecimal currentQuantityTotal; // 本月结存数量
    @TableField(value="current_amount_tax_total")
    private BigDecimal currentAmountTaxTotal; // 本月结存金额（含税）
    @TableField(value="current_amount_untax_total")
    private BigDecimal currentAmountUntaxTotal; // 本月结存金额（无税）
    @TableField(value="is_settlement")
    private Integer isSettlement; // 是否归集状态 0 未归集 1 归集
    @TableField(exist = false)
    private String billStateName; // 单据状态名称

    @TableField(exist=false)
    @SubEntity(serviceName="storeBalanceDetailService", pidName = "mid")
    private List<StoreBalanceDetailEntity> storeBalanceDetailEntities = new ArrayList<>(); // 物资结存明细


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public BigDecimal getInstoreQuantityTotal() {
        return instoreQuantityTotal;
    }

    public void setInstoreQuantityTotal(BigDecimal instoreQuantityTotal) {
        this.instoreQuantityTotal = instoreQuantityTotal;
    }
    public BigDecimal getInstoreAmountTaxTotal() {
        return instoreAmountTaxTotal;
    }

    public void setInstoreAmountTaxTotal(BigDecimal instoreAmountTaxTotal) {
        this.instoreAmountTaxTotal = instoreAmountTaxTotal;
    }
    public BigDecimal getInstoreAmountUntaxTotal() {
        return instoreAmountUntaxTotal;
    }

    public void setInstoreAmountUntaxTotal(BigDecimal instoreAmountUntaxTotal) {
        this.instoreAmountUntaxTotal = instoreAmountUntaxTotal;
    }
    public BigDecimal getOutstoreQuantityTotal() {
        return outstoreQuantityTotal;
    }

    public void setOutstoreQuantityTotal(BigDecimal outstoreQuantityTotal) {
        this.outstoreQuantityTotal = outstoreQuantityTotal;
    }
    public BigDecimal getOutstoreAmountTaxTotal() {
        return outstoreAmountTaxTotal;
    }

    public void setOutstoreAmountTaxTotal(BigDecimal outstoreAmountTaxTotal) {
        this.outstoreAmountTaxTotal = outstoreAmountTaxTotal;
    }
    public BigDecimal getOutstoreAmountUntaxTotal() {
        return outstoreAmountUntaxTotal;
    }

    public void setOutstoreAmountUntaxTotal(BigDecimal outstoreAmountUntaxTotal) {
        this.outstoreAmountUntaxTotal = outstoreAmountUntaxTotal;
    }
    public BigDecimal getLastQuantityTotal() {
        return lastQuantityTotal;
    }

    public void setLastQuantityTotal(BigDecimal lastQuantityTotal) {
        this.lastQuantityTotal = lastQuantityTotal;
    }
    public BigDecimal getLastAmountTaxTotal() {
        return lastAmountTaxTotal;
    }

    public void setLastAmountTaxTotal(BigDecimal lastAmountTaxTotal) {
        this.lastAmountTaxTotal = lastAmountTaxTotal;
    }
    public BigDecimal getLastAmountUntaxTotal() {
        return lastAmountUntaxTotal;
    }

    public void setLastAmountUntaxTotal(BigDecimal lastAmountUntaxTotal) {
        this.lastAmountUntaxTotal = lastAmountUntaxTotal;
    }
    public BigDecimal getCurrentQuantityTotal() {
        return currentQuantityTotal;
    }

    public void setCurrentQuantityTotal(BigDecimal currentQuantityTotal) {
        this.currentQuantityTotal = currentQuantityTotal;
    }
    public BigDecimal getCurrentAmountTaxTotal() {
        return currentAmountTaxTotal;
    }

    public void setCurrentAmountTaxTotal(BigDecimal currentAmountTaxTotal) {
        this.currentAmountTaxTotal = currentAmountTaxTotal;
    }
    public BigDecimal getCurrentAmountUntaxTotal() {
        return currentAmountUntaxTotal;
    }

    public void setCurrentAmountUntaxTotal(BigDecimal currentAmountUntaxTotal) {
        this.currentAmountUntaxTotal = currentAmountUntaxTotal;
    }

    public List<StoreBalanceDetailEntity> getStoreBalanceDetailEntities() {
        return storeBalanceDetailEntities;
    }

    public void setStoreBalanceDetailEntities(List<StoreBalanceDetailEntity> storeBalanceDetailEntities) {
        this.storeBalanceDetailEntities = storeBalanceDetailEntities;
    }

    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }

    public Integer getIsSettlement() {
        return isSettlement;
    }

    public void setIsSettlement(Integer isSettlement) {
        this.isSettlement = isSettlement;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
