package com.ejianc.business.material.service.impl;


import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.RealtimebalanceEntity;
import com.ejianc.business.material.mapper.GatherSendMapper;
import com.ejianc.business.material.service.IGatherSendService;
import com.ejianc.business.material.vo.FlowmeterVO;
import com.ejianc.foundation.material.vo.GatherSendVO;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service("gatherSendService")
public class GatherSendServiceImpl extends BaseServiceImpl<GatherSendMapper, GatherSendVO> implements IGatherSendService {


    @Resource
    private GatherSendMapper gatherSendMapper;


    @Override
    public List<GatherSendVO> queryListAll(Integer storeType, String stateDate, String endDate,String searchText,String stateDateSub,List<Long> commonOrgIds,List<Long> departmentIds) {
        return gatherSendMapper.queryListAll(storeType,stateDate,endDate,searchText,stateDateSub,commonOrgIds,departmentIds);
    }

    @Override
    public List<GatherSendVO> queryList(Integer storeType, String stateDate, String endDate,String searchText,List<Long> commonOrgIds,List<Long> departmentIds) {
        return gatherSendMapper.queryList(storeType,stateDate,endDate,searchText,commonOrgIds,departmentIds);
    }

    @Override
    public List<GatherSendVO> queryFlow(List<FlowmeterEntity> flowmeterEntityList,List<FlowmeterEntity> flowmeterEntityListTop) {
        List<FlowmeterEntity> flowmeterEntityList1 = new ArrayList<>();
        flowmeterEntityList1.addAll(flowmeterEntityList);
        flowmeterEntityList1.addAll(flowmeterEntityListTop);
        List<FlowmeterEntity> flowmeterEntityArrayList = flowmeterEntityList1.stream()
                .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getMaterialId()+"_"+f.getProjectId()+"_"+f.getStoreId()))), ArrayList::new));

        //
        List<GatherSendVO> gatherSendVOList = new ArrayList<>();
        for(FlowmeterEntity flowmeterEntity : flowmeterEntityArrayList){
            GatherSendVO gatherSendVO = new GatherSendVO();
            gatherSendVO.setId(IdWorker.getId());
            gatherSendVO.setProjectId(flowmeterEntity.getProjectId());
            gatherSendVO.setProjectName(flowmeterEntity.getProjectName());
            gatherSendVO.setStoreId(flowmeterEntity.getStoreId());
            gatherSendVO.setStoreName(flowmeterEntity.getStoreName());
            gatherSendVO.setMaterialCategoryCode(flowmeterEntity.getMaterialCategoryCode());
            gatherSendVO.setMaterialCategoryName(flowmeterEntity.getMaterialCategoryName());
            gatherSendVO.setMaterialId(flowmeterEntity.getMaterialId());
            gatherSendVO.setMaterialCode(flowmeterEntity.getMaterialCode());
            gatherSendVO.setMaterialName(flowmeterEntity.getMaterialName());
            gatherSendVO.setSpecialModel(flowmeterEntity.getSpecialModel());
            gatherSendVO.setMeasurementUnit(flowmeterEntity.getMeasurementUnit());
            gatherSendVOList.add(gatherSendVO);
        }

        List<GatherSendVO> gatherSendTopVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(flowmeterEntityListTop)){
            List<FlowmeterEntity> flowmeterEntityListNew = flowmeterEntityListTop.stream()
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getMaterialId()+"_"+f.getProjectId()+"_"+f.getStoreId()))), ArrayList::new));


            //入库数量
            Map<String, BigDecimal> enterQuantityMap = flowmeterEntityListTop.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //入库含税金额
            Map<String, BigDecimal> enterAmountIncluetaxMap = flowmeterEntityListTop.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //入库无税金额
            Map<String, BigDecimal> enterAmountExcluetaxMap = flowmeterEntityListTop.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));


            //出库数量
            Map<String, BigDecimal> deliveryQuantityMap = flowmeterEntityListTop.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //出库含税金额
            Map<String, BigDecimal> deliveryAmountIncluetaxMap = flowmeterEntityListTop.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //出库无税金额
            Map<String, BigDecimal> deliveryAmountExcluetaxMap = flowmeterEntityListTop.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));

            BigDecimal enterQuantity = BigDecimal.ZERO;//本期入库数量
            BigDecimal enterAmountIncluetax = BigDecimal.ZERO;//本期入库含税金额
            BigDecimal enterAmountExcluetax = BigDecimal.ZERO;//本期入库不含税金额
            BigDecimal enterUnitPriceIncluetax = BigDecimal.ZERO;//本期入库含税单价
            BigDecimal enterUnitPriceExcluetax = BigDecimal.ZERO;//本期入库不含税单价

            BigDecimal deliveryQuantity = BigDecimal.ZERO;//本期出库数量
            BigDecimal deliveryAmountIncluetax = BigDecimal.ZERO;//本期出库含税金额
            BigDecimal deliveryAmountExcluetax = BigDecimal.ZERO;//本期出库不含税金额
            BigDecimal deliveryUnitPriceIncluetax = BigDecimal.ZERO;//本期出库含税单价
            BigDecimal deliveryUnitPriceExcluetax = BigDecimal.ZERO;//本期出库不含税单价

            for (FlowmeterEntity flowmeterEntity : flowmeterEntityListNew) {
                enterQuantity = BigDecimal.ZERO;
                enterAmountIncluetax = BigDecimal.ZERO;
                enterAmountExcluetax = BigDecimal.ZERO;
                enterUnitPriceIncluetax = BigDecimal.ZERO;//本期入库含税单价
                enterUnitPriceExcluetax = BigDecimal.ZERO;//本期入库不含税单价

                deliveryQuantity = BigDecimal.ZERO;
                deliveryAmountIncluetax = BigDecimal.ZERO;
                deliveryAmountExcluetax = BigDecimal.ZERO;
                deliveryUnitPriceIncluetax = BigDecimal.ZERO;//本期出库含税单价
                deliveryUnitPriceExcluetax = BigDecimal.ZERO;//本期出库不含税单价
                GatherSendVO gatherSendVO = new GatherSendVO();
                gatherSendVO.setId(IdWorker.getId());
                gatherSendVO.setProjectId(flowmeterEntity.getProjectId());
                gatherSendVO.setProjectName(flowmeterEntity.getProjectName());
                gatherSendVO.setStoreId(flowmeterEntity.getStoreId());
                gatherSendVO.setStoreName(flowmeterEntity.getStoreName());
                gatherSendVO.setMaterialCategoryCode(flowmeterEntity.getMaterialCategoryCode());
                gatherSendVO.setMaterialCategoryName(flowmeterEntity.getMaterialCategoryName());
                gatherSendVO.setMaterialId(flowmeterEntity.getMaterialId());
                gatherSendVO.setMaterialCode(flowmeterEntity.getMaterialCode());
                gatherSendVO.setMaterialName(flowmeterEntity.getMaterialName());
                gatherSendVO.setSpecialModel(flowmeterEntity.getSpecialModel());
                gatherSendVO.setMeasurementUnit(flowmeterEntity.getMeasurementUnit());
                if (enterQuantityMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    enterQuantity = enterQuantityMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//入库数量
                    gatherSendVO.setEnterQuantity(enterQuantity);
                }
                if (enterAmountIncluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    enterAmountIncluetax = enterAmountIncluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//入库含税金额
                    gatherSendVO.setEnterAmountIncluetax(enterAmountIncluetax);
                }
                if (enterAmountExcluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    enterAmountExcluetax = enterAmountExcluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//入库无税金额
                    gatherSendVO.setEnterAmountExcluetax(enterAmountExcluetax);
                }

                gatherSendVO.setEnterUnitPriceIncluetax(ComputeUtil.safeDiv(enterAmountIncluetax,enterQuantity));//本期入库含税单价
                gatherSendVO.setEnterUnitPriceExcluetax(ComputeUtil.safeDiv(enterAmountExcluetax,enterQuantity));//本期入库不含税单价


                if (deliveryQuantityMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    deliveryQuantity = deliveryQuantityMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//出库数量
                    gatherSendVO.setDeliveryQuantity(deliveryQuantity);
                }
                if (deliveryAmountIncluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    deliveryAmountIncluetax = deliveryAmountIncluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//出库含税金额
                    gatherSendVO.setDeliveryAmountIncluetax(deliveryAmountIncluetax);
                }
                if (deliveryAmountExcluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    deliveryAmountExcluetax = deliveryAmountExcluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//出库无税金额
                    gatherSendVO.setDeliveryAmountExcluetax(deliveryAmountExcluetax);
                }
                gatherSendVO.setDeliveryUnitPriceIncluetax(ComputeUtil.safeDiv(deliveryAmountIncluetax,deliveryQuantity));//本期出库含税单价
                gatherSendVO.setDeliveryUnitPriceExcluetax(ComputeUtil.safeDiv(deliveryAmountExcluetax,deliveryQuantity));//本期出库不含税单价


                gatherSendVO.setQuantity(ComputeUtil.safeSub(enterQuantity,deliveryQuantity)); //本期结存数量 不含上期
                gatherSendVO.setAmountIncluetax(ComputeUtil.safeSub(enterAmountIncluetax,deliveryAmountIncluetax)); //本期结存含税金额 不含上期
                gatherSendVO.setAmountExcluetax(ComputeUtil.safeSub(enterAmountExcluetax,deliveryAmountExcluetax)); //本期结存无税金额 不含上期
                gatherSendVO.setUnitPriceIncluetax(ComputeUtil.safeDiv( gatherSendVO.getAmountIncluetax(),gatherSendVO.getQuantity())); //本期结存含税单价 不含上期
                gatherSendVO.setUnitPriceExcluetax(ComputeUtil.safeDiv( gatherSendVO.getAmountExcluetax(),gatherSendVO.getQuantity())); //本期结存无税单价 不含上期

                gatherSendTopVOList.add(gatherSendVO);
            }


        }

        //塞入上期数据
        if(CollectionUtils.isNotEmpty(gatherSendTopVOList)){
            Map<Long,GatherSendVO> maps = gatherSendTopVOList.stream().collect(Collectors.toMap(x->x.getProjectId()+x.getMaterialId()+x.getStoreId(), Function.identity(),(k1, k2) ->k2));
            GatherSendVO cvo;
            Long k;
            for (GatherSendVO vo : gatherSendVOList) {
                k=vo.getProjectId()+vo.getMaterialId()+vo.getStoreId();
                if (maps.containsKey(k)){
                    cvo = maps.get(k);
                    vo.setCurrentQuantity(cvo.getQuantity());//上月结存数量
                    vo.setCurrentAmountTax(cvo.getAmountIncluetax());//上月结存含税金额
                    vo.setCurrentAmountEntax(cvo.getAmountExcluetax());//上月结存不含税金额
                    vo.setCurrentUnitPriceTax(ComputeUtil.safeDiv(cvo.getAmountIncluetax(),cvo.getQuantity()));//上月结存含税单价
                    vo.setCurrentUnitPriceUntax(ComputeUtil.safeDiv(cvo.getAmountExcluetax(),cvo.getQuantity()));//上月结存不含税单价
                }
            }
        }
        List<GatherSendVO> gatherSendVOList1 = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(flowmeterEntityList)) {
            List<FlowmeterEntity> flowmeterEntityArrayList1 = flowmeterEntityList.stream()
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getMaterialId()+"_"+f.getProjectId()+"_"+f.getStoreId()))), ArrayList::new));


            //入库数量
            Map<String, BigDecimal> enterQuantityMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //入库含税金额
            Map<String, BigDecimal> enterAmountIncluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //入库无税金额
            Map<String, BigDecimal> enterAmountExcluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));


            //出库数量
            Map<String, BigDecimal> deliveryQuantityMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //出库含税金额
            Map<String, BigDecimal> deliveryAmountIncluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            //出库无税金额
            Map<String, BigDecimal> deliveryAmountExcluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy((score -> score.getMaterialId()+"_"+score.getProjectId()+"_"+score.getStoreId()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));

            BigDecimal enterQuantity = BigDecimal.ZERO;//本期入库数量
            BigDecimal enterAmountIncluetax = BigDecimal.ZERO;//本期入库含税金额
            BigDecimal enterAmountExcluetax = BigDecimal.ZERO;//本期入库不含税金额
            BigDecimal enterUnitPriceIncluetax = BigDecimal.ZERO;//本期入库含税单价
            BigDecimal enterUnitPriceExcluetax = BigDecimal.ZERO;//本期入库不含税单价

            BigDecimal deliveryQuantity = BigDecimal.ZERO;//本期出库数量
            BigDecimal deliveryAmountIncluetax = BigDecimal.ZERO;//本期出库含税金额
            BigDecimal deliveryAmountExcluetax = BigDecimal.ZERO;//本期出库不含税金额
            BigDecimal deliveryUnitPriceIncluetax = BigDecimal.ZERO;//本期出库含税单价
            BigDecimal deliveryUnitPriceExcluetax = BigDecimal.ZERO;//本期出库不含税单价
            for (FlowmeterEntity flowmeterEntity : flowmeterEntityArrayList1) {
                 enterQuantity = BigDecimal.ZERO;
                 enterAmountIncluetax = BigDecimal.ZERO;
                 enterAmountExcluetax = BigDecimal.ZERO;
                 enterUnitPriceIncluetax = BigDecimal.ZERO;//本期入库含税单价
                 enterUnitPriceExcluetax = BigDecimal.ZERO;//本期入库不含税单价

                 deliveryQuantity = BigDecimal.ZERO;
                 deliveryAmountIncluetax = BigDecimal.ZERO;
                 deliveryAmountExcluetax = BigDecimal.ZERO;
                 deliveryUnitPriceIncluetax = BigDecimal.ZERO;//本期出库含税单价
                 deliveryUnitPriceExcluetax = BigDecimal.ZERO;//本期出库不含税单价
                GatherSendVO gatherSendVO = new GatherSendVO();
                gatherSendVO.setId(IdWorker.getId());
                gatherSendVO.setProjectId(flowmeterEntity.getProjectId());
                gatherSendVO.setProjectName(flowmeterEntity.getProjectName());
                gatherSendVO.setStoreId(flowmeterEntity.getStoreId());
                gatherSendVO.setStoreName(flowmeterEntity.getStoreName());
                gatherSendVO.setMaterialCategoryCode(flowmeterEntity.getMaterialCategoryCode());
                gatherSendVO.setMaterialCategoryName(flowmeterEntity.getMaterialCategoryName());
                gatherSendVO.setMaterialId(flowmeterEntity.getMaterialId());
                gatherSendVO.setMaterialCode(flowmeterEntity.getMaterialCode());
                gatherSendVO.setMaterialName(flowmeterEntity.getMaterialName());
                gatherSendVO.setSpecialModel(flowmeterEntity.getSpecialModel());
                gatherSendVO.setMeasurementUnit(flowmeterEntity.getMeasurementUnit());
                if (enterQuantityMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    enterQuantity = enterQuantityMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//入库数量
                    gatherSendVO.setEnterQuantity(enterQuantity);
                }
                if (enterAmountIncluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    enterAmountIncluetax = enterAmountIncluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//入库含税金额
                    gatherSendVO.setEnterAmountIncluetax(enterAmountIncluetax);
                }
                if (enterAmountExcluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    enterAmountExcluetax = enterAmountExcluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//入库无税金额
                    gatherSendVO.setEnterAmountExcluetax(enterAmountExcluetax);
                }

                gatherSendVO.setEnterUnitPriceIncluetax(ComputeUtil.safeDiv(enterAmountIncluetax,enterQuantity));//本期入库含税单价
                gatherSendVO.setEnterUnitPriceExcluetax(ComputeUtil.safeDiv(enterAmountExcluetax,enterQuantity));//本期入库不含税单价


                if (deliveryQuantityMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    deliveryQuantity = deliveryQuantityMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//出库数量
                    gatherSendVO.setDeliveryQuantity(deliveryQuantity);
                }
                if (deliveryAmountIncluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    deliveryAmountIncluetax = deliveryAmountIncluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//出库含税金额
                    gatherSendVO.setDeliveryAmountIncluetax(deliveryAmountIncluetax);
                }
                if (deliveryAmountExcluetaxMap.containsKey(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId())) {
                    deliveryAmountExcluetax = deliveryAmountExcluetaxMap.get(flowmeterEntity.getMaterialId()+"_"+flowmeterEntity.getProjectId()+"_"+flowmeterEntity.getStoreId());//出库无税金额
                    gatherSendVO.setDeliveryAmountExcluetax(deliveryAmountExcluetax);
                }
                gatherSendVO.setDeliveryUnitPriceIncluetax(ComputeUtil.safeDiv(deliveryAmountIncluetax,deliveryQuantity));//本期出库含税单价
                gatherSendVO.setDeliveryUnitPriceExcluetax(ComputeUtil.safeDiv(deliveryAmountExcluetax,deliveryQuantity));//本期出库不含税单价


             /*   gatherSendVO.setQuantity(ComputeUtil.safeSub(enterQuantity,deliveryQuantity)); //本期结存数量 不含上期
                gatherSendVO.setAmountIncluetax(ComputeUtil.safeSub(enterAmountIncluetax,deliveryAmountIncluetax)); //本期结存含税金额 不含上期
                gatherSendVO.setAmountExcluetax(ComputeUtil.safeSub(enterAmountExcluetax,deliveryAmountExcluetax)); //本期结存无税金额 不含上期
                gatherSendVO.setUnitPriceIncluetax(ComputeUtil.safeDiv( gatherSendVO.getAmountIncluetax(),gatherSendVO.getQuantity())); //本期结存含税单价 不含上期
                gatherSendVO.setUnitPriceExcluetax(ComputeUtil.safeDiv( gatherSendVO.getAmountExcluetax(),gatherSendVO.getQuantity())); //本期结存无税单价 不含上期*/

                gatherSendVOList1.add(gatherSendVO);
            }

        }
        //筛入本期入本期出
        if(CollectionUtils.isNotEmpty(gatherSendVOList1)){
            Map<Long,GatherSendVO> maps = gatherSendVOList1.stream().collect(Collectors.toMap(x->x.getProjectId()+x.getMaterialId()+x.getStoreId(), Function.identity(),(k1, k2) ->k2));
            GatherSendVO cvo;
            Long k;
            for (GatherSendVO vo : gatherSendVOList) {
                k=vo.getProjectId()+vo.getMaterialId()+vo.getStoreId();
                if (maps.containsKey(k)){
                    cvo = maps.get(k);

                    vo.setEnterQuantity(cvo.getEnterQuantity());//本期入库数量
                    vo.setEnterUnitPriceIncluetax(cvo.getEnterUnitPriceIncluetax());//本期入库含税单价
                    vo.setEnterUnitPriceExcluetax(cvo.getEnterUnitPriceExcluetax());//本期入库不含税单价
                    vo.setEnterAmountIncluetax(cvo.getEnterAmountIncluetax());//本期入库含税金额
                    vo.setEnterAmountExcluetax(cvo.getEnterAmountExcluetax());//本期入库无税金额

                    vo.setDeliveryQuantity(cvo.getDeliveryQuantity());//本期出库数量
                    vo.setDeliveryUnitPriceIncluetax(cvo.getDeliveryUnitPriceIncluetax());//本期出库含税单价
                    vo.setDeliveryUnitPriceExcluetax(cvo.getDeliveryUnitPriceExcluetax());//本期出库不含税单价
                    vo.setDeliveryAmountIncluetax(cvo.getDeliveryAmountIncluetax());//本期出库含税金额
                    vo.setDeliveryAmountExcluetax(cvo.getDeliveryAmountExcluetax());//本期出库无税金额

                  /*  private BigDecimal currentQuantity;//上月结存数量
                    private BigDecimal currentUnitPriceTax;//上月结存含税单价
                    private BigDecimal currentUnitPriceUntax;//上月结存不含税单价
                    private BigDecimal currentAmountTax;//上月结存含税金额
                    private BigDecimal currentAmountEntax;//上月结存不含税金额*/
                    //本期结存：上期+本期入-本期出


                }
            }
        }

        if(CollectionUtils.isNotEmpty(gatherSendVOList)){
            for (GatherSendVO vo : gatherSendVOList) {
                vo.setQuantity(ComputeUtil.safeSub(ComputeUtil.safeAdd(vo.getCurrentQuantity(),vo.getEnterQuantity()),vo.getDeliveryQuantity()));
                vo.setAmountIncluetax(ComputeUtil.safeSub(ComputeUtil.safeAdd(vo.getCurrentAmountTax(),vo.getEnterAmountIncluetax()),vo.getDeliveryAmountIncluetax()));//本期结存含税金额
                vo.setAmountExcluetax(ComputeUtil.safeSub(ComputeUtil.safeAdd(vo.getCurrentAmountEntax(),vo.getEnterAmountExcluetax()),vo.getDeliveryAmountExcluetax()));//本期结存不含税金额
                vo.setUnitPriceIncluetax(ComputeUtil.safeDiv(vo.getAmountIncluetax(),vo.getQuantity()));//本期结存含税单价
                vo.setUnitPriceExcluetax(ComputeUtil.safeDiv(vo.getAmountExcluetax(),vo.getQuantity()));//本期结存无税单价
            }
        }
        return gatherSendVOList;
    }
}
