package com.ejianc.business.outputValue.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaEntity;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueChangeEntity;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueRecordEntity;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueChangeService;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueRecordService;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueService;
import com.ejianc.business.outputValue.vo.CompanyUndertakeQuotaChangeVO;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueChangeVO;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 工厂月度实际产值
 *
 */
@RestController
@RequestMapping("/pMonthActualOutputValueChange/")
public class PcMonthActualOutputValueChangeController {

	@Autowired
	private IPcMonthActualOutputValueService pcMonthActualOutputValueService;
	@Autowired
	private IPcMonthActualOutputValueChangeService changeService;
	@Autowired
	private IPcMonthActualOutputValueRecordService recordService;

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PcMonthActualOutputValueChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgShortName");
        fuzzyFields.add("year");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(param.getParams().get("dataId")==null){
        	throw new BusinessException("缺少公司经营指标id");
        }
        IPage<PcMonthActualOutputValueChangeEntity> page = changeService.queryPage(param,false);
        IPage<PcMonthActualOutputValueChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PcMonthActualOutputValueChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByDataId")
    public CommonResponse<PcMonthActualOutputValueChangeVO> queryDetailByDataId(@RequestParam(value = "dataId") Long dataId) {
        PcMonthActualOutputValueEntity projectEntity = pcMonthActualOutputValueService.selectById(dataId);
        PcMonthActualOutputValueChangeVO changeVO = BeanMapper.map(projectEntity, PcMonthActualOutputValueChangeVO.class);
        changeVO.setDataId(dataId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(null);
        changeVO.setUpdateUserCode(null);
        return CommonResponse.success("查询详情成功！", changeVO);
    	
    }
    
    /**
     * 查询变更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetail")
    public CommonResponse<PcMonthActualOutputValueChangeVO> queryDetail(@RequestParam(value = "id") Long id) {
        PcMonthActualOutputValueChangeEntity entity = changeService.selectById(id);
        PcMonthActualOutputValueChangeVO vo = BeanMapper.map(entity, PcMonthActualOutputValueChangeVO.class);

        //当前单据变更过则显示变更记录
//        QueryWrapper<PcMonthActualOutputValueRecordEntity> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("dr", 0);
//        queryWrapper.eq("data_id", vo.getDataId());
//        List<PcMonthActualOutputValueRecordEntity> records = recordService.list(queryWrapper);
//        if(records!=null&&records.size()>0){
//            vo.setRecordList(BeanMapper.mapList(records, PcMonthActualOutputValueRecordVO.class));
//        }
        return CommonResponse.success("查询详情成功！", vo);
    	
    }

    /**
     * 项目申请保存/更新
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "saveChange")
    public CommonResponse<PcMonthActualOutputValueChangeVO> saveChange(@RequestBody PcMonthActualOutputValueChangeVO vo) {
    	return changeService.saveChange(vo);
    	
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PcMonthActualOutputValueChangeVO> vos) {
        return changeService.delete(vos);
    }

}
