package com.ejianc.business.outputValue.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueChangeEntity;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueRecordEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaEntity;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueChangeService;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueRecordService;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueService;
import com.ejianc.business.outputValue.utils.OutputValueUtils;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueChangeVO;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueRecordVO;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * 项目月度计划产值
 *
 */
@RestController
@RequestMapping("/projectMonthActualOutputValueChange/")
public class ProjectMonthActualOutputValueChangeController {

    @Autowired
    private IProjectMonthActualOutputValueService projectMonthActualOutputValueService;
    @Autowired
    private IProjectMonthActualOutputValueChangeService changeService;
	@Autowired
	private IProjectMonthActualOutputValueRecordService recordService;

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectMonthActualOutputValueChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgShortName");
        fuzzyFields.add("year");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(param.getParams().get("dataId")==null){
        	throw new BusinessException("缺少公司经营指标id");
        }
        IPage<ProjectMonthActualOutputValueChangeEntity> page = changeService.queryPage(param,false);
        IPage<ProjectMonthActualOutputValueChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectMonthActualOutputValueChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByDataId")
    public CommonResponse<ProjectMonthActualOutputValueChangeVO> queryDetailByDataId(@RequestParam(value = "dataId") Long dataId) {
        ProjectMonthActualOutputValueEntity projectEntity = projectMonthActualOutputValueService.selectById(dataId);
        ProjectMonthActualOutputValueVO projectVO = projectMonthActualOutputValueService.queryOtherInfoByProjectId(projectEntity.getProjectId(), projectEntity.getYear(), projectEntity.getMonth(), dataId);
        ProjectMonthActualOutputValueChangeVO changeVO = BeanMapper.map(projectEntity, ProjectMonthActualOutputValueChangeVO.class);
        changeVO.setDataId(dataId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(null);
        changeVO.setUpdateUserCode(null);

        changeVO.setLastAllMonthActualOutputValue(projectVO.getThisMonthActualOutputValue()); // 本年到上月项目累计完成产值（万元）
        changeVO.setLastAllMonthConfirmedOutputValue(projectVO.getThisMonthConfirmedOutputValue()); // 本年到上月项目累计确认产值（万元）
        changeVO.setThisYearAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(projectVO.getThisMonthActualOutputValue(), projectEntity.getThisMonthActualOutputValue())); // 本年累计完成产值（万元）
        changeVO.setThisYearConfirmedOutputValue(CommonUtils.addBigDecimal(projectVO.getThisMonthConfirmedOutputValue(), projectEntity.getThisMonthConfirmedOutputValue())); // 本年累计确认产值（万元）
        changeVO.setProjectAccumulatedCompletedOutputValue(CommonUtils.addBigDecimal(projectVO.getThisMonthActualOutputValue(), projectEntity.getThisMonthActualOutputValue())); // 项目累计完成产值（万元）
        changeVO.setProjectAccumulatedConfirmedOutputValue(CommonUtils.addBigDecimal(projectVO.getThisMonthConfirmedOutputValue(), projectEntity.getThisMonthConfirmedOutputValue())); // 项目累计确认产值（万元）
        // 本月商务系统实际完成产值（万元）
        changeVO.setThisMonthCommerceActualCompletedOutputValue(projectVO.getThisMonthCommerceActualCompletedOutputValue());
        changeVO.setYearTargetOutputValue(projectVO.getYearTargetOutputValue()); // '年度目标产值'--
        changeVO.setYearTargetOutputValueMargin(projectVO.getYearTargetOutputValueMargin());
        return CommonResponse.success("查询详情成功！", changeVO);
    	
    }
    
    /**
     * 查询变更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetail")
    public CommonResponse<ProjectMonthActualOutputValueChangeVO> queryDetail(@RequestParam(value = "id") Long id) {
        ProjectMonthActualOutputValueChangeEntity entity = changeService.selectById(id);
        ProjectMonthActualOutputValueChangeVO vo = BeanMapper.map(entity, ProjectMonthActualOutputValueChangeVO.class);

        //当前单据变更过则显示变更记录
//        QueryWrapper<ProjectMonthActualOutputValueRecordEntity> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("dr", 0);
//        queryWrapper.eq("data_id", vo.getDataId());
//        List<ProjectMonthActualOutputValueRecordEntity> records = recordService.list(queryWrapper);
//        if(records!=null&&records.size()>0){
//            vo.setRecordList(BeanMapper.mapList(records, ProjectMonthActualOutputValueRecordVO.class));
//        }
        return CommonResponse.success("查询详情成功！", vo);
    	
    }

    /**
     * 项目申请保存/更新
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "saveChange")
    public CommonResponse<ProjectMonthActualOutputValueChangeVO> saveChange(@RequestBody ProjectMonthActualOutputValueChangeVO vo) {
    	return changeService.saveChange(vo);
    	
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectMonthActualOutputValueChangeVO> vos) {
        return changeService.delete(vos);
    }

}
