package com.ejianc.business.outputValue.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueRecordEntity;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueRecordService;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueService;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueRecordVO;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目月度计划产值
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectMonthActualOutputValue")
public class ProjectMonthActualOutputValueController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProjectMonthActualOutputValueService service;
    @Autowired
    private IProjectMonthActualOutputValueRecordService recordService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectMonthActualOutputValueVO> saveOrUpdate(@RequestBody ProjectMonthActualOutputValueVO saveorUpdateVO) {
        ProjectMonthActualOutputValueEntity entity = BeanMapper.map(saveorUpdateVO, ProjectMonthActualOutputValueEntity.class);

        QueryWrapper<ProjectMonthActualOutputValueEntity> wrapper = new QueryWrapper<>();
        if(entity.getId() != null){
            wrapper.ne("id", entity.getId());
        }
        wrapper.eq("year", entity.getYear());
        wrapper.eq("month", entity.getMonth());
        wrapper.eq("project_id", entity.getProjectId());
        Integer count = service.count(wrapper);
        if(count>0){
            throw new BusinessException("该项目本年本月已存在项目月度计划产值！");
        }

        //获取二级组织
        CommonResponse<OrgVO> orgResponse = iOrgApi.detailById(saveorUpdateVO.getOrgId());
        if(orgResponse.isSuccess() && orgResponse.getData()!=null){
            String innerCode = orgResponse.getData().getInnerCode();
            String[] orgIds = innerCode.split("|");
            if(orgIds.length>1){
                Long twoOrgId = Long.parseLong(orgIds[1]); // 二级组织
                String twoOrgName = null; // 二级组织名称
                CommonResponse<OrgVO> twoOrgResponse = iOrgApi.detailById(twoOrgId);
                if(twoOrgResponse.isSuccess() && twoOrgResponse.getData()!=null){
                    twoOrgName = twoOrgResponse.getData().getName();
                }
                entity.setTwoOrgId(twoOrgId);
                entity.setTwoOrgName(twoOrgName);
            }
        }
        if(StringUtils.isBlank(entity.getChangeState())){
            entity.setChangeState("1");//未变更
        }
    	service.saveOrUpdate(entity, false);
        ProjectMonthActualOutputValueVO vo = BeanMapper.map(entity, ProjectMonthActualOutputValueVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectMonthActualOutputValueVO> queryDetail(Long id) {
        ProjectMonthActualOutputValueEntity entity = service.selectById(id);
        ProjectMonthActualOutputValueVO vo = BeanMapper.map(entity, ProjectMonthActualOutputValueVO.class);

        //当前单据变更过则显示变更记录
        QueryWrapper<ProjectMonthActualOutputValueRecordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("data_id", id);
        List<ProjectMonthActualOutputValueRecordEntity> records = recordService.list(queryWrapper);
        if(records!=null&&records.size()>0){
            vo.setRecordList(BeanMapper.mapList(records, ProjectMonthActualOutputValueRecordVO.class));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectMonthActualOutputValueVO> vos) {
        service.removeByIds(vos.stream().map(ProjectMonthActualOutputValueVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectMonthActualOutputValueVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("twoOrgName");
        fuzzyFields.add("year");
        fuzzyFields.add("month");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<ProjectMonthActualOutputValueEntity> page = service.queryPage(param,false);
        IPage<ProjectMonthActualOutputValueVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectMonthActualOutputValueVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description queryOtherInfo 根据项目，年度查询本年累计值+实际完成产值
     * @param
     */
    @RequestMapping(value = "/queryOtherInfoByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectMonthActualOutputValueVO> queryOtherInfoByProjectId(@RequestParam(required = true) Long projectId,
        @RequestParam(required = true) String year, @RequestParam(required = true) String month, @RequestParam(required = false) Long id) {
        ProjectMonthActualOutputValueVO vo = service.queryOtherInfoByProjectId(projectId, year, month, id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
