package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaChangeEntity;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaEntity;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaRecordEntity;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaChangeService;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaRecordService;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("companyBusinessQuotaChange")
public class CompanyBusinessQuotaChangeBpmServiceImpl implements ICommonBusinessService {
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String COMPANYBUSINESSQUOTA_SOURCETYPE = "companyBusinessQuota";//合同
    private static final String COMPANYBUSINESSQUOTA_CHANGE_SOURCETYPE = "companyBusinessQuotaChange";//变更
    private static final String COMPANYBUSINESSQUOTA_RECORD_SOURCETYPE = "companyBusinessQuotaRecord";//记录

    private static final String COMPANYBUSINESSQUOTA_BILLTYPE_CODE = "EJCBT202411000003";
    private static final String COMPANYBUSINESSQUOTA_CHANGE_BILLTYPE_CODE = "EJCBT202411000009";
    private static final String COMPANYBUSINESSQUOTA_RECORD_BILLTYPE_CODE = "EJCBT202411000010";

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ICompanyBusinessQuotaService companyBusinessQuotaService;
	@Autowired
	private ICompanyBusinessQuotaChangeService changeService;

    @Autowired
    private ICompanyBusinessQuotaRecordService recordService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}
	
	public void clearBaseData(BaseEntity entity){
//		entity.setCreateTime(null);
//		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前合同信息、变更信息
		CompanyBusinessQuotaChangeEntity changeEntity = changeService.selectById(billId);
		CompanyBusinessQuotaEntity companyBusinessQuotaEntity = companyBusinessQuotaService.selectById(changeEntity.getDataId());

		//获取历史版本条数
		QueryWrapper<CompanyBusinessQuotaRecordEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("data_id", companyBusinessQuotaEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordService.count(recordWrapper);
		//2、生成历史版本
		//2.1、
		CompanyBusinessQuotaRecordEntity recordEntity = BeanMapper.map(companyBusinessQuotaEntity, CompanyBusinessQuotaRecordEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordEntity);
		recordEntity.setBillState(null);
		recordEntity.setDataId(companyBusinessQuotaEntity.getId());
		recordEntity.setBillVersion(String.valueOf(count+1));
		recordEntity.setId(recordId);
		recordEntity.setChangeReason(changeEntity.getChangeReason());

		//复制合同附件信息到记录中
		String sourceBillType = COMPANYBUSINESSQUOTA_BILLTYPE_CODE;
		String targetBillType = COMPANYBUSINESSQUOTA_RECORD_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(companyBusinessQuotaEntity.getId().toString(), sourceBillType, COMPANYBUSINESSQUOTA_SOURCETYPE, recordId.toString(), targetBillType, COMPANYBUSINESSQUOTA_RECORD_SOURCETYPE);
		recordService.saveOrUpdate(recordEntity, false);
		logger.info("---------生成合同信息完成--------");
		//3、修改当前合同信息
		CompanyBusinessQuotaEntity newContractEntity = BeanMapper.map(changeEntity, CompanyBusinessQuotaEntity.class);
		newContractEntity.setChangeState("3");//状态改为已变更
		newContractEntity.setChangeId(null);
		newContractEntity.setBillCode(companyBusinessQuotaEntity.getBillCode());
		newContractEntity.setBillState(companyBusinessQuotaEntity.getBillState());
		newContractEntity.setId(companyBusinessQuotaEntity.getId());
		newContractEntity.setCreateTime(companyBusinessQuotaEntity.getCreateTime());
		newContractEntity.setCreateUserCode(companyBusinessQuotaEntity.getCreateUserCode());
		newContractEntity.setTenantId(companyBusinessQuotaEntity.getTenantId());
		newContractEntity.setVersion(companyBusinessQuotaEntity.getVersion());
		newContractEntity.setEffectLastDate(new Date());
		companyBusinessQuotaService.saveOrUpdate(newContractEntity, false);
		//复制合同附件信息到记录中
		sourceBillType = COMPANYBUSINESSQUOTA_CHANGE_BILLTYPE_CODE;
		targetBillType = COMPANYBUSINESSQUOTA_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, COMPANYBUSINESSQUOTA_CHANGE_SOURCETYPE, companyBusinessQuotaEntity.getId().toString(), targetBillType, COMPANYBUSINESSQUOTA_SOURCETYPE);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单不允许弃审");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
