package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.ProjectSupplementChangeEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementRecordEntity;
import com.ejianc.business.outputValue.mapper.ProjectSupplementChangeMapper;
import com.ejianc.business.outputValue.service.IProjectSupplementChangeService;
import com.ejianc.business.outputValue.service.IProjectSupplementRecordService;
import com.ejianc.business.outputValue.service.IProjectSupplementService;
import com.ejianc.business.outputValue.vo.ProjectSupplementChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目信息补充与维护
 * 
 * @author generator
 * 
 */
@Service("projectSupplementChangeService")
public class ProjectSupplementChangeServiceImpl extends BaseServiceImpl<ProjectSupplementChangeMapper, ProjectSupplementChangeEntity> implements IProjectSupplementChangeService {

    @Autowired
    private IProjectSupplementService projectSupplementService;
    @Autowired
    private IProjectSupplementRecordService recordService;
    @Override
    public CommonResponse<ProjectSupplementChangeVO> saveChange(ProjectSupplementChangeVO saveorUpdateVO) {
        ProjectSupplementChangeEntity entity = BeanMapper.map(saveorUpdateVO, ProjectSupplementChangeEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ProjectSupplementChangeEntity> queryWrapper = new QueryWrapper<ProjectSupplementChangeEntity>();
        queryWrapper.eq("data_id", saveorUpdateVO.getDataId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 0,4);
        if(saveorUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<ProjectSupplementChangeEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }
        this.saveOrUpdate(entity, false);
        ProjectSupplementChangeVO vo = BeanMapper.map(entity, ProjectSupplementChangeVO.class);
        vo.setRecordList(saveorUpdateVO.getRecordList());
        //查询当前合同信息，将状态改为变更中
        ProjectSupplementEntity projectSupplementEntity = projectSupplementService.selectById(vo.getDataId());
        projectSupplementEntity.setChangeState("2");//状态改为变更中
        projectSupplementEntity.setChangeId(vo.getId());
        projectSupplementService.saveOrUpdate(projectSupplementEntity, false);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<ProjectSupplementChangeVO> vos) {
        for(ProjectSupplementChangeVO vo : vos){
            ProjectSupplementChangeEntity entity = this.getById(vo.getId());
            ProjectSupplementEntity projectSupplementEntity = projectSupplementService.selectById(entity.getDataId());
            QueryWrapper<ProjectSupplementRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("data_id", projectSupplementEntity.getId());
            List<ProjectSupplementRecordEntity> records = recordService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                projectSupplementEntity.setChangeState("3");//状态改为已变更
            }else{
                projectSupplementEntity.setChangeState("1");//状态改为未变更
            }
            projectSupplementEntity.setChangeId(null);
            projectSupplementService.saveOrUpdate(projectSupplementEntity, false);
        }
        this.removeByIds(vos.stream().map(ProjectSupplementChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
