package com.ejianc.business.outputValue.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目/工厂年度经营指标（产值）
 *
 * @author generator
 *
 */
public class ProjectPcYearBusinessQuotaChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String changeReason; // 变更原因
    private Long dataId; // 项目补充信息id
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long twoOrgId; // 二级组织
    private String twoOrgName; // 二级组织名称
    private String year; // 年度
    private BigDecimal yearPlanOutputValue; //年度计划产值（万元）
    private BigDecimal totalPlanOutputValue; //总计划产值（万元）
    private BigDecimal januaryPlanOutputValue; //1月计划产值（万元）
    private BigDecimal februaryPlanOutputValue; //2月计划产值（万元）
    private BigDecimal marchPlanOutputValue; //3月计划产值（万元）
    private BigDecimal aprilPlanOutputValue; //4月计划产值（万元）
    private BigDecimal mayPlanOutputValue; //5月计划产值（万元）
    private BigDecimal junePlanOutputValue; //6月计划产值（万元）
    private BigDecimal julyPlanOutputValue; //7月计划产值（万元）
    private BigDecimal augustPlanOutputValue; //8月计划产值（万元）
    private BigDecimal septemberPlanOutputValue; //9月计划产值（万元）
    private BigDecimal octoberPlanOutputValue; //10月计划产值（万元）
    private BigDecimal novemberPlanOutputValue; //11月计划产值（万元）
    private BigDecimal decemberPlanOutputValue; //12月计划产值（万元）
    private String remarks; // 备注

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date effectLastDate; // 最后生效日期

    private List<ProjectPcYearBusinessQuotaRecordVO> recordList = new ArrayList<>();

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Long getDataId() {
        return dataId;
    }

    public void setDataId(Long dataId) {
        this.dataId = dataId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }

    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public BigDecimal getYearPlanOutputValue() {
        return yearPlanOutputValue;
    }

    public void setYearPlanOutputValue(BigDecimal yearPlanOutputValue) {
        this.yearPlanOutputValue = yearPlanOutputValue;
    }

    public BigDecimal getTotalPlanOutputValue() {
        return totalPlanOutputValue;
    }

    public void setTotalPlanOutputValue(BigDecimal totalPlanOutputValue) {
        this.totalPlanOutputValue = totalPlanOutputValue;
    }

    public BigDecimal getJanuaryPlanOutputValue() {
        return januaryPlanOutputValue;
    }

    public void setJanuaryPlanOutputValue(BigDecimal januaryPlanOutputValue) {
        this.januaryPlanOutputValue = januaryPlanOutputValue;
    }

    public BigDecimal getFebruaryPlanOutputValue() {
        return februaryPlanOutputValue;
    }

    public void setFebruaryPlanOutputValue(BigDecimal februaryPlanOutputValue) {
        this.februaryPlanOutputValue = februaryPlanOutputValue;
    }

    public BigDecimal getMarchPlanOutputValue() {
        return marchPlanOutputValue;
    }

    public void setMarchPlanOutputValue(BigDecimal marchPlanOutputValue) {
        this.marchPlanOutputValue = marchPlanOutputValue;
    }

    public BigDecimal getAprilPlanOutputValue() {
        return aprilPlanOutputValue;
    }

    public void setAprilPlanOutputValue(BigDecimal aprilPlanOutputValue) {
        this.aprilPlanOutputValue = aprilPlanOutputValue;
    }

    public BigDecimal getMayPlanOutputValue() {
        return mayPlanOutputValue;
    }

    public void setMayPlanOutputValue(BigDecimal mayPlanOutputValue) {
        this.mayPlanOutputValue = mayPlanOutputValue;
    }

    public BigDecimal getJunePlanOutputValue() {
        return junePlanOutputValue;
    }

    public void setJunePlanOutputValue(BigDecimal junePlanOutputValue) {
        this.junePlanOutputValue = junePlanOutputValue;
    }

    public BigDecimal getJulyPlanOutputValue() {
        return julyPlanOutputValue;
    }

    public void setJulyPlanOutputValue(BigDecimal julyPlanOutputValue) {
        this.julyPlanOutputValue = julyPlanOutputValue;
    }

    public BigDecimal getAugustPlanOutputValue() {
        return augustPlanOutputValue;
    }

    public void setAugustPlanOutputValue(BigDecimal augustPlanOutputValue) {
        this.augustPlanOutputValue = augustPlanOutputValue;
    }

    public BigDecimal getSeptemberPlanOutputValue() {
        return septemberPlanOutputValue;
    }

    public void setSeptemberPlanOutputValue(BigDecimal septemberPlanOutputValue) {
        this.septemberPlanOutputValue = septemberPlanOutputValue;
    }

    public BigDecimal getOctoberPlanOutputValue() {
        return octoberPlanOutputValue;
    }

    public void setOctoberPlanOutputValue(BigDecimal octoberPlanOutputValue) {
        this.octoberPlanOutputValue = octoberPlanOutputValue;
    }

    public BigDecimal getNovemberPlanOutputValue() {
        return novemberPlanOutputValue;
    }

    public void setNovemberPlanOutputValue(BigDecimal novemberPlanOutputValue) {
        this.novemberPlanOutputValue = novemberPlanOutputValue;
    }

    public BigDecimal getDecemberPlanOutputValue() {
        return decemberPlanOutputValue;
    }

    public void setDecemberPlanOutputValue(BigDecimal decemberPlanOutputValue) {
        this.decemberPlanOutputValue = decemberPlanOutputValue;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Date getEffectLastDate() {
        return effectLastDate;
    }

    public void setEffectLastDate(Date effectLastDate) {
        this.effectLastDate = effectLastDate;
    }

    public List<ProjectPcYearBusinessQuotaRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<ProjectPcYearBusinessQuotaRecordVO> recordList) {
        this.recordList = recordList;
    }
}
