package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.DeliveryrecordEntity;
import com.ejianc.business.material.bean.DeliveryrecorddetailEntity;
import com.ejianc.business.material.bean.RealtimebalanceEntity;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.service.IDeliveryrecordService;
import com.ejianc.business.material.service.IDeliveryrecorddetailService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.RealtimebalanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.wzxt.plan.api.IPlanApi;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 实时物资结存表
 *
 * @author generator
 */
@Controller
@RequestMapping("realtimebalance")
public class RealtimebalanceController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IStoreService storeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRealtimebalanceService service;
    @Autowired
    private IPlanApi planApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDeliveryrecordService deliveryrecordService;
    @Autowired
    private IDeliveryrecorddetailService deliveryrecorddetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RealtimebalanceVO> saveOrUpdate(@RequestBody RealtimebalanceVO saveOrUpdateVO) {
        RealtimebalanceEntity entity = BeanMapper.map(saveOrUpdateVO, RealtimebalanceEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        RealtimebalanceVO vo = BeanMapper.map(entity, RealtimebalanceVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RealtimebalanceVO> queryDetail(Long id) {
        RealtimebalanceEntity entity = service.selectById(id);
        RealtimebalanceVO vo = BeanMapper.map(entity, RealtimebalanceVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RealtimebalanceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RealtimebalanceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(RealtimebalanceVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RealtimebalanceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<RealtimebalanceEntity> page = service.queryPage(param, false);
        IPage<RealtimebalanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RealtimebalanceVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<RealtimebalanceEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Realtimebalance-export.xlsx", beans, response);
    }


    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRealtimebalanceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RealtimebalanceVO>> refRealtimebalanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition, @RequestParam(required = false) String relyCondition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        String selfStateValue = "";
        Long subContractIdValue = null;
        Long projectIdValue = null;
        Long storeIdValue = null;
        if (StringUtils.isNotEmpty(relyCondition)) {
            storeIdValue = Long.parseLong(relyCondition.split("=")[1]);
            /** 处理condition */
            param.getParams().put("storeId", new Parameter(QueryParam.EQ, storeIdValue));
        }
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            String projectId = _con.getString("projectId");
            String storeId = _con.getString("storeId");
            String selfState = _con.getString("selfState");
            String subContractId = _con.getString("subContractId");

            if (projectId != null && !projectId.isEmpty()) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
                param.getParams().put("quantity", new Parameter(QueryParam.GT, new BigDecimal(0.00)));
                projectIdValue = Long.parseLong(_con.get("projectId").toString());
            }
            if (storeId != null && !storeId.isEmpty()) {
                storeIdValue = Long.valueOf(storeId);
                param.getParams().put("storeId", new Parameter(QueryParam.EQ, _con.get("storeId")));
            }
            if (selfState != null && !selfState.isEmpty()) {
                selfStateValue = _con.get("selfState").toString();
            }
            if (subContractId != null && !subContractId.isEmpty()) {
                subContractIdValue = Long.parseLong(_con.get("subContractId").toString());
            }
        }

        IPage<RealtimebalanceEntity> page = service.queryPage(param, false);
        IPage<RealtimebalanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<RealtimebalanceVO> realtimebalanceVOS = BeanMapper.mapList(page.getRecords(), RealtimebalanceVO.class);
        if (selfStateValue.equals("否")) {
            //获取计划量
            CommonResponse<Map<Long, BigDecimal>> materialPLanByProjectId = planApi.getMaterialPLanByProjectId(projectIdValue, subContractIdValue);
            if (!materialPLanByProjectId.isSuccess()) {
                throw new BusinessException("获取计划信息失败");
            }
            Map<Long, BigDecimal> pLanByProjectIdMap = materialPLanByProjectId.getData();

            //获取项目下供应商下出库数量
            LambdaQueryWrapper<DeliveryrecordEntity> lambdaQueryWrapper = Wrappers.<DeliveryrecordEntity>lambdaQuery();
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getProjectId, projectIdValue);
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getPickingunitId, subContractIdValue);
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getSelfState, "否");
            lambdaQueryWrapper.in(DeliveryrecordEntity::getBillState, 1, 3);
            List<DeliveryrecordEntity> deliveryrecordEntities = deliveryrecordService.list(lambdaQueryWrapper);
            Map<Long, BigDecimal> numMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(deliveryrecordEntities)) {
                List<Long> ids = deliveryrecordEntities.stream().map(DeliveryrecordEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper<DeliveryrecorddetailEntity> lambdaQuery = Wrappers.<DeliveryrecorddetailEntity>lambdaQuery();
                lambdaQuery.in(DeliveryrecorddetailEntity::getMid, ids);
                List<DeliveryrecorddetailEntity> deliveryrecorddetailEntities = deliveryrecorddetailService.list(lambdaQuery);
                if (CollectionUtils.isNotEmpty(deliveryrecorddetailEntities)) {
                    numMap = deliveryrecorddetailEntities.stream().collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getMaterialId,
                            Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                }
            }

            if (CollectionUtils.isNotEmpty(realtimebalanceVOS)) {
                //设置计划数量
                for (RealtimebalanceVO realtimebalanceVO : realtimebalanceVOS) {
                    if (pLanByProjectIdMap.containsKey(realtimebalanceVO.getMaterialId())) {
                        BigDecimal planNum = pLanByProjectIdMap.get(realtimebalanceVO.getMaterialId());
                        realtimebalanceVO.setPlanNum(planNum);
                        if (numMap.containsKey(realtimebalanceVO.getMaterialId())) {
                            BigDecimal outNum = numMap.get(realtimebalanceVO.getMaterialId());
                            realtimebalanceVO.setPlanSurplusNum(ComputeUtil.safeSub(realtimebalanceVO.getPlanNum(), outNum));
                        } else {
                            realtimebalanceVO.setPlanSurplusNum(realtimebalanceVO.getPlanNum());

                        }

                    }


                }

            }
        }

        if (null != storeIdValue) {
            StoreEntity storeEntity = storeService.getById(storeIdValue);
            for (RealtimebalanceVO balanceVO : realtimebalanceVOS) {
                balanceVO.setStoreType(storeEntity.getStoreType());
//                仓库类型 0-成品库 1-废旧物资库 2-资产库
                if (storeEntity.getStoreType() == 0) {
                    balanceVO.setStoreTypeName("成品库");
                }
                if (storeEntity.getStoreType() == 1) {
                    balanceVO.setStoreTypeName("废旧物资库");
                }
                if (storeEntity.getStoreType() == 2) {
                    balanceVO.setStoreTypeName("资产库");
                }
            }
        }

        pageData.setRecords(realtimebalanceVOS);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 查询仓库该物资的单价
     *
     * @param projectId            项目id
     * @param storeId              仓库id
     * @param materialCategoryCode 物资分类编码
     * @param materialCode         物资编码
     * @return
     */
    @RequestMapping(value = "/refUnitPrice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> refUnitPrice(Long projectId, String storeId, String materialCategoryCode, String materialCode) {
        JSONObject jsonObject = new JSONObject();
        QueryWrapper<RealtimebalanceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("material_code", materialCode);
        queryWrapper.eq("material_category_code", materialCategoryCode);
        queryWrapper.eq("store_id", storeId);
        RealtimebalanceEntity one = service.getOne(queryWrapper);
        if (one != null) {
            jsonObject.put("unitPriceIncluetax", one.getUnitPriceIncluetax());
            jsonObject.put("unitPriceExcluetax", one.getUnitPriceExcluetax());
        }
        return CommonResponse.success("查询成功!", jsonObject);
    }
}
