package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.*;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.material.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.DeliveryrecordMapper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.math.BigDecimal;
import java.util.stream.Collectors;

/**
 * 物资出库记录
 * 
 * @author generator
 * 
 */
@Service("deliveryrecordService")
public class DeliveryrecordServiceImpl extends BaseServiceImpl<DeliveryrecordMapper, DeliveryrecordEntity> implements IDeliveryrecordService{

    @Autowired
    private DeliveryrecordMapper deliveryrecordMapper;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private JedisPool jedisPool;
    private static final String BILL_TYPE_CODE = "HZBT202208000016";//此处需要根据实际修改
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ICheckService checkService;



    @Autowired
    private DeliveryrecordBpmServiceImpl deliveryrecordBpmService;
    @Autowired
    private MaterialWarehousingBpmServiceImpl materialWarehousingBpmService;
    @Autowired
    private IDeliveryrecorddetailService deliveryrecorddetailService;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private ISystemDataPushService systemDataPushService;




    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IProSupplierApi proSupplierApi;

    private static final String BILL_TYPE = "HZBT202208000016";//此处需要根据实际修改



//    @Autowired
//    private IPushMessageApi pushMessageApi;

    private final String OPERATE = "DELIVERY_RECORD_SYNC";

    private final String PUSH_BILL_SERVER_URL = "/zjkj-supbusiness-web/openapi/deliveryrecord/saveOrUpdate";


    @Override
    public List<DeliveryrecordSubVO> selectSub(String materialCode, String projectId) {
        List<DeliveryrecordSubVO> list = deliveryrecordMapper.selectSub(materialCode,projectId);
        return list;
    }

    @Override
    public List<DeliveryrecordReportVO> subDetail(Long projectId,String materialCode,String supplierName) {
        List<DeliveryrecordReportVO> deliveryrecordReportVOS = deliveryrecordMapper.subDetail(projectId, materialCode, supplierName);
        return deliveryrecordReportVOS;
    }
    @Transactional
    @Override
    public DeliveryrecordVO saveOrUpdate(DeliveryrecordVO saveorUpdateVO) {

        DeliveryrecordEntity entity = BeanMapper.map(saveorUpdateVO, DeliveryrecordEntity.class);

        //保存检验 例子: 如果有5月份的盘点表(包括自由态), 那么做出库单时就只能录入5月份之后的数据, 之前的月份不能再录入入库单
        if(entity.getDeliveryTypes() == 0 || entity.getDeliveryTypes() == 4){
            String puinTime = new SimpleDateFormat("yyyy-MM").format(entity.getPickingTime());
            LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(CheckEntity::getProjectId, entity.getProjectId());
            queryWrapper.eq(CheckEntity::getStoreId, entity.getStoreId());
            queryWrapper.apply("DATE_FORMAT(check_month, '%Y-%m') >= '" + puinTime + "'");
            List<CheckEntity> checkEntities = checkService.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(checkEntities)){
                throw new BusinessException("所选领料日期当期或之后已经生成领用物资剩余数量盘点表,不能新增!");
            }
        }


        if ((entity.getDeliveryTypes() == 0 || entity.getDeliveryTypes() == 4) && entity.getSelfState().equals("否")){
            entity.setSignStatus(1);
        }
        List<DeliveryrecorddetailEntity> deliveryrecorddetailList = entity.getDeliveryrecorddetailEntities();
        BigDecimal outMny = deliveryrecorddetailList.stream().map(DeliveryrecorddetailEntity::getAmountExcluetax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal outMnyTax = deliveryrecorddetailList.stream().map(DeliveryrecorddetailEntity::getAmountIncluetax).reduce(BigDecimal.ZERO, BigDecimal::add);
        entity.setOutMny(outMny);
        entity.setOutMnyTax(outMnyTax);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setDeliveryType(1);
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        List<DeliveryrecorddetailEntity> deliveryrecorddetailEntities = entity.getDeliveryrecorddetailEntities();

        for (DeliveryrecorddetailEntity deliveryrecorddetail:deliveryrecorddetailEntities){
            if("del".equals(deliveryrecorddetail.getRowState())){
                continue;
            }

            //方便报表查询
            deliveryrecorddetail.setProjectId(entity.getProjectId());
            deliveryrecorddetail.setStoreId(entity.getStoreId());
            deliveryrecorddetail.setPickingTime(entity.getPickingTime());
            deliveryrecorddetail.setProjectName(entity.getProjectName());
            deliveryrecorddetail.setTenantId(entity.getTenantId());
            deliveryrecorddetail.setOrgId(entity.getOrgId());
            deliveryrecorddetail.setUnitId(entity.getPickingunitId());
            deliveryrecorddetail.setUnitName(entity.getPickingUnit());
            deliveryrecorddetail.setProjectDepartmentId(entity.getProjectDepartmentId());
        }
        List<DeliveryrecorddetailEntity> deliveryrecorddetailEntityList = entity.getDeliveryrecorddetailEntities();
        //        废旧物资退库,成品退库,资产退库的数量+成品退库+资产退库不能超过出库单本身的数量,包括自由态
        if (entity.getDeliveryTypes() == 1 || entity.getDeliveryTypes() == 5 || entity.getDeliveryTypes() == 6 || entity.getDeliveryTypes() == 7){
            //查询所有状态的进场验收数量,编辑保存时去掉本身
            if (CollectionUtils.isNotEmpty(deliveryrecorddetailEntityList)) {
                List<Long> deliveryDetailIds = deliveryrecorddetailEntityList.stream().map(DeliveryrecorddetailEntity::getDeliveryDetailId).collect(Collectors.toList());
                LambdaQueryWrapper<DeliveryrecorddetailEntity> lambdaWareDetail = Wrappers.<DeliveryrecorddetailEntity>lambdaQuery();
                lambdaWareDetail.in(DeliveryrecorddetailEntity::getDeliveryDetailId,deliveryDetailIds);
                if (saveorUpdateVO.getId() != null){
                    lambdaWareDetail.ne(DeliveryrecorddetailEntity::getMid,entity.getId());
                }
                List<DeliveryrecorddetailEntity> warehousingdetailEntityList = deliveryrecorddetailService.list(lambdaWareDetail);
                Map<Long, BigDecimal> numMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(warehousingdetailEntityList)){
                    numMap = warehousingdetailEntityList.stream().filter(s->s.getDeliveryQuantity().compareTo(BigDecimal.ZERO) == -1).collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getDeliveryDetailId,
                            Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                }
                if(CollectionUtils.isNotEmpty(deliveryrecorddetailEntityList)){
                    List<DeliveryrecorddetailEntity> deliveryrecorddetailEntities1 = deliveryrecorddetailEntityList.stream().filter(s -> s.getRowState() == null || !s.getRowState().equals("del")).collect(Collectors.toList());
                    for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntities1){
                        BigDecimal num = BigDecimal.ZERO;
                        BigDecimal numDelivery = BigDecimal.ZERO;
                        BigDecimal numAll = BigDecimal.ZERO;
                        if (numMap.containsKey(deliveryrecorddetailEntity.getDeliveryDetailId())){
                            num = numMap.get(deliveryrecorddetailEntity.getDeliveryDetailId());
                        }

                        if (entity.getDeliveryTypes() == 1 || entity.getDeliveryTypes() == 5 || entity.getDeliveryTypes() == 6){
                            numDelivery = deliveryrecorddetailEntity.getDeliveryNum();
                            numAll = deliveryrecorddetailEntity.getDeliveryQuantity();
                        }
                        if (entity.getDeliveryTypes() == 7){
                            numDelivery = deliveryrecorddetailEntity.getDeliveryQuantity();
                            numAll = deliveryrecorddetailEntity.getNotReturnedQuantity();
                        }
                        BigDecimal allZy = numDelivery.add(num).multiply(new BigDecimal(-1.00));
                        if(allZy.compareTo(numAll) ==1){
                            throw new BusinessException("物资编号:" + deliveryrecorddetailEntity.getMaterialCode() + ",物资名称:" + deliveryrecorddetailEntity.getMaterialName() + "超过剩余可退库数量,不能保存!");
                        }
                    }
                }

            }
        }
//        //直入直出推供应商不能超过入库单的数量
//        if (entity.getDeliveryTypes() == 8){
//            //查询所有状态的进场验收数量,编辑保存时去掉本身
//            if (CollectionUtils.isNotEmpty(deliveryrecorddetailEntityList)) {
//                List<Long> deliveryDetailIds = deliveryrecorddetailEntityList.stream().map(DeliveryrecorddetailEntity::getDeliveryDetailId).collect(Collectors.toList());
//                LambdaQueryWrapper<DeliveryrecorddetailEntity> lambdaWareDetail = Wrappers.<DeliveryrecorddetailEntity>lambdaQuery();
//                lambdaWareDetail.in(DeliveryrecorddetailEntity::getDeliveryDetailId,deliveryDetailIds);
//                if (saveorUpdateVO.getId() != null){
//                    lambdaWareDetail.ne(DeliveryrecorddetailEntity::getMid,entity.getId());
//                }
//                List<DeliveryrecorddetailEntity> warehousingdetailEntityList = deliveryrecorddetailService.list(lambdaWareDetail);
//                Map<Long, BigDecimal> numMap = new HashMap<>();
//                if (CollectionUtils.isNotEmpty(warehousingdetailEntityList)){
//                    numMap = warehousingdetailEntityList.stream().filter(s->s.getDeliveryQuantity().compareTo(BigDecimal.ZERO) == -1).collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getDeliveryDetailId,
//                            Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
//                }
//
//                for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList){
//                    BigDecimal num = BigDecimal.ZERO;
//                    if (numMap.containsKey(deliveryrecorddetailEntity.getDeliveryDetailId())){
//                        num = numMap.get(deliveryrecorddetailEntity.getDeliveryDetailId());
//                    }
//                    BigDecimal allZy = deliveryrecorddetailEntity.getDeliveryNum().add(num).multiply(new BigDecimal(-1.00));
//                    if(allZy.compareTo(deliveryrecorddetailEntity.getDeliveryQuantity()) ==1){
//                        throw new BusinessException("物资编号:" + deliveryrecorddetailEntity.getMaterialCode() + ",物资名称:" + deliveryrecorddetailEntity.getMaterialName() + "超过剩余可退库数量,不能保存!");
//                    }
//                }
//            }
//        }

        super.saveOrUpdate(entity, false);


        //库存流水处理,出库操作保存推送流水
        List<FlowmeterEntity> flowmeterList = new ArrayList<>();//出入库流水表
        //先删后增
        LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlower.eq(FlowmeterEntity::getMid,entity.getId());
        flowmeterService.remove(lambdaFlower);
//        涉及出库的操作:
//        0-成品出库,4-资产出库,7-直入直出推供应商(入库-退供应商,负数,实际是出库),
        if(entity.getDeliveryTypes() == 0 || entity.getDeliveryTypes() == 4){
            if (CollectionUtils.isNotEmpty(deliveryrecorddetailEntityList)){
                List<RealtimebalanceEntity> realList = new ArrayList<>();//修改实时物资结存
                for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList){
                    FlowmeterEntity flowmeterEntity = deliveryrecordBpmService.createrFlowmeter(entity, deliveryrecorddetailEntity,0,null);
                    flowmeterList.add(flowmeterEntity);
                }
                //校验是否超出剩余库存
                //通过流水校验
                //汇总数据
                List<Long> materialIds = deliveryrecorddetailEntityList.stream().map(DeliveryrecorddetailEntity::getMaterialId).collect(Collectors.toList());
                LambdaQueryWrapper<FlowmeterEntity> lambdaFlow = Wrappers.<FlowmeterEntity>lambdaQuery();
                lambdaFlow.eq(FlowmeterEntity::getStoreId, entity.getStoreId());
                lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
                if (saveorUpdateVO.getId() != null) {
                    lambdaFlow.ne(FlowmeterEntity::getMid, saveorUpdateVO.getId());
                }
                List<FlowmeterEntity> flowmeterEntityList = flowmeterService.list(lambdaFlow);
                Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                BigDecimal inNum = BigDecimal.ZERO;
                BigDecimal outNum = BigDecimal.ZERO;
                for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList){
                    inNum = BigDecimal.ZERO;
                    outNum = BigDecimal.ZERO;
                    if (numInMap.containsKey(deliveryrecorddetailEntity.getMaterialId())){
                        inNum = numInMap.get(deliveryrecorddetailEntity.getMaterialId());
                    }
                    if (numOutMap.containsKey(deliveryrecorddetailEntity.getMaterialId())){
                        outNum = numOutMap.get(deliveryrecorddetailEntity.getMaterialId());
                    }
                    BigDecimal subtract = inNum.subtract(outNum);
                    if (deliveryrecorddetailEntity.getDeliveryQuantity().compareTo(subtract) == 1){
                        throw new BusinessException("物资编号:" + deliveryrecorddetailEntity.getMaterialCode() + ",物资名称:" + deliveryrecorddetailEntity.getMaterialName() + "库存不足，不能出库!");
                    }

                }

                flowmeterService.saveBatch(flowmeterList);
                //更新实时物资结存表
                realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
            }
        }



        DeliveryrecordVO vo = BeanMapper.map(entity, DeliveryrecordVO.class);
        return vo;
    }

    @Transactional
    @Override
    public void delete(List<DeliveryrecordVO> vos) {
        //删除流水
        //先删后增
        List<Long> ids = vos.stream().map(DeliveryrecordVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<DeliveryrecordEntity> lambdaDelivery = Wrappers.<DeliveryrecordEntity>lambdaQuery();
        lambdaDelivery.in(DeliveryrecordEntity::getId,ids);
        List<DeliveryrecordEntity> deliveryrecordEntities = super.list(lambdaDelivery);

        LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlower.in(FlowmeterEntity::getMid,ids);
        flowmeterService.remove(lambdaFlower);
        //刷新实时库存
        for (DeliveryrecordEntity deliveryrecordEntity : deliveryrecordEntities){
            if (deliveryrecordEntity.getDeliveryTypes() == 0 || deliveryrecordEntity.getDeliveryTypes() == 4){
                realtimebalanceService.updateRealtimeBalance(deliveryrecordEntity.getStoreId());
            }
        }
        super.removeByIds(vos.stream().map(DeliveryrecordVO::getId).collect(Collectors.toList()),true);

    }
    @Override
    public Boolean delSupDeliveryrecord(Long billId, String dataInfo, String url, RequestMethod method, String supplierId, String operate, String billTypeCode) {
        //推送供方
        //对单据进行加锁
        Boolean locked = false;
        Boolean syncFlag = false;
        String key = billTypeCode + "::" + billId.toString();
        Jedis jedis = jedisPool.getResource();
        try {
            locked = RedisTool.tryLock(jedis, key, operate, 600);
            if (!locked) {
                releaseLock(jedis, false, key, operate);
                logger.error("单据{}推送失败，单据锁获取失败-{}！", billId, locked);
                return false;
            }
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(url, method, dataInfo, supplierId);
            if (syncReqResp.isSuccess()) {
                CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    logger.error("供方id-{}处理推送单据id-{}失败, {}", supplierId, billId, billPushResp.getMsg());
                }
            } else {
                logger.error("供方id-{}处理推送单据id-{}失败, {}", supplierId, billId, syncReqResp.getMsg());

            }
        } catch (Exception e) {
            logger.error("推送发货单单据id-{}给供方id-{} 异常，", billId, supplierId, e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, operate);
        }
        return syncFlag;
    }

    @Override
    public boolean pushBillToSupCenter(DeliveryrecordEntity materialPlanEntity, String billTypeCode) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + materialPlanEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送领料计划单据-{}失败，获取当前系统编码失败,{}", materialPlanEntity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        materialPlanEntity.setSystemId(ejcCloudSystemCode.getData());
        materialPlanEntity.setSourceId(materialPlanEntity.getId());
        materialPlanEntity.setSignStatus(1);

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupDeliveryrecordVO supMaterialPlanVO = BeanMapper.map(materialPlanEntity, SupDeliveryrecordVO.class);
            List<SupDeliveryrecorddetailVO> supMaterialPlanDetailVOS = BeanMapper.mapList(materialPlanEntity.getDeliveryrecorddetailEntities(), SupDeliveryrecorddetailVO.class);
            supMaterialPlanVO.setDeliveryrecorddetailEntityList(supMaterialPlanDetailVOS);
            supMaterialPlanVO.setId(null);
            paramMap.put("deliveryrecord", JSONObject.toJSONString(supMaterialPlanVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(materialPlanEntity.getId(), BILL_TYPE_CODE, "outType", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送领料单单据参数-{}", materialPlanEntity.getPickingunitId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        materialPlanEntity.getPickingunitId().toString(),
                        files);
//                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送领料单据id-{}失败, {}", materialPlanEntity.getPickingunitId(), materialPlanEntity.getId(), billPushResp.getMsg());
                    }
                } else {
                    logger.error("供方id-{}处理推送领料单据id-{}失败, {}", materialPlanEntity.getPickingunitId(), materialPlanEntity.getId(), syncReqResp.getMsg());

                }


//                if (syncReqResp.isSuccess()) {
//                    JSONObject jsonObject = JSONObject.parseObject(syncReqResp.getData());
//                    // 如果返回的结果包含code
//                    if(StringUtils.isNotEmpty(syncReqResp.getData())&& jsonObject.containsKey("code")){
//                        CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
//                        if (billPushResp.isSuccess()) {
//                            syncFlag = true;
//                        } else {
//                            logger.error("供方id-{}处理推送领料单单据id-{}失败, {}", materialPlanEntity.getPickingunitId(), materialPlanEntity.getId(), billPushResp.getMsg());
//                            throw new BusinessException(billPushResp.getMsg());
//                        }
//                    }else {
//                        throw new BusinessException();
//                    }
//
//                } else {
//                    logger.error("发送请求推送领料单单据id-{}给供方id-{}失败, {}", materialPlanEntity.getId(), materialPlanEntity.getPickingunitId(), syncReqResp.getMsg());
//                    throw new BusinessException(syncReqResp.getMsg());
//                }
            } else {
                logger.error("获取领料单据id-{}对应附件信息失败, {}", materialPlanEntity.getId(), fileResp.getMsg());
                throw new BusinessException(fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送领料单据id-{}给供方id-{} 异常，", materialPlanEntity.getId(), materialPlanEntity.getPickingunitId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        DeliveryrecordEntity materialPlanEntity = super.selectById(billId);
        //设置供方签字信息
        materialPlanEntity.setSupOperateTime(supOperateTime);
        materialPlanEntity.setSupOperatorName(supOperatorName);
        materialPlanEntity.setSupOperatorPhone(supOperatorPhone);
        materialPlanEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + materialPlanEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", materialPlanEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, materialPlanEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            materialPlanEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：1-未签字、2-待乙方签字、3-待甲方签字、4-已签字
            // 乙方已签字状态即待甲方签字
            materialPlanEntity.setSignStatus(2);
            //更新单据
            super.saveOrUpdate(materialPlanEntity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(materialPlanEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", materialPlanEntity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }


}
