package com.ejianc.business.outputValue.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 产值分析表（统计表）
 *
 * @author liyongjia
 *
 */
 @TableName("ejc_output_value_report")
public class OutputValueReportEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="two_org_id")
    private Long twoOrgId; // 二级组织
    @TableField(value="two_org_name")
    private String twoOrgName; // 二级组织名称

    @TableField(value="project_num")
    private Integer projectNum; // 项目序号
    @TableField(value="pc_factory")
    private String pcFactory; // 是否PC厂
    @TableField(value="project_status")
    private String projectStatus; // 项目状态

    @TableField(value="year")
    private String year; // 年度
    @TableField(value="report_month")
    private String reportMonth; // 报表月份

    @TableField(value="actual_start_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date actualStartDate; // 实际开工日期

    @TableField(value="actual_end_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date actualEndDate; // 合同竣工日期

    @TableField(value="plan_start_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date planStartDate; // 计划开工日期

    @TableField(value="plan_end_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date planEndDate; // 计划竣工日期

    @TableField(value="contract_amount")
    private BigDecimal contractAmount; // 合同额(元)
    @TableField(value="provisional_amount")
    private BigDecimal provisionalAmount; // 暂列金金额

    @TableField(value="built_area")
    private BigDecimal builtArea; // 建筑面积
    @TableField(value="this_year_accumulate_completed_output_value")
    private BigDecimal thisYearAccumulateCompletedOutputValue; // 本年完成产值
    @TableField(value="last_year_accumulate_completed_output_value")
    private BigDecimal lastYearAccumulateCompletedOutputValue; // 截止上年项目完成产值
    @TableField(value="surplus_output_value")
    private BigDecimal surplusOutputValue; // 截至上年项目剩余产值
    @TableField(value="this_year_project")
    private String thisYearProject; // 是否本年新项目
    @TableField(value="data_type")
    private String dataType; // 类型

    @TableField(value="year_plan_output_value")
    private BigDecimal yearPlanOutputValue; //年度预计/实际完成产值
    @TableField(value="january_plan_output_value")
    private BigDecimal januaryPlanOutputValue; //1月计划产值（万元）
    @TableField(value="february_plan_output_value")
    private BigDecimal februaryPlanOutputValue; //2月计划产值（万元）
    @TableField(value="march_plan_output_value")
    private BigDecimal marchPlanOutputValue; //3月计划产值（万元）
    @TableField(value="april_plan_output_value")
    private BigDecimal aprilPlanOutputValue; //4月计划产值（万元）
    @TableField(value="may_plan_output_value")
    private BigDecimal mayPlanOutputValue; //5月计划产值（万元）
    @TableField(value="june_plan_output_value")
    private BigDecimal junePlanOutputValue; //6月计划产值（万元）
    @TableField(value="july_plan_output_value")
    private BigDecimal julyPlanOutputValue; //7月计划产值（万元）
    @TableField(value="august_plan_output_value")
    private BigDecimal augustPlanOutputValue; //8月计划产值（万元）
    @TableField(value="september_plan_output_value")
    private BigDecimal septemberPlanOutputValue; //9月计划产值（万元）
    @TableField(value="october_plan_output_value")
    private BigDecimal octoberPlanOutputValue; //10月计划产值（万元）
    @TableField(value="november_plan_output_value")
    private BigDecimal novemberPlanOutputValue; //11月计划产值（万元）
    @TableField(value="december_plan_output_value")
    private BigDecimal decemberPlanOutputValue; //12月计划产值（万元）

    @TableField(value="year_actual_output_value")
    private BigDecimal yearActualOutputValue; //年度实际完成产值
    @TableField(value="january_actual_output_value")
    private BigDecimal januaryActualOutputValue; //1月实际产值（万元）
    @TableField(value="february_actual_output_value")
    private BigDecimal februaryActualOutputValue; //2月实际产值（万元）
    @TableField(value="march_actual_output_value")
    private BigDecimal marchActualOutputValue; //3月实际产值（万元）
    @TableField(value="april_actual_output_value")
    private BigDecimal aprilActualOutputValue; //4月实际产值（万元）
    @TableField(value="may_actual_output_value")
    private BigDecimal mayActualOutputValue; //5月实际产值（万元）
    @TableField(value="june_actual_output_value")
    private BigDecimal juneActualOutputValue; //6月实际产值（万元）
    @TableField(value="july_actual_output_value")
    private BigDecimal julyActualOutputValue; //7月实际产值（万元）
    @TableField(value="august_actual_output_value")
    private BigDecimal augustActualOutputValue; //8月实际产值（万元）
    @TableField(value="september_actual_output_value")
    private BigDecimal septemberActualOutputValue; //9月实际产值（万元）
    @TableField(value="october_actual_output_value")
    private BigDecimal octoberActualOutputValue; //10月实际产值（万元）
    @TableField(value="november_actual_output_value")
    private BigDecimal novemberActualOutputValue; //11月实际产值（万元）
    @TableField(value="december_actual_output_value")
    private BigDecimal decemberActualOutputValue; //12月实际产值（万元）

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }

    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(String reportMonth) {
        this.reportMonth = reportMonth;
    }

    public Integer getProjectNum() {
        return projectNum;
    }

    public void setProjectNum(Integer projectNum) {
        this.projectNum = projectNum;
    }

    public String getPcFactory() {
        return pcFactory;
    }

    public void setPcFactory(String pcFactory) {
        this.pcFactory = pcFactory;
    }

    public Date getActualStartDate() {
        return actualStartDate;
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public Date getActualEndDate() {
        return actualEndDate;
    }

    public void setActualEndDate(Date actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    public Date getPlanStartDate() {
        return planStartDate;
    }

    public void setPlanStartDate(Date planStartDate) {
        this.planStartDate = planStartDate;
    }

    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }

    public BigDecimal getProvisionalAmount() {
        return provisionalAmount;
    }

    public void setProvisionalAmount(BigDecimal provisionalAmount) {
        this.provisionalAmount = provisionalAmount;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    public BigDecimal getThisYearAccumulateCompletedOutputValue() {
        return thisYearAccumulateCompletedOutputValue;
    }

    public void setThisYearAccumulateCompletedOutputValue(BigDecimal thisYearAccumulateCompletedOutputValue) {
        this.thisYearAccumulateCompletedOutputValue = thisYearAccumulateCompletedOutputValue;
    }

    public BigDecimal getLastYearAccumulateCompletedOutputValue() {
        return lastYearAccumulateCompletedOutputValue;
    }

    public void setLastYearAccumulateCompletedOutputValue(BigDecimal lastYearAccumulateCompletedOutputValue) {
        this.lastYearAccumulateCompletedOutputValue = lastYearAccumulateCompletedOutputValue;
    }

    public BigDecimal getSurplusOutputValue() {
        return surplusOutputValue;
    }

    public void setSurplusOutputValue(BigDecimal surplusOutputValue) {
        this.surplusOutputValue = surplusOutputValue;
    }

    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    public String getThisYearProject() {
        return thisYearProject;
    }

    public void setThisYearProject(String thisYearProject) {
        this.thisYearProject = thisYearProject;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public BigDecimal getYearPlanOutputValue() {
        return yearPlanOutputValue;
    }

    public void setYearPlanOutputValue(BigDecimal yearPlanOutputValue) {
        this.yearPlanOutputValue = yearPlanOutputValue;
    }

    public BigDecimal getJanuaryPlanOutputValue() {
        return januaryPlanOutputValue;
    }

    public void setJanuaryPlanOutputValue(BigDecimal januaryPlanOutputValue) {
        this.januaryPlanOutputValue = januaryPlanOutputValue;
    }

    public BigDecimal getFebruaryPlanOutputValue() {
        return februaryPlanOutputValue;
    }

    public void setFebruaryPlanOutputValue(BigDecimal februaryPlanOutputValue) {
        this.februaryPlanOutputValue = februaryPlanOutputValue;
    }

    public BigDecimal getMarchPlanOutputValue() {
        return marchPlanOutputValue;
    }

    public void setMarchPlanOutputValue(BigDecimal marchPlanOutputValue) {
        this.marchPlanOutputValue = marchPlanOutputValue;
    }

    public BigDecimal getAprilPlanOutputValue() {
        return aprilPlanOutputValue;
    }

    public void setAprilPlanOutputValue(BigDecimal aprilPlanOutputValue) {
        this.aprilPlanOutputValue = aprilPlanOutputValue;
    }

    public BigDecimal getMayPlanOutputValue() {
        return mayPlanOutputValue;
    }

    public void setMayPlanOutputValue(BigDecimal mayPlanOutputValue) {
        this.mayPlanOutputValue = mayPlanOutputValue;
    }

    public BigDecimal getJunePlanOutputValue() {
        return junePlanOutputValue;
    }

    public void setJunePlanOutputValue(BigDecimal junePlanOutputValue) {
        this.junePlanOutputValue = junePlanOutputValue;
    }

    public BigDecimal getJulyPlanOutputValue() {
        return julyPlanOutputValue;
    }

    public void setJulyPlanOutputValue(BigDecimal julyPlanOutputValue) {
        this.julyPlanOutputValue = julyPlanOutputValue;
    }

    public BigDecimal getAugustPlanOutputValue() {
        return augustPlanOutputValue;
    }

    public void setAugustPlanOutputValue(BigDecimal augustPlanOutputValue) {
        this.augustPlanOutputValue = augustPlanOutputValue;
    }

    public BigDecimal getSeptemberPlanOutputValue() {
        return septemberPlanOutputValue;
    }

    public void setSeptemberPlanOutputValue(BigDecimal septemberPlanOutputValue) {
        this.septemberPlanOutputValue = septemberPlanOutputValue;
    }

    public BigDecimal getOctoberPlanOutputValue() {
        return octoberPlanOutputValue;
    }

    public void setOctoberPlanOutputValue(BigDecimal octoberPlanOutputValue) {
        this.octoberPlanOutputValue = octoberPlanOutputValue;
    }

    public BigDecimal getNovemberPlanOutputValue() {
        return novemberPlanOutputValue;
    }

    public void setNovemberPlanOutputValue(BigDecimal novemberPlanOutputValue) {
        this.novemberPlanOutputValue = novemberPlanOutputValue;
    }

    public BigDecimal getDecemberPlanOutputValue() {
        return decemberPlanOutputValue;
    }

    public void setDecemberPlanOutputValue(BigDecimal decemberPlanOutputValue) {
        this.decemberPlanOutputValue = decemberPlanOutputValue;
    }

    public BigDecimal getYearActualOutputValue() {
        return yearActualOutputValue;
    }

    public void setYearActualOutputValue(BigDecimal yearActualOutputValue) {
        this.yearActualOutputValue = yearActualOutputValue;
    }

    public BigDecimal getJanuaryActualOutputValue() {
        return januaryActualOutputValue;
    }

    public void setJanuaryActualOutputValue(BigDecimal januaryActualOutputValue) {
        this.januaryActualOutputValue = januaryActualOutputValue;
    }

    public BigDecimal getFebruaryActualOutputValue() {
        return februaryActualOutputValue;
    }

    public void setFebruaryActualOutputValue(BigDecimal februaryActualOutputValue) {
        this.februaryActualOutputValue = februaryActualOutputValue;
    }

    public BigDecimal getMarchActualOutputValue() {
        return marchActualOutputValue;
    }

    public void setMarchActualOutputValue(BigDecimal marchActualOutputValue) {
        this.marchActualOutputValue = marchActualOutputValue;
    }

    public BigDecimal getAprilActualOutputValue() {
        return aprilActualOutputValue;
    }

    public void setAprilActualOutputValue(BigDecimal aprilActualOutputValue) {
        this.aprilActualOutputValue = aprilActualOutputValue;
    }

    public BigDecimal getMayActualOutputValue() {
        return mayActualOutputValue;
    }

    public void setMayActualOutputValue(BigDecimal mayActualOutputValue) {
        this.mayActualOutputValue = mayActualOutputValue;
    }

    public BigDecimal getJuneActualOutputValue() {
        return juneActualOutputValue;
    }

    public void setJuneActualOutputValue(BigDecimal juneActualOutputValue) {
        this.juneActualOutputValue = juneActualOutputValue;
    }

    public BigDecimal getJulyActualOutputValue() {
        return julyActualOutputValue;
    }

    public void setJulyActualOutputValue(BigDecimal julyActualOutputValue) {
        this.julyActualOutputValue = julyActualOutputValue;
    }

    public BigDecimal getAugustActualOutputValue() {
        return augustActualOutputValue;
    }

    public void setAugustActualOutputValue(BigDecimal augustActualOutputValue) {
        this.augustActualOutputValue = augustActualOutputValue;
    }

    public BigDecimal getSeptemberActualOutputValue() {
        return septemberActualOutputValue;
    }

    public void setSeptemberActualOutputValue(BigDecimal septemberActualOutputValue) {
        this.septemberActualOutputValue = septemberActualOutputValue;
    }

    public BigDecimal getOctoberActualOutputValue() {
        return octoberActualOutputValue;
    }

    public void setOctoberActualOutputValue(BigDecimal octoberActualOutputValue) {
        this.octoberActualOutputValue = octoberActualOutputValue;
    }

    public BigDecimal getNovemberActualOutputValue() {
        return novemberActualOutputValue;
    }

    public void setNovemberActualOutputValue(BigDecimal novemberActualOutputValue) {
        this.novemberActualOutputValue = novemberActualOutputValue;
    }

    public BigDecimal getDecemberActualOutputValue() {
        return decemberActualOutputValue;
    }

    public void setDecemberActualOutputValue(BigDecimal decemberActualOutputValue) {
        this.decemberActualOutputValue = decemberActualOutputValue;
    }
}
