package com.ejianc.business.outputValue.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementChangeEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementRecordEntity;
import com.ejianc.business.outputValue.service.IProjectSupplementChangeService;
import com.ejianc.business.outputValue.service.IProjectSupplementRecordService;
import com.ejianc.business.outputValue.service.IProjectSupplementService;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueChangeVO;
import com.ejianc.business.outputValue.vo.ProjectSupplementChangeVO;
import com.ejianc.business.outputValue.vo.ProjectSupplementRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 项目信息补充与维护
 *
 */
@RestController
@RequestMapping("/projectSupplementChange/")
public class ProjectSupplementChangeController {

	@Autowired
	private IProjectSupplementService projectSupplementService;
	@Autowired
	private IProjectSupplementChangeService changeService;
	@Autowired
	private IProjectSupplementRecordService recordService;

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectSupplementChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgShortName");
        fuzzyFields.add("year");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(param.getParams().get("dataId")==null){
        	throw new BusinessException("缺少公司经营指标id");
        }
        IPage<ProjectSupplementChangeEntity> page = changeService.queryPage(param,false);
        IPage<ProjectSupplementChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectSupplementChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByDataId")
    public CommonResponse<ProjectSupplementChangeVO> queryDetailByDataId(@RequestParam(value = "dataId") Long dataId) {
        ProjectSupplementEntity projectEntity = projectSupplementService.selectById(dataId);
        ProjectSupplementChangeVO changeVO = BeanMapper.map(projectEntity, ProjectSupplementChangeVO.class);
        changeVO.setDataId(dataId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(null);
        changeVO.setUpdateUserCode(null);
        return CommonResponse.success("查询详情成功！", changeVO);
    	
    }
    
    /**
     * 查询变更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetail")
    public CommonResponse<ProjectSupplementChangeVO> queryDetail(@RequestParam(value = "id") Long id) {
        ProjectSupplementChangeEntity entity = changeService.selectById(id);
        ProjectSupplementChangeVO vo = BeanMapper.map(entity, ProjectSupplementChangeVO.class);

        //当前单据变更过则显示变更记录
//        QueryWrapper<ProjectSupplementRecordEntity> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("dr", 0);
//        queryWrapper.eq("data_id", vo.getDataId());
//        List<ProjectSupplementRecordEntity> records = recordService.list(queryWrapper);
//        if(records!=null&&records.size()>0){
//            vo.setRecordList(BeanMapper.mapList(records, ProjectSupplementRecordVO.class));
//        }
        return CommonResponse.success("查询详情成功！", vo);
    	
    }

    /**
     * 项目申请保存/更新
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "saveChange")
    public CommonResponse<ProjectSupplementChangeVO> saveChange(@RequestBody ProjectSupplementChangeVO vo) {
    	return changeService.saveChange(vo);
    	
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectSupplementChangeVO> vos) {
        return changeService.delete(vos);
    }

}
