package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaEntity;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueChangeEntity;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueRecordEntity;
import com.ejianc.business.outputValue.mapper.ProjectMonthActualOutputValueChangeMapper;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueChangeService;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueRecordService;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueService;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目月度计划产值
 * 
 * @author generator
 * 
 */
@Service("projectMonthActualOutputValueChangeService")
public class ProjectMonthActualOutputValueChangeServiceImpl extends BaseServiceImpl<ProjectMonthActualOutputValueChangeMapper, ProjectMonthActualOutputValueChangeEntity> implements IProjectMonthActualOutputValueChangeService {

    @Autowired
    private IProjectMonthActualOutputValueService projectMonthActualOutputValueService;
    @Autowired
    private IProjectMonthActualOutputValueRecordService recordService;
    @Override
    public CommonResponse<ProjectMonthActualOutputValueChangeVO> saveChange(ProjectMonthActualOutputValueChangeVO saveorUpdateVO) {
        ProjectMonthActualOutputValueChangeEntity entity = BeanMapper.map(saveorUpdateVO, ProjectMonthActualOutputValueChangeEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ProjectMonthActualOutputValueChangeEntity> queryWrapper = new QueryWrapper<ProjectMonthActualOutputValueChangeEntity>();
        queryWrapper.eq("data_id", saveorUpdateVO.getDataId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 0,4);
        if(saveorUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<ProjectMonthActualOutputValueChangeEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //检验该单据是否是当前项目最新的单据，若是则允许变更，否则不允许；
        QueryWrapper<ProjectMonthActualOutputValueEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", saveorUpdateVO.getProjectId());
        wrapper.eq("year", saveorUpdateVO.getYear());
        wrapper.eq("dr", 0);
        wrapper.orderByDesc("month");
        List<ProjectMonthActualOutputValueEntity> companyUndertakeQuotaList = projectMonthActualOutputValueService.list(wrapper);
        if(companyUndertakeQuotaList!=null && companyUndertakeQuotaList.size()>0){
            if(!saveorUpdateVO.getMonth().equals(companyUndertakeQuotaList.get(0).getMonth())){
                throw new BusinessException("只能变更该项目最新的数据");
            }
        }

        this.saveOrUpdate(entity, false);
        ProjectMonthActualOutputValueChangeVO vo = BeanMapper.map(entity, ProjectMonthActualOutputValueChangeVO.class);
        vo.setRecordList(saveorUpdateVO.getRecordList());
        //查询当前合同信息，将状态改为变更中
        ProjectMonthActualOutputValueEntity projectMonthActualOutputValueEntity = projectMonthActualOutputValueService.selectById(vo.getDataId());
        projectMonthActualOutputValueEntity.setChangeState("2");//状态改为变更中
        projectMonthActualOutputValueEntity.setChangeId(vo.getId());
        projectMonthActualOutputValueService.saveOrUpdate(projectMonthActualOutputValueEntity, false);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<ProjectMonthActualOutputValueChangeVO> vos) {
        for(ProjectMonthActualOutputValueChangeVO vo : vos){
            ProjectMonthActualOutputValueChangeEntity entity = this.getById(vo.getId());
            ProjectMonthActualOutputValueEntity projectMonthActualOutputValueEntity = projectMonthActualOutputValueService.selectById(entity.getDataId());
            QueryWrapper<ProjectMonthActualOutputValueRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("data_id", projectMonthActualOutputValueEntity.getId());
            List<ProjectMonthActualOutputValueRecordEntity> records = recordService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                projectMonthActualOutputValueEntity.setChangeState("3");//状态改为已变更
            }else{
                projectMonthActualOutputValueEntity.setChangeState("1");//状态改为未变更
            }
            projectMonthActualOutputValueEntity.setChangeId(null);
            projectMonthActualOutputValueService.saveOrUpdate(projectMonthActualOutputValueEntity, false);
        }
        this.removeByIds(vos.stream().map(ProjectMonthActualOutputValueChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
