package com.ejianc.business.outputValue.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 产值分析表（统计表）
 *
 * @author generator
 *
 */
public class OutputValueReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long rowId; //
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long twoOrgId; // 二级组织
    private String twoOrgName; // 二级组织名称
    private String year; // 年度
    private String reportMonth; // 报表月份

    private Integer projectNum; // 项目序号
    private String pcFactory; // 是否PC厂

    private String actualStartDateString; // 实际开工日期

    private String actualEndDateString; // 合同竣工日期

    private String planStartDateString; // 计划开工日期

    private String planEndDateString; // 计划竣工日期

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date actualStartDate; // 实际开工日期

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date actualEndDate; // 合同竣工日期

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date planStartDate; // 计划开工日期

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date planEndDate; // 计划竣工日期

    private BigDecimal contractAmount; // 合同额(元)
    private BigDecimal provisionalAmount; // 暂列金金额

    private BigDecimal builtArea; // 建筑面积
    private BigDecimal thisYearAccumulateCompletedOutputValue; // 本年完成产值
    private BigDecimal lastYearAccumulateCompletedOutputValue; // 截止上年项目完成产值
    private BigDecimal surplusOutputValue; // 截至上年项目剩余产值
    private String projectStatus; // 项目状态
    private String thisYearProject; // 是否本年新项目
    private String dataType; // 类型
    private BigDecimal yearOutputValue; //年度预计/实际完成产值
    private BigDecimal januaryOutputValue; //1月计划/实际产值（万元）
    private BigDecimal februaryOutputValue; //2月计划/实际产值（万元）
    private BigDecimal marchOutputValue; //3月计划/实际产值（万元）
    private BigDecimal aprilOutputValue; //4月计划/实际产值（万元）
    private BigDecimal mayOutputValue; //5月计划产/实际值（万元）
    private BigDecimal juneOutputValue; //6月计划/实际产值（万元）
    private BigDecimal julyOutputValue; //7月计划/实际产值（万元）
    private BigDecimal augustOutputValue; //8月计划/实际产值（万元）
    private BigDecimal septemberOutputValue; //9月计划/实际产值（万元）
    private BigDecimal octoberOutputValue; //10月计划/实际产值（万元）
    private BigDecimal novemberOutputValue; //11月计划/实际产值（万元）
    private BigDecimal decemberOutputValue; //12月计划/实际产值（万元）

    private String projectBuiltArea; // 建筑面积

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }

    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(String reportMonth) {
        this.reportMonth = reportMonth;
    }

    public Integer getProjectNum() {
        return projectNum;
    }

    public void setProjectNum(Integer projectNum) {
        this.projectNum = projectNum;
    }

    public String getPcFactory() {
        return pcFactory;
    }

    public void setPcFactory(String pcFactory) {
        this.pcFactory = pcFactory;
    }

    public String getActualStartDateString() {
        return actualStartDateString;
    }

    public void setActualStartDateString(String actualStartDateString) {
        this.actualStartDateString = actualStartDateString;
    }

    public String getActualEndDateString() {
        return actualEndDateString;
    }

    public void setActualEndDateString(String actualEndDateString) {
        this.actualEndDateString = actualEndDateString;
    }

    public String getPlanStartDateString() {
        return planStartDateString;
    }

    public void setPlanStartDateString(String planStartDateString) {
        this.planStartDateString = planStartDateString;
    }

    public String getPlanEndDateString() {
        return planEndDateString;
    }

    public void setPlanEndDateString(String planEndDateString) {
        this.planEndDateString = planEndDateString;
    }

    public Date getActualStartDate() {
        return actualStartDate;
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public Date getActualEndDate() {
        return actualEndDate;
    }

    public void setActualEndDate(Date actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    public Date getPlanStartDate() {
        return planStartDate;
    }

    public void setPlanStartDate(Date planStartDate) {
        this.planStartDate = planStartDate;
    }

    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }

    public BigDecimal getProvisionalAmount() {
        return provisionalAmount;
    }

    public void setProvisionalAmount(BigDecimal provisionalAmount) {
        this.provisionalAmount = provisionalAmount;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    public BigDecimal getThisYearAccumulateCompletedOutputValue() {
        return thisYearAccumulateCompletedOutputValue;
    }

    public void setThisYearAccumulateCompletedOutputValue(BigDecimal thisYearAccumulateCompletedOutputValue) {
        this.thisYearAccumulateCompletedOutputValue = thisYearAccumulateCompletedOutputValue;
    }

    public BigDecimal getLastYearAccumulateCompletedOutputValue() {
        return lastYearAccumulateCompletedOutputValue;
    }

    public void setLastYearAccumulateCompletedOutputValue(BigDecimal lastYearAccumulateCompletedOutputValue) {
        this.lastYearAccumulateCompletedOutputValue = lastYearAccumulateCompletedOutputValue;
    }

    public BigDecimal getSurplusOutputValue() {
        return surplusOutputValue;
    }

    public void setSurplusOutputValue(BigDecimal surplusOutputValue) {
        this.surplusOutputValue = surplusOutputValue;
    }

    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    public String getThisYearProject() {
        return thisYearProject;
    }

    public void setThisYearProject(String thisYearProject) {
        this.thisYearProject = thisYearProject;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public BigDecimal getYearOutputValue() {
        return yearOutputValue;
    }

    public void setYearOutputValue(BigDecimal yearOutputValue) {
        this.yearOutputValue = yearOutputValue;
    }

    public BigDecimal getJanuaryOutputValue() {
        return januaryOutputValue;
    }

    public void setJanuaryOutputValue(BigDecimal januaryOutputValue) {
        this.januaryOutputValue = januaryOutputValue;
    }

    public BigDecimal getFebruaryOutputValue() {
        return februaryOutputValue;
    }

    public void setFebruaryOutputValue(BigDecimal februaryOutputValue) {
        this.februaryOutputValue = februaryOutputValue;
    }

    public BigDecimal getMarchOutputValue() {
        return marchOutputValue;
    }

    public void setMarchOutputValue(BigDecimal marchOutputValue) {
        this.marchOutputValue = marchOutputValue;
    }

    public BigDecimal getAprilOutputValue() {
        return aprilOutputValue;
    }

    public void setAprilOutputValue(BigDecimal aprilOutputValue) {
        this.aprilOutputValue = aprilOutputValue;
    }

    public BigDecimal getMayOutputValue() {
        return mayOutputValue;
    }

    public void setMayOutputValue(BigDecimal mayOutputValue) {
        this.mayOutputValue = mayOutputValue;
    }

    public BigDecimal getJuneOutputValue() {
        return juneOutputValue;
    }

    public void setJuneOutputValue(BigDecimal juneOutputValue) {
        this.juneOutputValue = juneOutputValue;
    }

    public BigDecimal getJulyOutputValue() {
        return julyOutputValue;
    }

    public void setJulyOutputValue(BigDecimal julyOutputValue) {
        this.julyOutputValue = julyOutputValue;
    }

    public BigDecimal getAugustOutputValue() {
        return augustOutputValue;
    }

    public void setAugustOutputValue(BigDecimal augustOutputValue) {
        this.augustOutputValue = augustOutputValue;
    }

    public BigDecimal getSeptemberOutputValue() {
        return septemberOutputValue;
    }

    public void setSeptemberOutputValue(BigDecimal septemberOutputValue) {
        this.septemberOutputValue = septemberOutputValue;
    }

    public BigDecimal getOctoberOutputValue() {
        return octoberOutputValue;
    }

    public void setOctoberOutputValue(BigDecimal octoberOutputValue) {
        this.octoberOutputValue = octoberOutputValue;
    }

    public BigDecimal getNovemberOutputValue() {
        return novemberOutputValue;
    }

    public void setNovemberOutputValue(BigDecimal novemberOutputValue) {
        this.novemberOutputValue = novemberOutputValue;
    }

    public BigDecimal getDecemberOutputValue() {
        return decemberOutputValue;
    }

    public void setDecemberOutputValue(BigDecimal decemberOutputValue) {
        this.decemberOutputValue = decemberOutputValue;
    }

    public Long getRowId() {
        return rowId;
    }

    public void setRowId(Long rowId) {
        this.rowId = rowId;
    }

    public String getProjectBuiltArea() {
        return projectBuiltArea;
    }

    public void setProjectBuiltArea(String projectBuiltArea) {
        this.projectBuiltArea = projectBuiltArea;
    }
}
