package com.ejianc.business.panhuo.apply.service.impl;

import com.ejianc.business.panhuo.apply.bean.AllotApplyDetailEntity;
import com.ejianc.business.panhuo.apply.bean.AllotApplyEntity;
import com.ejianc.business.panhuo.apply.service.IAllotApplyService;
import com.ejianc.business.panhuo.order.service.IAllotOrderService;
import com.ejianc.foundation.panhuo.apply.vo.AllotApplyVO;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.foundation.panhuo.shelf.vo.GoodsVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("allotApply") 
public class AllotApplyBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IAllotApplyService service;
	@Autowired
	private IGoodsService goodsService;

	@Autowired
	private IAllotOrderService orderService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		AllotApplyEntity entity = service.selectById(billId);
		if (entity.getDetailList().size()>0||CollectionUtils.isNotEmpty(entity.getDetailList())){
			// 验调拨量是否大于上架数量
			List<AllotApplyDetailEntity> detailList = entity.getDetailList();
			List<Long> collect = detailList.stream().map(e -> e.getSourceId()).collect(Collectors.toList());
			Map<Long, BigDecimal> allotableNum = goodsService.getAllotableNum(collect);
			for (AllotApplyDetailEntity detail: detailList){
				if (allotableNum.containsKey(detail.getSourceId())){
					BigDecimal decimal = allotableNum.get(detail.getSourceId());
					if (ComputeUtil.isGreaterThan(detail.getAllotNum(),decimal)){
						return CommonResponse.error("物资："+detail.getMaterialName()+"调拨量大于上架数量!");
					}
				}
			}
			UserContext user = sessionManager.getUserContext();
			entity.setCommitDate(new Date());
			entity.setCommitUserCode(user.getUserCode());
			entity.setCommitUserId(user.getUserId());
			entity.setCommitUserName(user.getUserName());
			service.saveOrUpdate(entity, false);

			return CommonResponse.success();
		}else {
			return CommonResponse.error("物资明细为空，不允许提交！");
		}
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AllotApplyEntity entity = service.selectById(billId);
		if(state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			entity.setEffectDate(new Date());
		}

		if (null==entity){
			throw new BusinessException("网络异常,未查询到对应调拨申请");
		}
		service.upShopCart(entity);
		// TODO 验调拨量是否大于上架数量
		List<AllotApplyDetailEntity> detailList = entity.getDetailList();
		List<Long> collect = detailList.stream().map(e -> e.getSourceId()).collect(Collectors.toList());
		Map<Long, BigDecimal> allotableNum = goodsService.getAllotableNum(collect);
		for (AllotApplyDetailEntity detail: detailList){
			if (allotableNum.containsKey(detail.getSourceId())){
				BigDecimal decimal = allotableNum.get(detail.getSourceId());
				if (ComputeUtil.isGreaterThan(detail.getAllotNum(),decimal)){
					return CommonResponse.error("物资："+detail.getMaterialName()+"调拨量大于上架数量!");
				}
			}
		}
		// TODO 回写调拨数量
		if (CollectionUtils.isNotEmpty(entity.getDetailList())){
			List<GoodsVO> goodsVOList = new ArrayList<>();
			for (AllotApplyDetailEntity detail:detailList){
				GoodsVO goodsVO = new GoodsVO();
				goodsVO.setId(detail.getSourceId());
				goodsVO.setAllotNum(detail.getAllotNum());
				goodsVOList.add(goodsVO);
			}
			goodsService.updateAllotNum(goodsVOList,true);
		}
		//TODO 删除购物车
		service.upShopCart(entity);
		//TODO 生成订单
		orderService.saveNewOrderByApply(BeanMapper.map(entity, AllotApplyVO.class));
		//TODO 发送订单消息 //发送邮件

		
		service.saveOrUpdate(entity, false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("调拨申请无法弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
