package com.ejianc.business.panhuo.order.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.apply.bean.AllotApplyEntity;
import com.ejianc.business.panhuo.order.bean.AllotOrderEntity;
import com.ejianc.foundation.panhuo.constants.AllotOrderBusinessStatusEnums;
import com.ejianc.business.panhuo.apply.service.IAllotApplyService;
import com.ejianc.business.panhuo.order.service.IAllotOrderService;
import com.ejianc.foundation.panhuo.apply.vo.AllotApplyVO;
import com.ejianc.foundation.panhuo.order.vo.AllotOrderDetailVO;
import com.ejianc.foundation.panhuo.order.vo.AllotOrderVO;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 调拨订单
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("allotOrder")
public class AllotOrderController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IAllotOrderService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private IAllotApplyService allotApplyService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
//    @OperationLog(events = "调拨订单编辑/入库编辑", handlerName = "allotOrderOperationRecordService")
    public CommonResponse<AllotOrderVO> saveOrUpdate(@RequestBody AllotOrderVO saveOrUpdateVO) {
    	AllotOrderEntity entity = BeanMapper.map(saveOrUpdateVO, AllotOrderEntity.class);
        AllotOrderVO vo = null;
    	if("saveEdit".equals(saveOrUpdateVO.getOprType())) {
            if(entity.getEditNum() >= 1) {
                return CommonResponse.error("保存失败，订单不支持多次修改");
            }
            vo = service.saveEditAllotOrderInfo(entity);
        } else {
            vo = service.saveOrderInStoreEdit(entity);
        }
    	return queryDetail(vo.getId());
    }

    @PostMapping(value = "/saveInStore")
//    @OperationLog(events = "调拨订单入库", handlerName = "allotOrderOperationRecordService")
    public CommonResponse<AllotOrderVO> saveInStore(@RequestBody AllotOrderVO saveOrUpdateVO) {
        AllotOrderVO vo = service.saveOrderInStore(service.selectById(saveOrUpdateVO.getId()));
        return queryDetail(vo.getId());
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<AllotOrderVO> queryDetail(Long id) {
    	AllotOrderEntity entity = service.selectById(id);
    	AllotOrderVO vo = BeanMapper.map(entity, AllotOrderVO.class);

    	List<Long> materialMarketIds = vo.getAllotOrderDetailList().stream().map(AllotOrderDetailVO::getSourceId).collect(Collectors.toList());

        Map<Long,BigDecimal> materialOrderAvailableNum = goodsService.getAllotableNum(materialMarketIds);
        vo.getAllotOrderDetailList().stream().forEach(detail -> {
            detail.setBeforeMemo(detail.getMemo());
            detail.setOrderAvailableNum(AllotOrderBusinessStatusEnums.调入方取消.getCode().equals(entity.getBusinessStatus())
                    || AllotOrderBusinessStatusEnums.调出方取消.getCode().equals(entity.getBusinessStatus())
                    || AllotOrderBusinessStatusEnums.交易完成.getCode().equals(entity.getBusinessStatus()) ?
                    materialOrderAvailableNum.get(detail.getSourceId()) : ComputeUtil.safeAdd(materialOrderAvailableNum.get(detail.getSourceId()), detail.getAllotNum()));
        });

        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<AllotOrderVO>> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("outProjectName");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("inCorpName");
        fuzzyFields.add("categoryNames");
        fuzzyFields.add("purUserName");
        fuzzyFields.add("purUserPhone");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Map<String, Parameter> params = param.getParams();
        if(null == params.get("storeType")) {
            return CommonResponse.error("查询失败，参数storeType为空！");
        }
        if(null == params.get("queryType")) { //out 调出  in 调入
            return CommonResponse.error("查询失败，参数queryType为空！");
        }

        String queryType = params.get("queryType").getValue().toString();
        params.remove("queryType");

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put(queryType+"ParentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put(queryType+"OrgId", new Parameter(QueryParam.IN, departmentIds));
        }
        if(null == params.get("businessStatus")) {
            if(null == params.get("pageType")) { //pending-待处理  dealed-已成交  canceled-已取消
                return CommonResponse.error("查询失败，参数pageType为空！");
            }

            if("pending".equals(params.get("pageType").getValue().toString())) {
                params.put("businessStatus", new Parameter(QueryParam.IN, "1,2,3,4"));
            } else if("dealed".equals(params.get("pageType").getValue().toString())) {
                params.put("businessStatus", new Parameter(QueryParam.IN, "5,6"));
            } else {
                params.put("businessStatus", new Parameter(QueryParam.IN, "7,8"));
            }

            params.remove("pageType");
        }

        if(null != params.get("myOrderFlag")) {
            if(params.get("myOrderFlag").getValue().toString().indexOf("2") < 0) { //我预定的
                params.put("purUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            }
            params.remove("myOrderFlag");
        }

        IPage<AllotOrderEntity> page = service.queryPage(param,false);
        IPage<AllotOrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllotOrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        Map<String, Parameter> params = param.getParams();
        if(null == params.get("storeType")) {
            throw new BusinessException("查询失败，参数storeType为空！");
        }
        if(null == params.get("queryType")) { //out 调出  in 调入
            throw new BusinessException("查询失败，参数queryType为空！");
        }

        String queryType = params.get("queryType").getValue().toString();
        params.remove("queryType");

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put(queryType+"ParentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put(queryType+"OrgId", new Parameter(QueryParam.IN, departmentIds));
        }
        if(null == params.get("businessStatus")) {
            if(null == params.get("pageType")) { //pending-待处理  dealed-已成交  canceled-已取消
                throw new BusinessException("查询失败，参数pageType为空！");
            }

            if("pending".equals(params.get("pageType").getValue().toString())) {
                params.put("businessStatus", new Parameter(QueryParam.IN, "1,2,3,4"));
            } else if("dealed".equals(params.get("pageType").getValue().toString())) {
                params.put("businessStatus", new Parameter(QueryParam.IN, "5,6"));
            } else {
                params.put("businessStatus", new Parameter(QueryParam.IN, "7,8"));
            }
            params.remove("pageType");
        }


        String exportExcelName = "AllotOrder-project-export.xlsx";
        String exportTitle = "调出订单列表";

        if(params.get("storeType").getValue().toString().equals("2")) {
            exportExcelName = "AllotOrder-org-export.xlsx";
        }
        if("in".equals(queryType)) {
            exportTitle = "调入订单列表";
            exportExcelName = "AllotOrder-org-export.xlsx";
        }

        if("canceled".equals(params.get("pageType").getValue().toString())) {
            //已取消列表导出
            exportExcelName = exportExcelName.replace("-export", "-canceled-export");
        }

        if(null != params.get("myOrderFlag")) {
            if(params.get("myOrderFlag").getValue().toString().indexOf("2") < 0) { //我预定的
                params.put("purUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            }
            params.remove("myOrderFlag");
        }

        List<AllotOrderEntity> list = service.queryList(param);
        list.stream().forEach(item -> {
            item.setBusinessStatusName(AllotOrderBusinessStatusEnums.getNameByCode(item.getBusinessStatus()));
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", BeanMapper.mapList(list, AllotOrderVO.class));
        ExcelExport.getInstance().exportWithTrans(exportExcelName, beans, response, exportTitle);
    }

    /**
     * 调拨订单取消
     *
     * @return
     */
    @PostMapping(value = "/cancelOrder")
//    @OperationLog(events = "调拨订单取消", handlerName = "allotOrderOperationRecordService")
    public CommonResponse<String> cancelOrder(@RequestBody AllotOrderVO allotOrderVO) {
        AllotOrderEntity order = service.selectById(allotOrderVO.getId());
        if(!AllotOrderBusinessStatusEnums.调入方洽商待确认.getCode().equals(order.getBusinessStatus())
                && !AllotOrderBusinessStatusEnums.调出方待确认.getCode().equals(order.getBusinessStatus())
                && !AllotOrderBusinessStatusEnums.调入方待收货.getCode().equals(order.getBusinessStatus())) {
            return CommonResponse.error("操作失败，当前订单状态不支持此操作");
        }

        service.cancelOrder(order);

        return CommonResponse.success("操作成功！");
    }

    /**
     * 调入方确认订单
     *
     * @param allotOrderVO
     * @return
     */
    @PostMapping(value = "/confirmOrder")
//    @OperationLog(events = "调入方调拨订单确认", handlerName = "allotOrderOperationRecordService")
    public CommonResponse<String> confirmOrder(@RequestBody AllotOrderVO allotOrderVO) {
        service.confirmOrder(allotOrderVO.getId());
        return CommonResponse.success("操作成功！");
    }

}
