package com.ejianc.business.panhuo.shelf.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 物资上架申请
 *
 * @author generator
 *
 */
 @TableName("ejc_material_shelf")
public class ShelfEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_code")
    private String orgCode; // 所属单位编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织name
    @TableField(value="material_type_names")
    private String materialTypeNames; // 物料分类名称
    @TableField(value="address")
    private String address; // 地址
    @TableField(value="sell_user_id")
    private Long sellUserId; // 联系人
    @TableField(value="seller_user_code")
    private String sellerUserCode; // 联系人编码
    @TableField(value="sell_user_name")
    private String sellUserName; // 联系人名称
    @TableField(value="sell_user_phone")
    private String sellUserPhone; // 联系人电话
    @TableField(value="nums")
    private BigDecimal nums; // 上架数量
    @TableField(value="shelf_mny")
    private BigDecimal shelfMny; // 上架总金额
    @TableField(value="shelf_tax_mny")
    private BigDecimal shelfTaxMny; // 上架总金额(含税)
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="corp_id")
    private Long corpId; // 分子公司
    @TableField(value="corp_code")
    private String corpCode; // 分子公司编码
    @TableField(value="corp_name")
    private String corpName; // 分子公司名称
    @TableField(value="store_type")
    private Integer storeType; // 仓库类型 1-项目；2-大区
    @TableField(value="cloud_store_id")
    private Long cloudStoreId; // 云仓id
    @TableField(value="cloud_store_name")
    private String cloudStoreName; // 云仓名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value = "create_user_id")
    private Long createUserId;// 制单人Id


    @TableField(exist=false)
    @SubEntity(serviceName="shelfDetailService",pidName = "shelfId")
    private List<ShelfDetailEntity> detailList = new ArrayList<>(); // 物资上架申请清单


    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Long getSellUserId() {
        return sellUserId;
    }

    public void setSellUserId(Long sellUserId) {
        this.sellUserId = sellUserId;
    }
    public String getSellerUserCode() {
        return sellerUserCode;
    }

    public void setSellerUserCode(String sellerUserCode) {
        this.sellerUserCode = sellerUserCode;
    }
    public String getSellUserName() {
        return sellUserName;
    }

    public void setSellUserName(String sellUserName) {
        this.sellUserName = sellUserName;
    }
    public String getSellUserPhone() {
        return sellUserPhone;
    }

    public void setSellUserPhone(String sellUserPhone) {
        this.sellUserPhone = sellUserPhone;
    }
    public BigDecimal getNums() {
        return nums;
    }

    public void setNums(BigDecimal nums) {
        this.nums = nums;
    }
    public BigDecimal getShelfMny() {
        return shelfMny;
    }

    public void setShelfMny(BigDecimal shelfMny) {
        this.shelfMny = shelfMny;
    }
    public BigDecimal getShelfTaxMny() {
        return shelfTaxMny;
    }

    public void setShelfTaxMny(BigDecimal shelfTaxMny) {
        this.shelfTaxMny = shelfTaxMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }
    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }
    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }
    public Long getCloudStoreId() {
        return cloudStoreId;
    }

    public void setCloudStoreId(Long cloudStoreId) {
        this.cloudStoreId = cloudStoreId;
    }
    public String getCloudStoreName() {
        return cloudStoreName;
    }

    public void setCloudStoreName(String cloudStoreName) {
        this.cloudStoreName = cloudStoreName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public List<ShelfDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ShelfDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
